/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.inputHtml;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.custom.inputHtml.InputHtml;
import org.apache.myfaces.custom.tabbedpane.HtmlPanelTab;
import org.apache.myfaces.custom.tabbedpane.HtmlPanelTabbedPane;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.FormInfo;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.HTMLEncoder;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.JavascriptUtils;

public class InputHtmlRenderer
extends HtmlRenderer {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$shared_tomahawk$renderkit$html$HtmlRendererUtils == null ? (class$org$apache$myfaces$shared_tomahawk$renderkit$html$HtmlRendererUtils = InputHtmlRenderer.class$("org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils")) : class$org$apache$myfaces$shared_tomahawk$renderkit$html$HtmlRendererUtils));
    static /* synthetic */ Class class$org$apache$myfaces$shared_tomahawk$renderkit$html$HtmlRendererUtils;
    static /* synthetic */ Class class$org$apache$myfaces$custom$inputHtml$InputHtml;
    static /* synthetic */ Class class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer;

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (!UserRoleUtils.isEnabledOnUserRole(uiComponent)) {
            return false;
        }
        return ((InputHtml)uiComponent).isDisabled();
    }

    private static boolean useFallback(InputHtml editor) {
        return editor.getFallback().equals("true");
    }

    public void encodeEnd(FacesContext context, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(context, uiComponent, class$org$apache$myfaces$custom$inputHtml$InputHtml == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtml = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtml")) : class$org$apache$myfaces$custom$inputHtml$InputHtml);
        InputHtml editor = (InputHtml)uiComponent;
        if (HtmlRendererUtils.isDisplayValueOnly((UIComponent)editor)) {
            this.encodeDisplayValueOnly(context, editor);
        } else if (InputHtmlRenderer.useFallback(editor)) {
            this.encodeEndFallBackMode(context, editor);
        } else if (!this.isVisible(editor)) {
            this.encodeHidden(context, editor);
        } else if (!InputHtmlRenderer.hasThisPageAlreadyRenderedAnInputHtml(context)) {
            this.encodeEndNormalMode(context, editor);
            InputHtmlRenderer.setThisPageAlreadyRenderedAnInputHtml(context);
        } else {
            log.warn((Object)("Only one inputHtml can be displayed at the same time. The component will be rendered isung a textarea.\nConpoment : " + RendererUtils.getPathToComponent((UIComponent)editor)));
            this.encodeEndFallBackMode(context, editor);
        }
    }

    private static boolean hasThisPageAlreadyRenderedAnInputHtml(FacesContext context) {
        return context.getExternalContext().getRequestMap().containsKey(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer);
    }

    private static void setThisPageAlreadyRenderedAnInputHtml(FacesContext context) {
        context.getExternalContext().getRequestMap().put(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, Boolean.TRUE);
    }

    private boolean isVisible(InputHtml editor) {
        for (Object parent = editor.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof HtmlPanelTab)) continue;
            HtmlPanelTab panelTab = (HtmlPanelTab)((Object)parent);
            HtmlPanelTabbedPane panelTabbedPane = null;
            for (UIComponent panelAncestor = panelTab.getParent(); panelAncestor != null; panelAncestor = panelAncestor.getParent()) {
                if (!(panelAncestor instanceof HtmlPanelTabbedPane)) continue;
                panelTabbedPane = (HtmlPanelTabbedPane)panelAncestor;
                break;
            }
            if (panelTabbedPane != null) {
                if (panelTabbedPane.isClientSide()) {
                    parent = panelTabbedPane;
                    continue;
                }
                int selectedIndex = panelTabbedPane.getSelectedIndex();
                List children = panelTabbedPane.getChildren();
                int tabIdx = 0;
                int len = children.size();
                for (int i = 0; i < len && tabIdx <= selectedIndex; ++i) {
                    UIComponent child = this.htmlTabbedPaneRenderer_getUIComponent((UIComponent)children.get(i));
                    if (!(child instanceof HtmlPanelTab)) continue;
                    if (child == panelTab) {
                        if (!child.isRendered() || tabIdx != selectedIndex) {
                            return false;
                        }
                        parent = panelTabbedPane;
                        continue;
                    }
                    ++tabIdx;
                }
                continue;
            }
            log.debug((Object)("pannelTabbedPane == null for component " + RendererUtils.getPathToComponent((UIComponent)panelTab)));
        }
        return true;
    }

    private UIComponent htmlTabbedPaneRenderer_getUIComponent(UIComponent uiComponent) {
        if (uiComponent instanceof UIForm || uiComponent instanceof UINamingContainer) {
            List children = uiComponent.getChildren();
            int len = children.size();
            for (int i = 0; i < len; ++i) {
                uiComponent = this.htmlTabbedPaneRenderer_getUIComponent((UIComponent)children.get(i));
            }
        }
        return uiComponent;
    }

    private void encodeHidden(FacesContext context, InputHtml editor) throws IOException {
        String clientId = editor.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("textarea", (UIComponent)editor);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("style", (Object)"display:none", null);
        String text = RendererUtils.getStringValue(context, (UIComponent)editor);
        writer.writeText((Object)text, "value");
        writer.endElement("textarea");
    }

    private void encodeDisplayValueOnly(FacesContext context, InputHtml editor) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", (UIComponent)editor);
        HtmlRendererUtils.writeIdIfNecessary(writer, (UIComponent)editor, context);
        HtmlRendererUtils.renderDisplayValueOnlyAttributes((UIComponent)editor, writer);
        String text = RendererUtils.getStringValue(context, (UIComponent)editor);
        writer.write(editor.getHtmlBody(text));
        writer.endElement("span");
    }

    private void encodeEndFallBackMode(FacesContext context, InputHtml editor) throws IOException {
        String clientId = editor.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("textarea", (UIComponent)editor);
        writer.writeAttribute("name", (Object)clientId, null);
        HtmlRendererUtils.writeIdIfNecessary(writer, (UIComponent)editor, context);
        if (editor.getStyle() != null) {
            writer.writeAttribute("style", (Object)editor.getStyle(), null);
        }
        if (editor.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)editor.getStyleClass(), null);
        }
        if (this.isDisabled(context, (UIComponent)editor)) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        String text = RendererUtils.getStringValue(context, (UIComponent)editor);
        writer.write(InputHtmlRenderer.htmlToPlainText(text, editor));
        writer.endElement("textarea");
    }

    private static String htmlToPlainText(String html, InputHtml editor) {
        return editor.getHtmlBody(html).replaceAll("<br.*>", "\n").replaceAll("<.+?>", "");
    }

    private void encodeEndNormalMode(FacesContext context, InputHtml editor) throws IOException {
        String clientId = editor.getClientId(context);
        FormInfo parentFormInfo = RendererUtils.findNestingForm((UIComponent)editor, context);
        if (parentFormInfo == null) {
            throw new FacesException("InputHtml must be embedded in a form.");
        }
        String formId = parentFormInfo.getFormName();
        AddResource addResource = AddResourceFactory.getInstance(context);
        addResource.addStyleSheet(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupustyles.css");
        addResource.addStyleSheet(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupudrawerstyles.css");
        addResource.addStyleSheet(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "myFaces.css");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "sarissa.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "sarissa_ieemu_xpath.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupuhelpers.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupueditor.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupubasetools.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupuloggers.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupunoi18n.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupucleanupexpressions.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupucontentfilters.js");
        if (editor.isShowAnyToolBox()) {
            addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kuputoolcollapser.js");
        }
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupucontextmenu.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupuinit.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupustart.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupusourceedit.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupuspellchecker.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupudrawers.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "myFacesUtils.js");
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("style", (Object)"display: none;", null);
        writer.startElement("xml", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupuconfig", null);
        writer.writeAttribute("class", (Object)"kupuconfig", null);
        writer.startElement("kupuconfig", (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "dst", "fulldoc.html", (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "use_css", "1", (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "reload_after_save", "0", (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "strict_output", "1", (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "content_type", "application/xhtml+xml", (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "compatible_singletons", "1", (UIComponent)editor);
        writer.startElement("table_classes", (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "class", "plain", (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "class", "listing", (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "class", "grid", (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "class", "data", (UIComponent)editor);
        writer.endElement("table_classes");
        writer.startElement("cleanup_expressions", (UIComponent)editor);
        writer.startElement("set", (UIComponent)editor);
        writer.startElement("name", (UIComponent)editor);
        writer.write("Convert single quotes to curly ones");
        writer.endElement("name");
        writer.startElement("expression", (UIComponent)editor);
        writer.startElement("reg", (UIComponent)editor);
        writer.write("(\\W)'");
        writer.endElement("reg");
        writer.startElement("replacement", (UIComponent)editor);
        writer.write("\\1&#x8216;");
        writer.endElement("replacement");
        writer.endElement("expression");
        writer.startElement("expression", (UIComponent)editor);
        writer.startElement("reg", (UIComponent)editor);
        writer.write("'");
        writer.endElement("reg");
        writer.startElement("replacement", (UIComponent)editor);
        writer.write("&#x8217;");
        writer.endElement("replacement");
        writer.endElement("expression");
        writer.endElement("set");
        writer.startElement("set", (UIComponent)editor);
        writer.startElement("name", (UIComponent)editor);
        writer.write("Reduce whitespace");
        writer.endElement("name");
        writer.startElement("expression", (UIComponent)editor);
        writer.startElement("reg", (UIComponent)editor);
        writer.write("[\\n\\r\\t]");
        writer.endElement("reg");
        writer.startElement("replacement", (UIComponent)editor);
        writer.write("\\x20");
        writer.endElement("replacement");
        writer.endElement("expression");
        writer.startElement("expression", (UIComponent)editor);
        writer.startElement("reg", (UIComponent)editor);
        writer.write("[ ]{2}");
        writer.endElement("reg");
        writer.startElement("replacement", (UIComponent)editor);
        writer.write("\\x20");
        writer.endElement("replacement");
        writer.endElement("expression");
        writer.endElement("set");
        writer.endElement("cleanup_expressions");
        InputHtmlRenderer.writeTag(writer, "image_xsl_uri", addResource.getResourceUri(context, class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupudrawers/drawer.xsl"), (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "link_xsl_uri", addResource.getResourceUri(context, class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupudrawers/drawer.xsl"), (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "image_libraries_uri", addResource.getResourceUri(context, class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupudrawers/imagelibrary.xml"), (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "link_libraries_uri", addResource.getResourceUri(context, class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupudrawers/linklibrary.xml"), (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "search_images_uri", "", (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "search_links_uri", "", (UIComponent)editor);
        writer.endElement("kupuconfig");
        writer.endElement("xml");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-fulleditor", null);
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb", null);
        writer.writeAttribute("id", (Object)"toolbar", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-tb-buttons", null);
        writer.writeAttribute("class", (Object)"kupu-tb-buttons", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup", null);
        writer.writeAttribute("id", (Object)"kupu-logo", null);
        writer.writeAttribute("style", (Object)"float: right", null);
        writer.startElement("button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)"kupu-zoom", null);
        writer.writeAttribute("id", (Object)"kupu-zoom-button", null);
        writer.writeAttribute("title", (Object)"zoom: alt-x", null);
        writer.writeAttribute("i18n:attributes", (Object)"title", null);
        writer.writeAttribute("accesskey", (Object)"x", null);
        writer.write(" ");
        writer.endElement("button");
        if (editor.isAddKupuLogo()) {
            writer.startElement("button", (UIComponent)editor);
            writer.writeAttribute("type", (Object)"button", null);
            writer.writeAttribute("class", (Object)"kupu-logo", null);
            writer.writeAttribute("title", (Object)"Kupu 1.3.5", null);
            writer.writeAttribute("i18n:attributes", (Object)"title", null);
            writer.writeAttribute("accesskey", (Object)"k", null);
            writer.writeAttribute("onclick", (Object)"window.open('http://kupu.oscom.org');", null);
            writer.write(" ");
            writer.endElement("button");
        }
        writer.endElement("span");
        writer.startElement("select", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-tb-styles", null);
        writer.startElement("option", (UIComponent)editor);
        writer.writeAttribute("xmlns:i18n", (Object)"http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("value", (Object)"P", null);
        writer.writeAttribute("i18n:translate", (Object)"paragraph-normal", null);
        writer.write("Normal");
        writer.endElement("option");
        writer.startElement("option", (UIComponent)editor);
        writer.writeAttribute("value", (Object)"H1", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("xmlns:i18n", (Object)"http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("i18n:translate", (Object)"heading", null);
        writer.write("Heading");
        writer.endElement("span");
        writer.write(" 1");
        writer.endElement("option");
        writer.startElement("option", (UIComponent)editor);
        writer.writeAttribute("value", (Object)"H2", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("xmlns:i18n", (Object)"http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("i18n:translate", (Object)"heading", null);
        writer.write("Heading");
        writer.endElement("span");
        writer.write(" 2");
        writer.endElement("option");
        writer.startElement("option", (UIComponent)editor);
        writer.writeAttribute("value", (Object)"H3", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("xmlns:i18n", (Object)"http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("i18n:translate", (Object)"heading", null);
        writer.write("Heading");
        writer.endElement("span");
        writer.write(" 3");
        writer.endElement("option");
        writer.startElement("option", (UIComponent)editor);
        writer.writeAttribute("value", (Object)"H4", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("xmlns:i18n", (Object)"http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("i18n:translate", (Object)"heading", null);
        writer.write("Heading");
        writer.endElement("span");
        writer.write(" 4");
        writer.endElement("option");
        writer.startElement("option", (UIComponent)editor);
        writer.writeAttribute("value", (Object)"H5", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("xmlns:i18n", (Object)"http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("i18n:translate", (Object)"heading", null);
        writer.write("Heading");
        writer.endElement("span");
        writer.write(" 5");
        writer.endElement("option");
        writer.startElement("option", (UIComponent)editor);
        writer.writeAttribute("value", (Object)"H6", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("xmlns:i18n", (Object)"http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("i18n:translate", (Object)"heading", null);
        writer.write("Heading");
        writer.endElement("span");
        writer.write(" 6");
        writer.endElement("option");
        writer.startElement("option", (UIComponent)editor);
        writer.writeAttribute("xmlns:i18n", (Object)"http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("value", (Object)"PRE", null);
        writer.writeAttribute("i18n:translate", (Object)"paragraph-formatted", null);
        writer.write("Formatted");
        writer.endElement("option");
        writer.endElement("select");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup", null);
        writer.writeAttribute("style", (Object)"display: none", null);
        InputHtmlRenderer.writeButton(writer, "kupu-save", "Save", "s", (UIComponent)editor);
        writer.endElement("span");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup", null);
        writer.writeAttribute("id", (Object)"kupu-bg-basicmarkup", null);
        InputHtmlRenderer.writeButton(writer, "kupu-bold", "bold: alt-b", "b", (UIComponent)editor);
        InputHtmlRenderer.writeButton(writer, "kupu-italic", "italic: alt-i", "i", (UIComponent)editor);
        InputHtmlRenderer.writeButton(writer, "kupu-underline", "underline: alt-u", "u", (UIComponent)editor);
        writer.endElement("span");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup", null);
        writer.writeAttribute("id", (Object)"kupu-bg-subsuper", null);
        InputHtmlRenderer.writeButton(writer, "kupu-subscript", "subscript: alt--", "-", (UIComponent)editor);
        InputHtmlRenderer.writeButton(writer, "kupu-superscript", "superscript: alt-+", "+", (UIComponent)editor);
        writer.endElement("span");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup", null);
        InputHtmlRenderer.writeButton(writer, "kupu-forecolor", "text color: alt-f", "f", (UIComponent)editor);
        InputHtmlRenderer.writeButton(writer, "kupu-hilitecolor", "background color: alt-h", "h", (UIComponent)editor);
        writer.endElement("span");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup", null);
        writer.writeAttribute("id", (Object)"kupu-bg-justify", null);
        InputHtmlRenderer.writeButton(writer, "kupu-justifyleft", "left justify: alt-l", "l", (UIComponent)editor);
        InputHtmlRenderer.writeButton(writer, "kupu-justifycenter", "center justify: alt-c", "c", (UIComponent)editor);
        InputHtmlRenderer.writeButton(writer, "kupu-justifyright", "right justify: alt-r", "r", (UIComponent)editor);
        writer.endElement("span");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup", null);
        writer.writeAttribute("id", (Object)"kupu-bg-list", null);
        InputHtmlRenderer.writeButton(writer, "kupu-insertorderedlist", "numbered list: alt-#", "#", "kupu-list-ol-addbutton", (UIComponent)editor);
        InputHtmlRenderer.writeButton(writer, "kupu-insertunorderedlist", "unordered list: alt-*", "*", "kupu-list-ul-addbutton", (UIComponent)editor);
        writer.endElement("span");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup", null);
        writer.writeAttribute("id", (Object)"kupu-bg-definitionlist", null);
        InputHtmlRenderer.writeButton(writer, "kupu-insertdefinitionlist", "definition list: alt-=", "=", "kupu-list-dl-addbutton", (UIComponent)editor);
        writer.endElement("span");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup", null);
        writer.writeAttribute("id", (Object)"kupu-bg-indent", null);
        InputHtmlRenderer.writeButton(writer, "kupu-outdent", "outdent: alt-<", "<", (UIComponent)editor);
        InputHtmlRenderer.writeButton(writer, "kupu-indent", "indent: alt->", ">", (UIComponent)editor);
        writer.endElement("span");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup", null);
        if (!editor.isAllowExternalLinks()) {
            writer.writeAttribute("style", (Object)"display: none", null);
        }
        InputHtmlRenderer.writeButton(writer, "kupu-image", "image", null, "kupu-imagelibdrawer-button", false, (UIComponent)editor);
        InputHtmlRenderer.writeButton(writer, "kupu-inthyperlink", "link", null, "kupu-linklibdrawer-button", false, (UIComponent)editor);
        InputHtmlRenderer.writeButton(writer, "kupu-exthyperlink", "external link", null, "kupu-linkdrawer-button", (UIComponent)editor);
        InputHtmlRenderer.writeButton(writer, "kupu-table", "table", null, "kupu-tabledrawer-button", (UIComponent)editor);
        writer.endElement("span");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup", null);
        writer.writeAttribute("id", (Object)"kupu-bg-remove", null);
        InputHtmlRenderer.writeButton(writer, "kupu-removeimage invisible", "Remove image", null, "kupu-removeimage-button", (UIComponent)editor);
        InputHtmlRenderer.writeButton(writer, "kupu-removelink invisible", "Remove link", null, "kupu-removelink-button", (UIComponent)editor);
        writer.endElement("span");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup", null);
        writer.writeAttribute("id", (Object)"kupu-bg-undo", null);
        InputHtmlRenderer.writeButton(writer, "kupu-undo", "undo: alt-z", "z", (UIComponent)editor);
        InputHtmlRenderer.writeButton(writer, "kupu-redo", "redo: alt-y", "y", (UIComponent)editor);
        writer.endElement("span");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup kupu-spellchecker-span", null);
        writer.writeAttribute("id", (Object)"kupu-spellchecker", null);
        writer.writeAttribute("style", (Object)"display: none", null);
        InputHtmlRenderer.writeButton(writer, "kupu-spellchecker", "check spelling", null, (UIComponent)editor);
        writer.endElement("span");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup kupu-source-span", null);
        writer.writeAttribute("id", (Object)"kupu-source", null);
        if (!editor.isAllowEditSource()) {
            writer.writeAttribute("style", (Object)"display: none", null);
        }
        InputHtmlRenderer.writeButton(writer, "kupu-source", "edit HTML code", "h", (UIComponent)editor);
        writer.endElement("span");
        writer.endElement("span");
        writer.startElement("select", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-ulstyles", null);
        writer.writeAttribute("class", (Object)"kupu-ulstyles", null);
        InputHtmlRenderer.writeOption(writer, "disc", "list-disc", "&#x25CF;", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "square", "list-square", "&#x25A0;", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "circle", "list-circle", "&#x25CB;", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "none", "list-nobullet", "no bullet", (UIComponent)editor);
        writer.endElement("select");
        writer.startElement("select", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-olstyles", null);
        writer.writeAttribute("class", (Object)"kupu-olstyles", null);
        InputHtmlRenderer.writeOption(writer, "decimal", "list-decimal", "1", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "upper-roman", "list-upperroman", "I", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "lower-roman", "list-lowerroman", "i", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "upper-alpha", "list-upperalpha", "A", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "lower-alpha", "list-loweralpha", "a", (UIComponent)editor);
        writer.endElement("select");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("style", (Object)"display:block;", null);
        writer.writeAttribute("class", (Object)"kupu-librarydrawer-parent", null);
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-linkdrawer", null);
        writer.writeAttribute("class", (Object)"kupu-drawer kupu-linkdrawer", null);
        writer.startElement("h1", (UIComponent)editor);
        writer.writeAttribute("xmlns:i18n", (Object)"http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("i18n:translate", (Object)"", null);
        writer.write("External Link");
        writer.endElement("h1");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-linkdrawer-addlink", null);
        writer.writeAttribute("class", (Object)"kupu-panels kupu-linkdrawer-addlink", null);
        writer.startElement("table", (UIComponent)editor);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("td", (UIComponent)editor);
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-toolbox-label", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("xmlns:i18n", (Object)"http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("i18n:translate", (Object)"items-matching-keyword", null);
        writer.write("Link the highlighted text to this URL:");
        writer.endElement("span");
        writer.endElement("div");
        writer.startElement("input", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-st kupu-linkdrawer-input", null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("onkeypress", (Object)"return HandleDrawerEnter(event, 'linkdrawer-preview');", null);
        writer.endElement("input");
        writer.endElement("td");
        writer.startElement("td", null);
        writer.writeAttribute("class", (Object)"kupu-preview-button", null);
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-dialog-button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("onclick", (Object)"drawertool.current_drawer.preview()", null);
        writer.write("Preview");
        writer.endElement("button");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("td", (UIComponent)editor);
        writer.writeAttribute("colspan", (Object)"2", null);
        writer.writeAttribute("align", (Object)"center", null);
        writer.startElement("iframe", (UIComponent)editor);
        writer.writeAttribute("frameborder", (Object)"1", null);
        writer.writeAttribute("scrolling", (Object)"auto", null);
        writer.writeAttribute("width", (Object)"440", null);
        writer.writeAttribute("height", (Object)"198", null);
        writer.writeAttribute("class", (Object)"kupu-linkdrawer-preview", null);
        writer.writeAttribute("src", (Object)addResource.getResourceUri(context, class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupublank.html"), null);
        writer.endElement("iframe");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-dialogbuttons", null);
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)"kupu-dialog-button", null);
        writer.writeAttribute("onclick", (Object)"drawertool.current_drawer.save()", null);
        writer.write("Ok");
        writer.endElement("button");
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)"kupu-dialog-button", null);
        writer.writeAttribute("onclick", (Object)"drawertool.closeDrawer()", null);
        writer.write("Cancel");
        writer.endElement("button");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-tabledrawer", null);
        writer.writeAttribute("class", (Object)"kupu-drawer kupu-tabledrawer", null);
        writer.startElement("h1", (UIComponent)editor);
        writer.write("Table");
        writer.endElement("h1");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-panels", null);
        writer.startElement("table", (UIComponent)editor);
        writer.writeAttribute("width", (Object)"300", null);
        writer.startElement("tr", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-panelsrow", null);
        writer.startElement("td", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-panel", null);
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tabledrawer-addtable", null);
        writer.startElement("table", (UIComponent)editor);
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("th", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.write("Table Class");
        writer.endElement("th");
        writer.startElement("td", (UIComponent)editor);
        writer.startElement("select", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tabledrawer-addclasschooser", null);
        InputHtmlRenderer.writeOption(writer, "plain", "Plain", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "listing", "Listing", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "grid", "Grid", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "data", "Data", (UIComponent)editor);
        writer.endElement("select");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("th", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.write("Rows");
        writer.endElement("th");
        writer.startElement("td", (UIComponent)editor);
        writer.startElement("input", (UIComponent)editor);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("class", (Object)"kupu-tabledrawer-newrows", null);
        writer.writeAttribute("value", (Object)"3", null);
        writer.writeAttribute("onkeypress", (Object)"return HandleDrawerEnter(event);", null);
        writer.endElement("input");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("th", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.write("Columns");
        writer.endElement("th");
        writer.startElement("td", (UIComponent)editor);
        writer.startElement("input", (UIComponent)editor);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("class", (Object)"kupu-tabledrawer-newcols", null);
        writer.writeAttribute("value", (Object)"3", null);
        writer.writeAttribute("onkeypress", (Object)"return HandleDrawerEnter(event);", null);
        writer.endElement("input");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("th", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.endElement("th");
        writer.startElement("td", (UIComponent)editor);
        writer.startElement("label", (UIComponent)editor);
        writer.startElement("input", (UIComponent)editor);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("class", (Object)"kupu-tabledrawer-makeheader", null);
        writer.writeAttribute("onkeypress", (Object)"return HandleDrawerEnter(event);", null);
        writer.endElement("input");
        writer.startElement("span", (UIComponent)editor);
        writer.write("Create Headings");
        writer.endElement("span");
        writer.endElement("label");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("th", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.endElement("th");
        writer.startElement("td", (UIComponent)editor);
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)"kupu-dialog-button", null);
        writer.writeAttribute("onclick", (Object)"drawertool.current_drawer.createTable()", null);
        writer.write("Add Table");
        writer.endElement("button");
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)"kupu-dialog-button", null);
        writer.writeAttribute("onclick", (Object)"drawertool.current_drawer.fixAllTables()", null);
        writer.write("Fix All Tables");
        writer.endElement("button");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tabledrawer-edittable", null);
        writer.startElement("table", (UIComponent)editor);
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("th", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.write("Table Class");
        writer.endElement("th");
        writer.startElement("td", (UIComponent)editor);
        writer.startElement("select", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tabledrawer-editclasschooser", null);
        writer.writeAttribute("onchange", (Object)"drawertool.current_drawer.setTableClass(this.options[this.selectedIndex].value)", null);
        InputHtmlRenderer.writeOption(writer, "plain", "Plain", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "listing", "Listing", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "grid", "Grid", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "data", "Data", (UIComponent)editor);
        writer.endElement("select");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("th", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.write("Current column alignment");
        writer.endElement("th");
        writer.startElement("td", (UIComponent)editor);
        writer.startElement("select", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tabledrawer-alignchooser", null);
        writer.writeAttribute("onchange", (Object)"drawertool.current_drawer.tool.setColumnAlign(this.options[this.selectedIndex].value)", null);
        InputHtmlRenderer.writeOption(writer, "left", "Left", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "center", "Center", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "right", "Right", (UIComponent)editor);
        writer.endElement("select");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("th", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.write("Column");
        writer.endElement("th");
        writer.startElement("td", (UIComponent)editor);
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)"kupu-dialog-button", null);
        writer.writeAttribute("onclick", (Object)"drawertool.current_drawer.addTableColumn()", null);
        writer.write("Add");
        writer.endElement("button");
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)"kupu-dialog-button", null);
        writer.writeAttribute("onclick", (Object)"drawertool.current_drawer.delTableColumn()", null);
        writer.write("Remove");
        writer.endElement("button");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("th", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.write("Row");
        writer.endElement("th");
        writer.startElement("td", (UIComponent)editor);
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)"kupu-dialog-button", null);
        writer.writeAttribute("onclick", (Object)"drawertool.current_drawer.addTableRow()", null);
        writer.write("Add");
        writer.endElement("button");
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)"kupu-dialog-button", null);
        writer.writeAttribute("onclick", (Object)"drawertool.current_drawer.delTableRow()", null);
        writer.write("Remove");
        writer.endElement("button");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("th", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.write("Fix Table");
        writer.endElement("th");
        writer.startElement("td", (UIComponent)editor);
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)"kupu-dialog-button", null);
        writer.writeAttribute("onclick", (Object)"drawertool.current_drawer.fixTable()", null);
        writer.write("Fix");
        writer.endElement("button");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("div");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-dialogbuttons", null);
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)"kupu-dialog-button", null);
        writer.writeAttribute("onmousedown", (Object)"window.status ='onmousedown';", null);
        writer.writeAttribute("onclick", (Object)"drawertool.closeDrawer(this)", null);
        writer.writeAttribute("onfocus", (Object)"window.status='focus';", null);
        writer.write("Close");
        writer.endElement("button");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolboxes", null);
        writer.writeAttribute("id", (Object)"kupu-toolboxes", null);
        if (!editor.isShowAnyToolBox()) {
            writer.writeAttribute("style", (Object)"display: none", null);
        }
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox", null);
        writer.writeAttribute("id", (Object)"kupu-toolbox-properties", null);
        if (!editor.isShowPropertiesToolBox()) {
            writer.writeAttribute("style", (Object)"display: none", null);
        }
        writer.startElement("h1", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-heading", null);
        writer.write("Properties");
        writer.endElement("h1");
        writer.startElement("div", (UIComponent)editor);
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.write("Title:");
        writer.endElement("div");
        writer.startElement("input", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"wide", null);
        writer.writeAttribute("id", (Object)"kupu-properties-title", null);
        writer.endElement("input");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.write("Description:");
        writer.endElement("div");
        writer.startElement("textarea", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"wide", null);
        writer.writeAttribute("id", (Object)"kupu-properties-description", null);
        writer.endElement("textarea");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox", null);
        writer.writeAttribute("id", (Object)"kupu-toolbox-links", null);
        if (!editor.isShowLinksToolBox()) {
            writer.writeAttribute("style", (Object)"display: none", null);
        }
        writer.startElement("h1", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-heading", null);
        writer.writeAttribute("i18n:translate", (Object)"links", null);
        writer.write("Links");
        writer.endElement("h1");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-addlink", null);
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("xmlns:i18n", (Object)"http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("i18n:translate", (Object)"items-matching-keyword", null);
        writer.write("Link the highlighted text to this URL:");
        writer.endElement("span");
        writer.endElement("div");
        writer.startElement("input", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-link-input", null);
        writer.writeAttribute("class", (Object)"wide", null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.endElement("input");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-buttons", null);
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("id", (Object)"kupu-link-button", null);
        writer.writeAttribute("class", (Object)"kupu-toolbox-action", null);
        writer.write("Make Link");
        writer.endElement("button");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox", null);
        writer.writeAttribute("id", (Object)"kupu-toolbox-images", null);
        if (!editor.isShowImagesToolBox()) {
            writer.writeAttribute("style", (Object)"display: none", null);
        }
        writer.startElement("h1", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-heading", null);
        writer.writeAttribute("i18n:translate", (Object)"images", null);
        writer.write("Images");
        writer.endElement("h1");
        writer.startElement("div", (UIComponent)editor);
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("xmlns:i18n", (Object)"http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("i18n:translate", (Object)"", null);
        writer.write("Image float:");
        writer.endElement("span");
        writer.endElement("div");
        writer.startElement("select", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"wide", null);
        writer.writeAttribute("id", (Object)"kupu-image-float-select", null);
        InputHtmlRenderer.writeOption(writer, "image-inline", "Inline", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "image-left", "Left", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "image-right", "Right", (UIComponent)editor);
        writer.endElement("select");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("xmlns:i18n", (Object)"http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("i18n:translate", (Object)"", null);
        writer.write("Insert image at the following URL:");
        writer.endElement("span");
        writer.endElement("div");
        writer.startElement("input", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-image-input", null);
        writer.writeAttribute("value", (Object)"kupuimages/kupu_icon.gif", null);
        writer.writeAttribute("class", (Object)"wide", null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.endElement("input");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-buttons", null);
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("id", (Object)"kupu-image-addbutton", null);
        writer.writeAttribute("class", (Object)"kupu-toolbox-action", null);
        writer.write("Insert Image");
        writer.endElement("button");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox", null);
        writer.writeAttribute("id", (Object)"kupu-toolbox-tables", null);
        if (!editor.isShowTablesToolBox()) {
            writer.writeAttribute("style", (Object)"display: none", null);
        }
        writer.startElement("h1", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-heading", null);
        writer.writeAttribute("i18n:translate", (Object)"table-inspector", null);
        writer.write("Tables");
        writer.endElement("h1");
        writer.startElement("div", (UIComponent)editor);
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.startElement("span", (UIComponent)editor);
        writer.write("Table Class:");
        writer.endElement("span");
        writer.startElement("select", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"wide", null);
        writer.writeAttribute("id", (Object)"kupu-table-classchooser", null);
        writer.write(32);
        writer.endElement("select");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-toolbox-addtable", null);
        writer.writeAttribute("class", (Object)"kupu-toolbox-addtable", null);
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.write("Rows:");
        writer.endElement("div");
        writer.startElement("input", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"wide", null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("id", (Object)"kupu-table-newrows", null);
        writer.endElement("input");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.write("Columns:");
        writer.endElement("div");
        writer.startElement("input", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"wide", null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("id", (Object)"kupu-table-newcols", null);
        writer.endElement("input");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.write("Headings:");
        writer.startElement("input", (UIComponent)editor);
        writer.writeAttribute("name", (Object)"kupu-table-makeheader", null);
        writer.writeAttribute("id", (Object)"kupu-table-makeheader", null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.endElement("input");
        writer.startElement("label", (UIComponent)editor);
        writer.writeAttribute("for", (Object)"kupu-table-makeheader", null);
        writer.write("Create");
        writer.endElement("label");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-buttons", null);
        InputHtmlRenderer.writeButton(writer, "kupu-table-fixall-button", "Fix Table", (UIComponent)editor);
        InputHtmlRenderer.writeButton(writer, "kupu-table-addtable-button", "Add Table", (UIComponent)editor);
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-toolbox-edittable", null);
        writer.writeAttribute("class", (Object)"kupu-toolbox-edittable", null);
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.write("Col Align:");
        writer.startElement("select", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"wide", null);
        writer.writeAttribute("id", (Object)"kupu-table-alignchooser", null);
        InputHtmlRenderer.writeOption(writer, "left", "Left", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "center", "Center", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "right", "Right", (UIComponent)editor);
        writer.endElement("select");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-buttons", null);
        writer.write("<br/>");
        InputHtmlRenderer.writeButton(writer, "kupu-table-addcolumn-button", "Add Column", (UIComponent)editor);
        InputHtmlRenderer.writeButton(writer, "kupu-table-delcolumn-button", "Remove Column", (UIComponent)editor);
        writer.write("<br/>");
        InputHtmlRenderer.writeButton(writer, "kupu-table-addrow-button", "Add Row", (UIComponent)editor);
        InputHtmlRenderer.writeButton(writer, "kupu-table-delrow-button", "Remove Row", (UIComponent)editor);
        InputHtmlRenderer.writeButton(writer, "kupu-table-fix-button", "Fix", (UIComponent)editor);
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox", null);
        writer.writeAttribute("id", (Object)"kupu-toolbox-cleanupexpressions", null);
        if (!editor.isShowCleanupExpressionsToolBox()) {
            writer.writeAttribute("style", (Object)"display: none", null);
        }
        writer.startElement("h1", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-heading", null);
        writer.writeAttribute("i18n:translate", (Object)"", null);
        writer.write("Cleanup expressions");
        writer.endElement("h1");
        writer.startElement("div", (UIComponent)editor);
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("xmlns:i18n", (Object)"http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("i18n:translate", (Object)"", null);
        writer.write("Select a cleanup action:");
        writer.endElement("span");
        writer.endElement("div");
        writer.startElement("select", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupucleanupexpressionselect", null);
        writer.writeAttribute("class", (Object)"kupu-toolbox-st", null);
        writer.endElement("select");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("style", (Object)"text-align: center", null);
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("id", (Object)"kupucleanupexpressionbutton", null);
        writer.writeAttribute("class", (Object)"kupu-toolbox-action", null);
        writer.write("Perform action");
        writer.endElement("button");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox", null);
        writer.writeAttribute("id", (Object)"kupu-toolbox-debug", null);
        if (!editor.isShowDebugToolBox()) {
            writer.writeAttribute("style", (Object)"display: none", null);
        }
        writer.startElement("h1", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-heading", null);
        writer.writeAttribute("i18n:translate", (Object)"debug-log", null);
        writer.write("Debug Log");
        writer.endElement("h1");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-toolbox-debuglog", null);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("table", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-colorchooser", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("style", (Object)"position: fixed; border-style: solid; border-color: black; border-width: 1px;", null);
        writer.endElement("table");
        writer.startElement("div", (UIComponent)editor);
        if (!editor.isShowAnyToolBox()) {
            writer.writeAttribute("style", (Object)"margin-right: 0.3em", null);
        }
        if (editor.getStyle() != null) {
            addResource.addInlineStyleAtPosition(context, AddResource.HEADER_BEGIN, "#kupu-editor{height: inherit;}\ndiv.kupu-fulleditor{" + editor.getStyle() + "}");
        }
        writer.writeAttribute("class", (Object)("kupu-editorframe" + (editor.getStyleClass() == null ? "" : " " + editor.getStyleClass())), null);
        writer.startElement("iframe", (UIComponent)editor);
        writer.writeAttribute("id", (Object)InputHtmlRenderer.getIFrameID(editor, context), null);
        writer.writeAttribute("class", (Object)"kupu-editor-iframe", null);
        writer.writeAttribute("frameborder", (Object)"0", null);
        writer.writeAttribute("scrolling", (Object)"auto", null);
        writer.writeAttribute("onmouseover", (Object)"myFacesKupuReactivateDesignMode(this)", null);
        writer.writeAttribute("onfocus", (Object)"myFacesKupuReactivateDesignMode(this)", null);
        writer.endElement("iframe");
        writer.startElement("textarea", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-editor-textarea", null);
        writer.writeAttribute("id", (Object)"kupu-editor-textarea", null);
        writer.write(32);
        writer.endElement("textarea");
        writer.endElement("div");
        writer.endElement("div");
        String text = editor.getValueAsHtmlDocument(context);
        String encodedText = text == null ? "" : JavascriptUtils.encodeString(text);
        String resourceBaseURL = addResource.getResourceUri(context, class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, null);
        writer.startElement("script", (UIComponent)editor);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("myFacesKupuSet(\"" + encodedText + "\"," + "\"" + clientId + "\"," + "\"" + formId + "\"," + "\"" + resourceBaseURL + "\"" + ");");
        writer.endElement("script");
    }

    private static String getIFrameID(InputHtml editor, FacesContext context) {
        return editor.getClientId(context) + "_iframe";
    }

    private static void writeTag(ResponseWriter writer, String tagName, String tagBody, UIComponent component) throws IOException {
        writer.startElement(tagName, component);
        writer.writeText((Object)tagBody, null);
        writer.endElement(tagName);
    }

    private static void writeButton(ResponseWriter writer, String classAttr, String title, String accessKey, UIComponent component) throws IOException {
        InputHtmlRenderer.writeButton(writer, classAttr, title, accessKey, classAttr + "-button", component);
    }

    private static void writeButton(ResponseWriter writer, String classAttr, String title, String accessKey, String id, UIComponent component) throws IOException {
        InputHtmlRenderer.writeButton(writer, classAttr, title, accessKey, id, true, component);
    }

    private static void writeButton(ResponseWriter writer, String classAttr, String title, String accessKey, String id, boolean display, UIComponent component) throws IOException {
        writer.startElement("button", component);
        writer.writeAttribute("xmlns:i18n", (Object)"http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)classAttr, null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("title", (Object)title, null);
        writer.writeAttribute("i18n:attributes", (Object)"title", null);
        if (!display) {
            writer.writeAttribute("style", (Object)"display: none", null);
        }
        if (accessKey != null) {
            writer.writeAttribute("accesskey", (Object)accessKey, null);
        }
        writer.write(" ");
        writer.endElement("button");
    }

    private static void writeButton(ResponseWriter writer, String id, String text, UIComponent component) throws IOException {
        writer.startElement("button", component);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.write(text);
        writer.endElement("button");
    }

    private static void writeOption(ResponseWriter writer, String value, String body, UIComponent component) throws IOException {
        writer.startElement("option", component);
        writer.writeAttribute("value", (Object)value, null);
        writer.write(body);
        writer.endElement("option");
    }

    private static void writeOption(ResponseWriter writer, String value, String translate, String body, UIComponent component) throws IOException {
        writer.startElement("option", component);
        writer.writeAttribute("xmlns:i18n", (Object)"http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("value", (Object)value, null);
        writer.writeAttribute("i18n:translate", (Object)translate, null);
        writer.write(body);
        writer.endElement("option");
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$org$apache$myfaces$custom$inputHtml$InputHtml == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtml = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtml")) : class$org$apache$myfaces$custom$inputHtml$InputHtml);
        InputHtml editor = (InputHtml)uiComponent;
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = uiComponent.getClientId(facesContext);
        if (paramMap.containsKey(clientId)) {
            String submitedText = (String)paramMap.get(clientId);
            String htmlText = InputHtmlRenderer.useFallback(editor) ? HTMLEncoder.encode(submitedText, true, true) : submitedText;
            editor.setSubmittedValue(htmlText);
        } else {
            log.warn((Object)("There should always be a submitted value for an inputHtml if it is rendered, its form is submitted, and it is not read-only. Component : " + RendererUtils.getPathToComponent((UIComponent)editor)));
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$org$apache$myfaces$custom$inputHtml$InputHtml == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtml = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtml")) : class$org$apache$myfaces$custom$inputHtml$InputHtml);
        InputHtml editor = (InputHtml)uiComponent;
        String submittedDocument = editor.getValueFromDocument((String)submittedValue);
        return RendererUtils.getConvertedUIOutputValue(facesContext, (UIOutput)editor, submittedDocument);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

