/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule;

import java.io.Serializable;
import java.util.Date;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.apache.myfaces.component.UserRoleAware;
import org.apache.myfaces.custom.schedule.ScheduleMouseEvent;
import org.apache.myfaces.custom.schedule.UISchedule;
import org.apache.myfaces.custom.schedule.util.ScheduleUtil;
import org.apache.myfaces.shared_tomahawk.util._ComponentUtils;

public class HtmlSchedule
extends UISchedule
implements UserRoleAware,
Serializable {
    public static final String COMPONENT_FAMILY = "javax.faces.Panel";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.Schedule";
    private static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.Schedule";
    private static final long serialVersionUID = 5859593107442371656L;
    private String _enabledOnUserRole = null;
    private Date _lastClickedDateAndTime = null;
    private MethodBinding _mouseListener = null;
    private Boolean _submitOnClick = null;
    private String _visibleOnUserRole = null;

    public HtmlSchedule() {
        this.setRendererType("org.apache.myfaces.Schedule");
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof ScheduleMouseEvent) {
            FacesContext context = this.getFacesContext();
            ScheduleMouseEvent mouseEvent = (ScheduleMouseEvent)event;
            MethodBinding mouseListenerBinding = this.getMouseListener();
            if (mouseListenerBinding != null) {
                mouseListenerBinding.invoke(context, new Object[]{mouseEvent});
            }
        }
        super.broadcast(event);
    }

    public String getEnabledOnUserRole() {
        if (this._enabledOnUserRole != null) {
            return this._enabledOnUserRole;
        }
        ValueBinding vb = this.getValueBinding("enabledOnUserRole");
        return vb != null ? _ComponentUtils.getStringValue(this.getFacesContext(), vb) : null;
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public Date getLastClickedDateAndTime() {
        return this._lastClickedDateAndTime;
    }

    public MethodBinding getMouseListener() {
        return this._mouseListener;
    }

    public String getVisibleOnUserRole() {
        if (this._visibleOnUserRole != null) {
            return this._visibleOnUserRole;
        }
        ValueBinding vb = this.getValueBinding("visibleOnUserRole");
        return vb != null ? _ComponentUtils.getStringValue(this.getFacesContext(), vb) : null;
    }

    public boolean isSubmitOnClick() {
        return ScheduleUtil.getBooleanProperty((UIComponent)this, this._submitOnClick, "submitOnClick", false);
    }

    public void queueEvent(FacesEvent event) {
        if (event instanceof ScheduleMouseEvent) {
            if (this.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(event);
    }

    public void resetMouseEvents() {
        this._lastClickedDateAndTime = null;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._enabledOnUserRole = (String)values[1];
        this._visibleOnUserRole = (String)values[2];
        this._submitOnClick = (Boolean)values[3];
        this._lastClickedDateAndTime = (Date)values[4];
        this._mouseListener = (MethodBinding)HtmlSchedule.restoreAttachedState((FacesContext)context, (Object)values[5]);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._enabledOnUserRole, this._visibleOnUserRole, this._submitOnClick, this._lastClickedDateAndTime, HtmlSchedule.saveAttachedState((FacesContext)context, (Object)this._mouseListener)};
        return values;
    }

    public void setEnabledOnUserRole(String enabledOnUserRole) {
        this._enabledOnUserRole = enabledOnUserRole;
    }

    public void setLastClickedDateAndTime(Date lastClickedDateAndTime) {
        this._lastClickedDateAndTime = lastClickedDateAndTime;
    }

    public void setMouseListener(MethodBinding listener) {
        this._mouseListener = listener;
    }

    public void setSubmitOnClick(boolean submitOnClick) {
        this._submitOnClick = submitOnClick;
    }

    public void setVisibleOnUserRole(String visibleOnUserRole) {
        this._visibleOnUserRole = visibleOnUserRole;
    }
}

