/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule.renderer;

import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.custom.schedule.HtmlSchedule;
import org.apache.myfaces.custom.schedule.model.ScheduleDay;
import org.apache.myfaces.custom.schedule.renderer.AbstractCompactScheduleRenderer;

public class ScheduleCompactWeekRenderer
extends AbstractCompactScheduleRenderer
implements Serializable {
    private static final long serialVersionUID = 5504081783797695487L;

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        super.encodeBegin(context, component);
        HtmlSchedule schedule = (HtmlSchedule)component;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)("schedule-compact-" + this.getTheme((UIComponent)schedule)), null);
        writer.writeAttribute("style", (Object)"border-style: none; overflow: hidden;", null);
        writer.startElement("table", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "week"), null);
        writer.writeAttribute("style", (Object)"position: relative; left: 0px; top: 0px; width: 100%;", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"1", null);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("width", (Object)"100%", null);
        writer.startElement("tbody", (UIComponent)schedule);
        Calendar cal = GregorianCalendar.getInstance();
        Iterator dayIterator = schedule.getModel().iterator();
        while (dayIterator.hasNext()) {
            boolean isWeekend;
            ScheduleDay day = (ScheduleDay)dayIterator.next();
            cal.setTime(day.getDate());
            int dayOfWeek = cal.get(7);
            int dayOfMonth = cal.get(5);
            boolean bl = isWeekend = dayOfWeek == 7 || dayOfWeek == 1;
            if (dayOfWeek == 2 || dayOfWeek == 4 || dayOfWeek == 6 || dayOfWeek == 1) {
                writer.startElement("tr", (UIComponent)schedule);
            }
            this.writeDayCell(context, writer, schedule, day, 50.0f, dayOfWeek, dayOfMonth, isWeekend, true, dayOfWeek == 6 ? 2 : 1);
            if (dayOfWeek != 3 && dayOfWeek != 5 && dayOfWeek != 7 && dayOfWeek != 1) continue;
            writer.endElement("tr");
        }
        writer.endElement("tbody");
        writer.endElement("table");
        writer.endElement("div");
    }

    protected int getDefaultRowHeight() {
        return 200;
    }

    protected String getRowHeightProperty() {
        return "compactWeekRowHeight";
    }
}

