/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.versioning.service;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.versioning.VersioningService;
import org.nuxeo.ecm.platform.versioning.api.VersionIncEditOptions;
import org.nuxeo.ecm.platform.versioning.api.VersioningActions;
import org.nuxeo.ecm.platform.versioning.api.VersioningManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class VersioningManagerImpl
extends DefaultComponent
implements VersioningManager {
    public static final String COMPONENT_ID = "org.nuxeo.ecm.platform.versioning.VersioningManager";
    private static final Log log = LogFactory.getLog(VersioningManagerImpl.class);

    public VersionIncEditOptions getVersionIncEditOptions(DocumentModel doc) throws ClientException {
        VersioningService service;
        VersionIncEditOptions options = new VersionIncEditOptions();
        try {
            service = (VersioningService)Framework.getService(VersioningService.class);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return options;
        }
        for (VersioningOption option : service.getSaveOptions(doc)) {
            VersioningActions action;
            switch (option) {
                case MINOR: {
                    action = VersioningActions.ACTION_INCREMENT_MINOR;
                    break;
                }
                case MAJOR: {
                    action = VersioningActions.ACTION_INCREMENT_MAJOR;
                    break;
                }
                default: {
                    action = VersioningActions.ACTION_NO_INCREMENT;
                }
            }
            if (option == service.getSaveOptions(doc).get(0)) {
                options.setDefaultVersioningAction(action);
            }
            options.addOption(action);
        }
        return options;
    }

    public String getVersionLabel(DocumentModel doc) {
        return doc.getVersionLabel();
    }

    @Deprecated
    public DocumentModel incrementMajor(DocumentModel doc) throws ClientException {
        VersioningManagerImpl.setVersion(doc, VersioningManagerImpl.getValidMajor(doc) + 1L, 0L);
        return doc;
    }

    @Deprecated
    public DocumentModel incrementMinor(DocumentModel doc) throws ClientException {
        doc.setPropertyValue("uid:minor_version", (Serializable)Long.valueOf(VersioningManagerImpl.getValidMinor(doc) + 1L));
        return doc;
    }

    private static void setVersion(DocumentModel doc, long major, long minor) throws ClientException {
        doc.setPropertyValue("uid:major_version", (Serializable)Long.valueOf(major));
        doc.setPropertyValue("uid:minor_version", (Serializable)Long.valueOf(minor));
    }

    private static long getValidVersion(DocumentModel doc, String propName) throws ClientException {
        Serializable propVal = doc.getPropertyValue(propName);
        if (propVal == null || !(propVal instanceof Long)) {
            return 0L;
        }
        return (Long)propVal;
    }

    private static long getValidMajor(DocumentModel doc) throws ClientException {
        return VersioningManagerImpl.getValidVersion(doc, "uid:major_version");
    }

    private static long getValidMinor(DocumentModel doc) throws ClientException {
        return VersioningManagerImpl.getValidVersion(doc, "uid:minor_version");
    }

    @Deprecated
    public String getMajorVersionPropertyName(String documentType) {
        return "uid:major_version";
    }

    @Deprecated
    public String getMinorVersionPropertyName(String documentType) {
        return "uid:minor_version";
    }
}

