/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.ServerNotificationDispatcher;
import com.sun.jdmk.internal.ClassLogger;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.ObjectName;

class HeartBeatServerHandler {
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.comm.legacy.connector.heartbeat", "HeartBeatServerHandler");
    private static final ClassLogger wpLogger = new ClassLogger("com.sun.jdmk.comm.legacy.connector.heartbeat", "WaitPing");
    private MBeanServer mbs;
    private static String mbsId;
    private ServerNotificationDispatcher snd;
    private static long counter;
    private static String uniqueId;
    private Hashtable clients = new Hashtable();

    static {
        counter = 0L;
    }

    public HeartBeatServerHandler(MBeanServer mbs, ServerNotificationDispatcher snd) {
        if (logger.finerOn()) {
            logger.finer("Constructor", "Create HeartBeatServerHandler.");
        }
        this.mbs = mbs;
        this.snd = snd;
        try {
            mbsId = (String)mbs.getAttribute(new ObjectName("JMImplementation:type=MBeanServerDelegate"), "MBeanServerId");
        }
        catch (Exception e) {
            mbsId = "unknown";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pingHeartBeatServer(String sessionId, int period, int nretries, Long notifSessionId) {
        HBClientInfo ci;
        String id = sessionId;
        if (id == null) {
            id = HeartBeatServerHandler.getSessionId();
        } else if (!id.endsWith(mbsId)) {
            return null;
        }
        Hashtable hashtable = this.clients;
        synchronized (hashtable) {
            ci = (HBClientInfo)this.clients.get(id);
        }
        if (ci == null) {
            if (period <= 0) {
                return id;
            }
            ci = new HBClientInfo(id, period, nretries, notifSessionId);
            hashtable = this.clients;
            synchronized (hashtable) {
                this.clients.put(id, ci);
            }
            ci.startWaitPing();
            return id;
        }
        if (period <= 0) {
            hashtable = this.clients;
            synchronized (hashtable) {
                this.clients.remove(id);
            }
            ci.stopWaitPing(-1);
            return id;
        }
        ci.setPeriod(period);
        ci.setNRetries(nretries);
        ci.setNotifSessionId(notifSessionId);
        ci.startWaitPing();
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(String sessionId) {
        Long id;
        HBClientInfo ci;
        Hashtable hashtable = this.clients;
        synchronized (hashtable) {
            ci = (HBClientInfo)this.clients.remove(sessionId);
        }
        if (ci != null && (id = ci.getNotifSessionId()) != null) {
            this.snd.remoteTerminate(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupClientResources() {
        Hashtable hashtable = this.clients;
        synchronized (hashtable) {
            Enumeration e = this.clients.elements();
            while (e.hasMoreElements()) {
                HBClientInfo ci = (HBClientInfo)e.nextElement();
                ci.stopWaitPing(-1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSessionId() {
        Class<HeartBeatServerHandler> clazz = HeartBeatServerHandler.class;
        synchronized (HeartBeatServerHandler.class) {
            uniqueId = String.valueOf(counter++) + "_" + mbsId;
            // ** MonitorExit[var0] (shouldn't be in output)
            return uniqueId;
        }
    }

    private class HBClientInfo {
        private String hbSessionId;
        private int period;
        private int nretries;
        private Long notifSessionId;
        private long timeout;
        private long newThreadEndTime;
        private WaitPing threadWaitPing;

        public HBClientInfo(String hbSessionId, int period, int nretries, Long notifSessionId) {
            this.hbSessionId = hbSessionId;
            this.period = period;
            this.nretries = nretries;
            this.notifSessionId = notifSessionId;
        }

        public int getPeriod() {
            return this.period;
        }

        public void setPeriod(int period) {
            this.period = period;
        }

        public int getNRetries() {
            return this.nretries;
        }

        public void setNRetries(int nretries) {
            this.nretries = nretries;
        }

        public Long getNotifSessionId() {
            return this.notifSessionId;
        }

        public void setNotifSessionId(Long notifSessionId) {
            this.notifSessionId = notifSessionId;
        }

        public synchronized void startWaitPing() {
            this.timeout = this.nretries == 0 ? (long)((double)this.period + 1.2 * (double)this.period) : (long)((double)this.period + 1.2 * (double)(this.period * this.nretries));
            this.newThreadEndTime = System.currentTimeMillis() + this.timeout;
            if (this.threadWaitPing == null || !this.threadWaitPing.isAlive()) {
                this.threadWaitPing = new WaitPing();
                this.threadWaitPing.start();
            }
        }

        public synchronized void stopWaitPing(int action) {
            if (this.threadWaitPing != null) {
                this.threadWaitPing.terminate(action);
                this.threadWaitPing = null;
            }
        }

        public void cleanupHBClientInfo() {
            HeartBeatServerHandler.this.cleanup(this.hbSessionId);
        }

        static /* synthetic */ long access$0(HBClientInfo hBClientInfo) {
            return hBClientInfo.timeout;
        }

        static /* synthetic */ long access$1(HBClientInfo hBClientInfo) {
            return hBClientInfo.newThreadEndTime;
        }

        private class WaitPing
        extends Thread {
            private long actualThreadEndTime = 0L;
            private boolean toBeTerminated = false;
            private final int[] lock = new int[0];

            private WaitPing() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                if (true) ** GOTO lbl23
                do {
                    block8: {
                        try {
                            var1_1 = this.lock;
                            // MONITORENTER : this.lock
                            this.lock.wait(HBClientInfo.access$0(HBClientInfo.this));
                            // MONITOREXIT : var1_1
                        }
                        catch (InterruptedException ie) {
                            if (!this.toBeTerminated) break block8;
                            return;
                        }
                    }
                    this.actualThreadEndTime = System.currentTimeMillis();
                    if (this.actualThreadEndTime > HBClientInfo.access$1(HBClientInfo.this) && !this.toBeTerminated) {
                        this.toBeTerminated = true;
                        if (HeartBeatServerHandler.access$0().finerOn()) {
                            HeartBeatServerHandler.access$0().finer("run", "Cleaning up: Client with SessionId = " + HBClientInfo.access$2(HBClientInfo.this) + " died.");
                        }
                        HBClientInfo.this.cleanupHBClientInfo();
                    }
lbl23:
                    // 4 sources

                    if (this.toBeTerminated != false) return;
                } while (HBClientInfo.access$0(HBClientInfo.this) > 0L);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void terminate(int action) {
                this.toBeTerminated = true;
                if (action == -1) {
                    if (wpLogger.finerOn()) {
                        wpLogger.finer("terminate", "Cleaning up: Client with SessionId = " + HBClientInfo.this.hbSessionId + " disconnected.");
                    }
                    HBClientInfo.this.cleanupHBClientInfo();
                    int[] nArray = this.lock;
                    synchronized (this.lock) {
                        this.lock.notify();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                    }
                } else if (wpLogger.finerOn()) {
                    wpLogger.finer("terminate", "Ping stopped for client with SessionId = " + HBClientInfo.this.hbSessionId);
                }
            }
        }
    }
}

