/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class HttpBody {
    protected byte[] body = null;

    public HttpBody() {
        this.body = null;
    }

    public HttpBody(byte[] body) {
        this.body = body;
    }

    public byte[] getBytes() {
        return this.body;
    }

    public int getByteCount() {
        if (this.body == null) {
            return 0;
        }
        return this.body.length;
    }

    public void readFrom(InputStream s, int byteCount) throws IOException {
        this.body = new byte[byteCount];
        int n = 0;
        while (n < byteCount) {
            int c = s.read(this.body, n, byteCount - n);
            if (c < 0) {
                throw new EOFException();
            }
            n += c;
        }
    }

    public void writeTo(OutputStream s) throws IOException {
        if (this.body != null) {
            s.write(this.body);
        }
    }
}

