/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.discovery;

import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.HttpConnectorAddress;
import com.sun.jdmk.comm.HttpsConnectorAddress;
import com.sun.jdmk.comm.RmiConnectorAddress;
import com.sun.jdmk.discovery.DiscoveryMsg;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;

class ResponsePDU
extends DiscoveryMsg {
    private static final long serialVersionUID = -1917939025172594153L;
    private Hashtable objectList = new Hashtable();
    private boolean evt = false;
    private int agtState = 1;
    private String mbeanServerId = null;
    private String specificationName = null;
    private String specificationVersion = null;
    private String specificationVendor = null;
    private String implementationName = null;
    private String implementationVersion = null;
    private String implementationVendor = null;
    private byte[] userData = null;
    JMXServiceURL[] serverAddresses;

    public ResponsePDU(String mbeanServerId, String specificationName, String specificationVendor, String specificationVersion, String implementationName, String implementationVendor, String implementationVersion, byte[] data) {
        this.mbeanServerId = mbeanServerId;
        this.specificationName = specificationName;
        this.specificationVersion = specificationVersion;
        this.specificationVendor = specificationVendor;
        this.implementationName = implementationName;
        this.implementationVersion = implementationVersion;
        this.implementationVendor = implementationVendor;
        this.userData = data;
    }

    @Override
    public String printState() {
        String state = new String();
        state = String.valueOf(state) + "(TimeStamp=" + this.getTimeStamp() + ")";
        state = String.valueOf(state) + "(Event=" + this.getEvent() + ")";
        if (this.getEvent()) {
            String s = null;
            if (this.getAgentState() == 0) {
                s = "ONLINE";
            }
            if (this.getAgentState() == 1) {
                s = "OFFLINE";
            }
            if (this.getAgentState() == 2) {
                s = "STOPPING";
            }
            state = String.valueOf(state) + "(Agent State =" + s + ")";
        }
        state = String.valueOf(state) + "(Ttl=" + this.getTimeToLive() + ")";
        state = String.valueOf(state) + "(local host = " + this.getHost() + ")";
        state = String.valueOf(state) + "(mbeanServerId = " + this.mbeanServerId + ")";
        state = String.valueOf(state) + "(specificationName = " + this.specificationName + ")";
        state = String.valueOf(state) + "(specificationVersion = " + this.specificationVersion + ")";
        state = String.valueOf(state) + "(specificationVendor = " + this.specificationVendor + ")";
        state = String.valueOf(state) + "(implementationName = " + this.implementationName + ")";
        state = String.valueOf(state) + "(implementationVersion = " + this.implementationVersion + ")";
        state = String.valueOf(state) + "(implementationVendor = " + this.implementationVendor + ")";
        if (this.objectList != null) {
            state = String.valueOf(state) + "(objects ";
            Enumeration e = this.objectList.keys();
            while (e.hasMoreElements()) {
                ObjectName o = (ObjectName)e.nextElement();
                state = String.valueOf(state) + "-  name=" + o + " addr=" + this.toString(this.objectList.get(o));
            }
            state = String.valueOf(state) + ")";
        } else {
            state = String.valueOf(state) + "(No object)";
        }
        return state;
    }

    public String getMbeanServerId() {
        return this.mbeanServerId;
    }

    public String getSpecificationName() {
        return this.specificationName;
    }

    public String getSpecificationVersion() {
        return this.specificationVersion;
    }

    public String getSpecificationVendor() {
        return this.specificationVendor;
    }

    public String getImplementationName() {
        return this.implementationName;
    }

    public String getImplementationVersion() {
        return this.implementationVersion;
    }

    public String getImplementationVendor() {
        return this.implementationVendor;
    }

    public byte[] getUserData() {
        return this.userData;
    }

    public void setEvent(boolean evt) {
        this.evt = evt;
    }

    public boolean getEvent() {
        return this.evt;
    }

    public void setAgentState(int agtState) {
        this.agtState = agtState;
    }

    public int getAgentState() {
        return this.agtState;
    }

    public Hashtable getObjectList() {
        return this.objectList;
    }

    public void addObjectList(ObjectName name, ConnectorAddress addr) {
        if (addr != null) {
            this.objectList.put(name, addr);
        } else {
            this.objectList.put(name, "Not Relevant");
        }
    }

    private String toString(Object addr) {
        if (addr instanceof RmiConnectorAddress) {
            RmiConnectorAddress address = (RmiConnectorAddress)addr;
            return "type:" + address.getConnectorType() + ";host:" + address.getHost() + ";port:" + address.getPort() + ";name:" + address.getName();
        }
        if (addr instanceof HttpConnectorAddress) {
            HttpConnectorAddress address = (HttpConnectorAddress)addr;
            return "type:" + address.getConnectorType() + ";host:" + address.getHost() + ";port:" + address.getPort();
        }
        if (addr instanceof HttpsConnectorAddress) {
            HttpsConnectorAddress address = (HttpsConnectorAddress)addr;
            return "type:" + address.getConnectorType() + ";host:" + address.getHost() + ";port:" + address.getPort();
        }
        return addr.toString();
    }
}

