/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.Map;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.Connection;
import redis.clients.jedis.DebugParams;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.ZParams;
import redis.clients.util.SafeEncoder;

public class BinaryClient
extends Connection {
    private boolean isInMulti;
    private String password;
    private long db;
    private boolean isInWatch;

    public boolean isInMulti() {
        return this.isInMulti;
    }

    public boolean isInWatch() {
        return this.isInWatch;
    }

    public BinaryClient(String host) {
        super(host);
    }

    public BinaryClient(String host, int port) {
        super(host, port);
    }

    private byte[][] joinParameters(byte[] first, byte[][] rest) {
        byte[][] result = new byte[rest.length + 1][];
        result[0] = first;
        for (int i = 0; i < rest.length; ++i) {
            result[i + 1] = rest[i];
        }
        return result;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void connect() {
        if (!this.isConnected()) {
            super.connect();
            if (this.password != null) {
                this.auth(this.password);
                this.getStatusCodeReply();
            }
            if (this.db > 0L) {
                this.select(Long.valueOf(this.db).intValue());
                this.getStatusCodeReply();
            }
        }
    }

    public void ping() {
        this.sendCommand(Protocol.Command.PING);
    }

    public void set(byte[] key, byte[] value) {
        this.sendCommand(Protocol.Command.SET, key, value);
    }

    public void set(byte[] key, byte[] value, byte[] nxxx, byte[] expx, long time) {
        this.sendCommand(Protocol.Command.SET, key, value, nxxx, expx, Protocol.toByteArray(time));
    }

    public void get(byte[] key) {
        this.sendCommand(Protocol.Command.GET, new byte[][]{key});
    }

    public void quit() {
        this.db = 0L;
        this.sendCommand(Protocol.Command.QUIT);
    }

    public void exists(byte[] key) {
        this.sendCommand(Protocol.Command.EXISTS, new byte[][]{key});
    }

    public void del(byte[] ... keys) {
        this.sendCommand(Protocol.Command.DEL, keys);
    }

    public void type(byte[] key) {
        this.sendCommand(Protocol.Command.TYPE, new byte[][]{key});
    }

    public void flushDB() {
        this.sendCommand(Protocol.Command.FLUSHDB);
    }

    public void keys(byte[] pattern) {
        this.sendCommand(Protocol.Command.KEYS, new byte[][]{pattern});
    }

    public void randomKey() {
        this.sendCommand(Protocol.Command.RANDOMKEY);
    }

    public void rename(byte[] oldkey, byte[] newkey) {
        this.sendCommand(Protocol.Command.RENAME, oldkey, newkey);
    }

    public void renamenx(byte[] oldkey, byte[] newkey) {
        this.sendCommand(Protocol.Command.RENAMENX, oldkey, newkey);
    }

    public void dbSize() {
        this.sendCommand(Protocol.Command.DBSIZE);
    }

    public void expire(byte[] key, int seconds) {
        this.sendCommand(Protocol.Command.EXPIRE, key, Protocol.toByteArray(seconds));
    }

    public void expireAt(byte[] key, long unixTime) {
        this.sendCommand(Protocol.Command.EXPIREAT, key, Protocol.toByteArray(unixTime));
    }

    public void ttl(byte[] key) {
        this.sendCommand(Protocol.Command.TTL, new byte[][]{key});
    }

    public void select(int index) {
        this.db = index;
        this.sendCommand(Protocol.Command.SELECT, new byte[][]{Protocol.toByteArray(index)});
    }

    public void move(byte[] key, int dbIndex) {
        this.sendCommand(Protocol.Command.MOVE, key, Protocol.toByteArray(dbIndex));
    }

    public void flushAll() {
        this.sendCommand(Protocol.Command.FLUSHALL);
    }

    public void getSet(byte[] key, byte[] value) {
        this.sendCommand(Protocol.Command.GETSET, key, value);
    }

    public void mget(byte[] ... keys) {
        this.sendCommand(Protocol.Command.MGET, keys);
    }

    public void setnx(byte[] key, byte[] value) {
        this.sendCommand(Protocol.Command.SETNX, key, value);
    }

    public void setex(byte[] key, int seconds, byte[] value) {
        this.sendCommand(Protocol.Command.SETEX, key, Protocol.toByteArray(seconds), value);
    }

    public void mset(byte[] ... keysvalues) {
        this.sendCommand(Protocol.Command.MSET, keysvalues);
    }

    public void msetnx(byte[] ... keysvalues) {
        this.sendCommand(Protocol.Command.MSETNX, keysvalues);
    }

    public void decrBy(byte[] key, long integer) {
        this.sendCommand(Protocol.Command.DECRBY, key, Protocol.toByteArray(integer));
    }

    public void decr(byte[] key) {
        this.sendCommand(Protocol.Command.DECR, new byte[][]{key});
    }

    public void incrBy(byte[] key, long integer) {
        this.sendCommand(Protocol.Command.INCRBY, key, Protocol.toByteArray(integer));
    }

    public void incr(byte[] key) {
        this.sendCommand(Protocol.Command.INCR, new byte[][]{key});
    }

    public void append(byte[] key, byte[] value) {
        this.sendCommand(Protocol.Command.APPEND, key, value);
    }

    public void substr(byte[] key, int start, int end) {
        this.sendCommand(Protocol.Command.SUBSTR, key, Protocol.toByteArray(start), Protocol.toByteArray(end));
    }

    public void hset(byte[] key, byte[] field, byte[] value) {
        this.sendCommand(Protocol.Command.HSET, key, field, value);
    }

    public void hget(byte[] key, byte[] field) {
        this.sendCommand(Protocol.Command.HGET, key, field);
    }

    public void hsetnx(byte[] key, byte[] field, byte[] value) {
        this.sendCommand(Protocol.Command.HSETNX, key, field, value);
    }

    public void hmset(byte[] key, Map<byte[], byte[]> hash) {
        ArrayList<byte[]> params = new ArrayList<byte[]>();
        params.add(key);
        for (Map.Entry<byte[], byte[]> entry : hash.entrySet()) {
            params.add(entry.getKey());
            params.add(entry.getValue());
        }
        this.sendCommand(Protocol.Command.HMSET, (byte[][])params.toArray((T[])new byte[params.size()][]));
    }

    public void hmget(byte[] key, byte[] ... fields) {
        byte[][] params = new byte[fields.length + 1][];
        params[0] = key;
        System.arraycopy(fields, 0, params, 1, fields.length);
        this.sendCommand(Protocol.Command.HMGET, params);
    }

    public void hincrBy(byte[] key, byte[] field, long value) {
        this.sendCommand(Protocol.Command.HINCRBY, key, field, Protocol.toByteArray(value));
    }

    public void hexists(byte[] key, byte[] field) {
        this.sendCommand(Protocol.Command.HEXISTS, key, field);
    }

    public void hdel(byte[] key, byte[] ... fields) {
        this.sendCommand(Protocol.Command.HDEL, this.joinParameters(key, fields));
    }

    public void hlen(byte[] key) {
        this.sendCommand(Protocol.Command.HLEN, new byte[][]{key});
    }

    public void hkeys(byte[] key) {
        this.sendCommand(Protocol.Command.HKEYS, new byte[][]{key});
    }

    public void hvals(byte[] key) {
        this.sendCommand(Protocol.Command.HVALS, new byte[][]{key});
    }

    public void hgetAll(byte[] key) {
        this.sendCommand(Protocol.Command.HGETALL, new byte[][]{key});
    }

    public void rpush(byte[] key, byte[] ... strings) {
        this.sendCommand(Protocol.Command.RPUSH, this.joinParameters(key, strings));
    }

    public void lpush(byte[] key, byte[] ... strings) {
        this.sendCommand(Protocol.Command.LPUSH, this.joinParameters(key, strings));
    }

    public void llen(byte[] key) {
        this.sendCommand(Protocol.Command.LLEN, new byte[][]{key});
    }

    public void lrange(byte[] key, long start, long end) {
        this.sendCommand(Protocol.Command.LRANGE, key, Protocol.toByteArray(start), Protocol.toByteArray(end));
    }

    public void ltrim(byte[] key, long start, long end) {
        this.sendCommand(Protocol.Command.LTRIM, key, Protocol.toByteArray(start), Protocol.toByteArray(end));
    }

    public void lindex(byte[] key, long index) {
        this.sendCommand(Protocol.Command.LINDEX, key, Protocol.toByteArray(index));
    }

    public void lset(byte[] key, long index, byte[] value) {
        this.sendCommand(Protocol.Command.LSET, key, Protocol.toByteArray(index), value);
    }

    public void lrem(byte[] key, long count, byte[] value) {
        this.sendCommand(Protocol.Command.LREM, key, Protocol.toByteArray(count), value);
    }

    public void lpop(byte[] key) {
        this.sendCommand(Protocol.Command.LPOP, new byte[][]{key});
    }

    public void rpop(byte[] key) {
        this.sendCommand(Protocol.Command.RPOP, new byte[][]{key});
    }

    public void rpoplpush(byte[] srckey, byte[] dstkey) {
        this.sendCommand(Protocol.Command.RPOPLPUSH, srckey, dstkey);
    }

    public void sadd(byte[] key, byte[] ... members) {
        this.sendCommand(Protocol.Command.SADD, this.joinParameters(key, members));
    }

    public void smembers(byte[] key) {
        this.sendCommand(Protocol.Command.SMEMBERS, new byte[][]{key});
    }

    public void srem(byte[] key, byte[] ... members) {
        this.sendCommand(Protocol.Command.SREM, this.joinParameters(key, members));
    }

    public void spop(byte[] key) {
        this.sendCommand(Protocol.Command.SPOP, new byte[][]{key});
    }

    public void smove(byte[] srckey, byte[] dstkey, byte[] member) {
        this.sendCommand(Protocol.Command.SMOVE, srckey, dstkey, member);
    }

    public void scard(byte[] key) {
        this.sendCommand(Protocol.Command.SCARD, new byte[][]{key});
    }

    public void sismember(byte[] key, byte[] member) {
        this.sendCommand(Protocol.Command.SISMEMBER, key, member);
    }

    public void sinter(byte[] ... keys) {
        this.sendCommand(Protocol.Command.SINTER, keys);
    }

    public void sinterstore(byte[] dstkey, byte[] ... keys) {
        byte[][] params = new byte[keys.length + 1][];
        params[0] = dstkey;
        System.arraycopy(keys, 0, params, 1, keys.length);
        this.sendCommand(Protocol.Command.SINTERSTORE, params);
    }

    public void sunion(byte[] ... keys) {
        this.sendCommand(Protocol.Command.SUNION, keys);
    }

    public void sunionstore(byte[] dstkey, byte[] ... keys) {
        byte[][] params = new byte[keys.length + 1][];
        params[0] = dstkey;
        System.arraycopy(keys, 0, params, 1, keys.length);
        this.sendCommand(Protocol.Command.SUNIONSTORE, params);
    }

    public void sdiff(byte[] ... keys) {
        this.sendCommand(Protocol.Command.SDIFF, keys);
    }

    public void sdiffstore(byte[] dstkey, byte[] ... keys) {
        byte[][] params = new byte[keys.length + 1][];
        params[0] = dstkey;
        System.arraycopy(keys, 0, params, 1, keys.length);
        this.sendCommand(Protocol.Command.SDIFFSTORE, params);
    }

    public void srandmember(byte[] key) {
        this.sendCommand(Protocol.Command.SRANDMEMBER, new byte[][]{key});
    }

    public void zadd(byte[] key, double score, byte[] member) {
        this.sendCommand(Protocol.Command.ZADD, key, Protocol.toByteArray(score), member);
    }

    public void zaddBinary(byte[] key, Map<byte[], Double> scoreMembers) {
        ArrayList<byte[]> args = new ArrayList<byte[]>(scoreMembers.size() * 2 + 1);
        args.add(key);
        for (Map.Entry<byte[], Double> entry : scoreMembers.entrySet()) {
            args.add(Protocol.toByteArray(entry.getValue()));
            args.add(entry.getKey());
        }
        byte[][] argsArray = new byte[args.size()][];
        args.toArray((T[])argsArray);
        this.sendCommand(Protocol.Command.ZADD, argsArray);
    }

    public void zrange(byte[] key, long start, long end) {
        this.sendCommand(Protocol.Command.ZRANGE, key, Protocol.toByteArray(start), Protocol.toByteArray(end));
    }

    public void zrem(byte[] key, byte[] ... members) {
        this.sendCommand(Protocol.Command.ZREM, this.joinParameters(key, members));
    }

    public void zincrby(byte[] key, double score, byte[] member) {
        this.sendCommand(Protocol.Command.ZINCRBY, key, Protocol.toByteArray(score), member);
    }

    public void zrank(byte[] key, byte[] member) {
        this.sendCommand(Protocol.Command.ZRANK, key, member);
    }

    public void zrevrank(byte[] key, byte[] member) {
        this.sendCommand(Protocol.Command.ZREVRANK, key, member);
    }

    public void zrevrange(byte[] key, long start, long end) {
        this.sendCommand(Protocol.Command.ZREVRANGE, key, Protocol.toByteArray(start), Protocol.toByteArray(end));
    }

    public void zrangeWithScores(byte[] key, long start, long end) {
        this.sendCommand(Protocol.Command.ZRANGE, key, Protocol.toByteArray(start), Protocol.toByteArray(end), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrevrangeWithScores(byte[] key, long start, long end) {
        this.sendCommand(Protocol.Command.ZREVRANGE, key, Protocol.toByteArray(start), Protocol.toByteArray(end), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zcard(byte[] key) {
        this.sendCommand(Protocol.Command.ZCARD, new byte[][]{key});
    }

    public void zscore(byte[] key, byte[] member) {
        this.sendCommand(Protocol.Command.ZSCORE, key, member);
    }

    public void multi() {
        this.sendCommand(Protocol.Command.MULTI);
        this.isInMulti = true;
    }

    public void discard() {
        this.sendCommand(Protocol.Command.DISCARD);
        this.isInMulti = false;
        this.isInWatch = false;
    }

    public void exec() {
        this.sendCommand(Protocol.Command.EXEC);
        this.isInMulti = false;
        this.isInWatch = false;
    }

    public void watch(byte[] ... keys) {
        this.sendCommand(Protocol.Command.WATCH, keys);
        this.isInWatch = true;
    }

    public void unwatch() {
        this.sendCommand(Protocol.Command.UNWATCH);
        this.isInWatch = false;
    }

    public void sort(byte[] key) {
        this.sendCommand(Protocol.Command.SORT, new byte[][]{key});
    }

    public void sort(byte[] key, SortingParams sortingParameters) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.addAll(sortingParameters.getParams());
        this.sendCommand(Protocol.Command.SORT, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void blpop(byte[][] args) {
        this.sendCommand(Protocol.Command.BLPOP, args);
    }

    public void blpop(int timeout, byte[] ... keys) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        for (byte[] arg : keys) {
            args.add(arg);
        }
        args.add(Protocol.toByteArray(timeout));
        this.blpop((byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void sort(byte[] key, SortingParams sortingParameters, byte[] dstkey) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.addAll(sortingParameters.getParams());
        args.add(Protocol.Keyword.STORE.raw);
        args.add(dstkey);
        this.sendCommand(Protocol.Command.SORT, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void sort(byte[] key, byte[] dstkey) {
        this.sendCommand(Protocol.Command.SORT, key, Protocol.Keyword.STORE.raw, dstkey);
    }

    public void brpop(byte[][] args) {
        this.sendCommand(Protocol.Command.BRPOP, args);
    }

    public void brpop(int timeout, byte[] ... keys) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        for (byte[] arg : keys) {
            args.add(arg);
        }
        args.add(Protocol.toByteArray(timeout));
        this.brpop((byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void auth(String password) {
        this.setPassword(password);
        this.sendCommand(Protocol.Command.AUTH, password);
    }

    public void subscribe(byte[] ... channels) {
        this.sendCommand(Protocol.Command.SUBSCRIBE, channels);
    }

    public void publish(byte[] channel, byte[] message) {
        this.sendCommand(Protocol.Command.PUBLISH, channel, message);
    }

    public void unsubscribe() {
        this.sendCommand(Protocol.Command.UNSUBSCRIBE);
    }

    public void unsubscribe(byte[] ... channels) {
        this.sendCommand(Protocol.Command.UNSUBSCRIBE, channels);
    }

    public void psubscribe(byte[] ... patterns) {
        this.sendCommand(Protocol.Command.PSUBSCRIBE, patterns);
    }

    public void punsubscribe() {
        this.sendCommand(Protocol.Command.PUNSUBSCRIBE);
    }

    public void punsubscribe(byte[] ... patterns) {
        this.sendCommand(Protocol.Command.PUNSUBSCRIBE, patterns);
    }

    public void pubsub(byte[] ... args) {
        this.sendCommand(Protocol.Command.PUBSUB, args);
    }

    public void zcount(byte[] key, double min, double max) {
        byte[] byteArrayMin = min == Double.NEGATIVE_INFINITY ? "-inf".getBytes() : Protocol.toByteArray(min);
        byte[] byteArrayMax = max == Double.POSITIVE_INFINITY ? "+inf".getBytes() : Protocol.toByteArray(max);
        this.sendCommand(Protocol.Command.ZCOUNT, key, byteArrayMin, byteArrayMax);
    }

    public void zcount(byte[] key, byte[] min, byte[] max) {
        this.sendCommand(Protocol.Command.ZCOUNT, key, min, max);
    }

    public void zcount(byte[] key, String min, String max) {
        this.sendCommand(Protocol.Command.ZCOUNT, key, min.getBytes(), max.getBytes());
    }

    public void zrangeByScore(byte[] key, double min, double max) {
        byte[] byteArrayMin = min == Double.NEGATIVE_INFINITY ? "-inf".getBytes() : Protocol.toByteArray(min);
        byte[] byteArrayMax = max == Double.POSITIVE_INFINITY ? "+inf".getBytes() : Protocol.toByteArray(max);
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, byteArrayMin, byteArrayMax);
    }

    public void zrangeByScore(byte[] key, byte[] min, byte[] max) {
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, min, max);
    }

    public void zrangeByScore(byte[] key, String min, String max) {
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, min.getBytes(), max.getBytes());
    }

    public void zrevrangeByScore(byte[] key, double max, double min) {
        byte[] byteArrayMin = min == Double.NEGATIVE_INFINITY ? "-inf".getBytes() : Protocol.toByteArray(min);
        byte[] byteArrayMax = max == Double.POSITIVE_INFINITY ? "+inf".getBytes() : Protocol.toByteArray(max);
        this.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, byteArrayMax, byteArrayMin);
    }

    public void zrevrangeByScore(byte[] key, byte[] max, byte[] min) {
        this.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, max, min);
    }

    public void zrevrangeByScore(byte[] key, String max, String min) {
        this.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, max.getBytes(), min.getBytes());
    }

    public void zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        byte[] byteArrayMin = min == Double.NEGATIVE_INFINITY ? "-inf".getBytes() : Protocol.toByteArray(min);
        byte[] byteArrayMax = max == Double.POSITIVE_INFINITY ? "+inf".getBytes() : Protocol.toByteArray(max);
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, byteArrayMin, byteArrayMax, Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count));
    }

    public void zrangeByScore(byte[] key, String min, String max, int offset, int count) {
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, min.getBytes(), max.getBytes(), Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count));
    }

    public void zrevrangeByScore(byte[] key, double max, double min, int offset, int count) {
        byte[] byteArrayMin = min == Double.NEGATIVE_INFINITY ? "-inf".getBytes() : Protocol.toByteArray(min);
        byte[] byteArrayMax = max == Double.POSITIVE_INFINITY ? "+inf".getBytes() : Protocol.toByteArray(max);
        this.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, byteArrayMax, byteArrayMin, Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count));
    }

    public void zrevrangeByScore(byte[] key, String max, String min, int offset, int count) {
        this.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, max.getBytes(), min.getBytes(), Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count));
    }

    public void zrangeByScoreWithScores(byte[] key, double min, double max) {
        byte[] byteArrayMin = min == Double.NEGATIVE_INFINITY ? "-inf".getBytes() : Protocol.toByteArray(min);
        byte[] byteArrayMax = max == Double.POSITIVE_INFINITY ? "+inf".getBytes() : Protocol.toByteArray(max);
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, byteArrayMin, byteArrayMax, Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrangeByScoreWithScores(byte[] key, String min, String max) {
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, min.getBytes(), max.getBytes(), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrevrangeByScoreWithScores(byte[] key, double max, double min) {
        byte[] byteArrayMin = min == Double.NEGATIVE_INFINITY ? "-inf".getBytes() : Protocol.toByteArray(min);
        byte[] byteArrayMax = max == Double.POSITIVE_INFINITY ? "+inf".getBytes() : Protocol.toByteArray(max);
        this.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, byteArrayMax, byteArrayMin, Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrevrangeByScoreWithScores(byte[] key, String max, String min) {
        this.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, max.getBytes(), min.getBytes(), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        byte[] byteArrayMin = min == Double.NEGATIVE_INFINITY ? "-inf".getBytes() : Protocol.toByteArray(min);
        byte[] byteArrayMax = max == Double.POSITIVE_INFINITY ? "+inf".getBytes() : Protocol.toByteArray(max);
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, byteArrayMin, byteArrayMax, Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrangeByScoreWithScores(byte[] key, String min, String max, int offset, int count) {
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, min.getBytes(), max.getBytes(), Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count) {
        byte[] byteArrayMin = min == Double.NEGATIVE_INFINITY ? "-inf".getBytes() : Protocol.toByteArray(min);
        byte[] byteArrayMax = max == Double.POSITIVE_INFINITY ? "+inf".getBytes() : Protocol.toByteArray(max);
        this.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, byteArrayMax, byteArrayMin, Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrevrangeByScoreWithScores(byte[] key, String max, String min, int offset, int count) {
        this.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, max.getBytes(), min.getBytes(), Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, min, max, Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count));
    }

    public void zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, max, min, Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count));
    }

    public void zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max) {
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, min, max, Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min) {
        this.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, max, min, Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, min, max, Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, max, min, Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zremrangeByRank(byte[] key, long start, long end) {
        this.sendCommand(Protocol.Command.ZREMRANGEBYRANK, key, Protocol.toByteArray(start), Protocol.toByteArray(end));
    }

    public void zremrangeByScore(byte[] key, byte[] start, byte[] end) {
        this.sendCommand(Protocol.Command.ZREMRANGEBYSCORE, key, start, end);
    }

    public void zremrangeByScore(byte[] key, String start, String end) {
        this.sendCommand(Protocol.Command.ZREMRANGEBYSCORE, key, start.getBytes(), end.getBytes());
    }

    public void zunionstore(byte[] dstkey, byte[] ... sets) {
        byte[][] params = new byte[sets.length + 2][];
        params[0] = dstkey;
        params[1] = Protocol.toByteArray(sets.length);
        System.arraycopy(sets, 0, params, 2, sets.length);
        this.sendCommand(Protocol.Command.ZUNIONSTORE, params);
    }

    public void zunionstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(dstkey);
        args.add(Protocol.toByteArray(sets.length));
        for (byte[] set : sets) {
            args.add(set);
        }
        args.addAll(params.getParams());
        this.sendCommand(Protocol.Command.ZUNIONSTORE, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void zinterstore(byte[] dstkey, byte[] ... sets) {
        byte[][] params = new byte[sets.length + 2][];
        params[0] = dstkey;
        params[1] = Protocol.toByteArray(sets.length);
        System.arraycopy(sets, 0, params, 2, sets.length);
        this.sendCommand(Protocol.Command.ZINTERSTORE, params);
    }

    public void zinterstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(dstkey);
        args.add(Protocol.toByteArray(sets.length));
        for (byte[] set : sets) {
            args.add(set);
        }
        args.addAll(params.getParams());
        this.sendCommand(Protocol.Command.ZINTERSTORE, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void save() {
        this.sendCommand(Protocol.Command.SAVE);
    }

    public void bgsave() {
        this.sendCommand(Protocol.Command.BGSAVE);
    }

    public void bgrewriteaof() {
        this.sendCommand(Protocol.Command.BGREWRITEAOF);
    }

    public void lastsave() {
        this.sendCommand(Protocol.Command.LASTSAVE);
    }

    public void shutdown() {
        this.sendCommand(Protocol.Command.SHUTDOWN);
    }

    public void info() {
        this.sendCommand(Protocol.Command.INFO);
    }

    public void info(String section) {
        this.sendCommand(Protocol.Command.INFO, section);
    }

    public void monitor() {
        this.sendCommand(Protocol.Command.MONITOR);
    }

    public void slaveof(String host, int port) {
        this.sendCommand(Protocol.Command.SLAVEOF, host, String.valueOf(port));
    }

    public void slaveofNoOne() {
        this.sendCommand(Protocol.Command.SLAVEOF, Protocol.Keyword.NO.raw, Protocol.Keyword.ONE.raw);
    }

    public void configGet(byte[] pattern) {
        this.sendCommand(Protocol.Command.CONFIG, Protocol.Keyword.GET.raw, pattern);
    }

    public void configSet(byte[] parameter, byte[] value) {
        this.sendCommand(Protocol.Command.CONFIG, Protocol.Keyword.SET.raw, parameter, value);
    }

    public void strlen(byte[] key) {
        this.sendCommand(Protocol.Command.STRLEN, new byte[][]{key});
    }

    public void sync() {
        this.sendCommand(Protocol.Command.SYNC);
    }

    public void lpushx(byte[] key, byte[] ... string) {
        this.sendCommand(Protocol.Command.LPUSHX, this.joinParameters(key, string));
    }

    public void persist(byte[] key) {
        this.sendCommand(Protocol.Command.PERSIST, new byte[][]{key});
    }

    public void rpushx(byte[] key, byte[] ... string) {
        this.sendCommand(Protocol.Command.RPUSHX, this.joinParameters(key, string));
    }

    public void echo(byte[] string) {
        this.sendCommand(Protocol.Command.ECHO, new byte[][]{string});
    }

    public void linsert(byte[] key, LIST_POSITION where, byte[] pivot, byte[] value) {
        this.sendCommand(Protocol.Command.LINSERT, key, where.raw, pivot, value);
    }

    public void debug(DebugParams params) {
        this.sendCommand(Protocol.Command.DEBUG, params.getCommand());
    }

    public void brpoplpush(byte[] source, byte[] destination, int timeout) {
        this.sendCommand(Protocol.Command.BRPOPLPUSH, source, destination, Protocol.toByteArray(timeout));
    }

    public void configResetStat() {
        this.sendCommand(Protocol.Command.CONFIG, Protocol.Keyword.RESETSTAT.name());
    }

    public void setbit(byte[] key, long offset, byte[] value) {
        this.sendCommand(Protocol.Command.SETBIT, key, Protocol.toByteArray(offset), value);
    }

    public void setbit(byte[] key, long offset, boolean value) {
        this.sendCommand(Protocol.Command.SETBIT, key, Protocol.toByteArray(offset), Protocol.toByteArray(value));
    }

    public void getbit(byte[] key, long offset) {
        this.sendCommand(Protocol.Command.GETBIT, key, Protocol.toByteArray(offset));
    }

    public void setrange(byte[] key, long offset, byte[] value) {
        this.sendCommand(Protocol.Command.SETRANGE, key, Protocol.toByteArray(offset), value);
    }

    public void getrange(byte[] key, long startOffset, long endOffset) {
        this.sendCommand(Protocol.Command.GETRANGE, key, Protocol.toByteArray(startOffset), Protocol.toByteArray(endOffset));
    }

    public Long getDB() {
        return this.db;
    }

    @Override
    public void disconnect() {
        this.db = 0L;
        super.disconnect();
    }

    @Override
    public void close() {
        this.db = 0L;
        super.close();
    }

    public void resetState() {
        if (this.isInMulti()) {
            this.discard();
        }
        if (this.isInWatch()) {
            this.unwatch();
        }
    }

    private void sendEvalCommand(Protocol.Command command, byte[] script, byte[] keyCount, byte[][] params) {
        byte[][] allArgs = new byte[params.length + 2][];
        allArgs[0] = script;
        allArgs[1] = keyCount;
        for (int i = 0; i < params.length; ++i) {
            allArgs[i + 2] = params[i];
        }
        this.sendCommand(command, allArgs);
    }

    public void eval(byte[] script, byte[] keyCount, byte[][] params) {
        this.sendEvalCommand(Protocol.Command.EVAL, script, keyCount, params);
    }

    public void eval(byte[] script, int keyCount, byte[] ... params) {
        this.eval(script, Protocol.toByteArray(keyCount), params);
    }

    public void evalsha(byte[] sha1, byte[] keyCount, byte[] ... params) {
        this.sendEvalCommand(Protocol.Command.EVALSHA, sha1, keyCount, params);
    }

    public void evalsha(byte[] sha1, int keyCount, byte[] ... params) {
        this.sendEvalCommand(Protocol.Command.EVALSHA, sha1, Protocol.toByteArray(keyCount), params);
    }

    public void scriptFlush() {
        this.sendCommand(Protocol.Command.SCRIPT, new byte[][]{Protocol.Keyword.FLUSH.raw});
    }

    public void scriptExists(byte[] ... sha1) {
        byte[][] args = new byte[sha1.length + 1][];
        args[0] = Protocol.Keyword.EXISTS.raw;
        for (int i = 0; i < sha1.length; ++i) {
            args[i + 1] = sha1[i];
        }
        this.sendCommand(Protocol.Command.SCRIPT, args);
    }

    public void scriptLoad(byte[] script) {
        this.sendCommand(Protocol.Command.SCRIPT, Protocol.Keyword.LOAD.raw, script);
    }

    public void scriptKill() {
        this.sendCommand(Protocol.Command.SCRIPT, new byte[][]{Protocol.Keyword.KILL.raw});
    }

    public void slowlogGet() {
        this.sendCommand(Protocol.Command.SLOWLOG, new byte[][]{Protocol.Keyword.GET.raw});
    }

    public void slowlogGet(long entries) {
        this.sendCommand(Protocol.Command.SLOWLOG, Protocol.Keyword.GET.raw, Protocol.toByteArray(entries));
    }

    public void slowlogReset() {
        this.sendCommand(Protocol.Command.SLOWLOG, new byte[][]{Protocol.Keyword.RESET.raw});
    }

    public void slowlogLen() {
        this.sendCommand(Protocol.Command.SLOWLOG, new byte[][]{Protocol.Keyword.LEN.raw});
    }

    public void objectRefcount(byte[] key) {
        this.sendCommand(Protocol.Command.OBJECT, Protocol.Keyword.REFCOUNT.raw, key);
    }

    public void objectIdletime(byte[] key) {
        this.sendCommand(Protocol.Command.OBJECT, Protocol.Keyword.IDLETIME.raw, key);
    }

    public void objectEncoding(byte[] key) {
        this.sendCommand(Protocol.Command.OBJECT, Protocol.Keyword.ENCODING.raw, key);
    }

    public void bitcount(byte[] key) {
        this.sendCommand(Protocol.Command.BITCOUNT, new byte[][]{key});
    }

    public void bitcount(byte[] key, long start, long end) {
        this.sendCommand(Protocol.Command.BITCOUNT, key, Protocol.toByteArray(start), Protocol.toByteArray(end));
    }

    public void bitop(BitOP op, byte[] destKey, byte[] ... srcKeys) {
        Protocol.Keyword kw = Protocol.Keyword.AND;
        int len = srcKeys.length;
        switch (op) {
            case AND: {
                kw = Protocol.Keyword.AND;
                break;
            }
            case OR: {
                kw = Protocol.Keyword.OR;
                break;
            }
            case XOR: {
                kw = Protocol.Keyword.XOR;
                break;
            }
            case NOT: {
                kw = Protocol.Keyword.NOT;
                len = Math.min(1, len);
            }
        }
        byte[][] bargs = new byte[len + 2][];
        bargs[0] = kw.raw;
        bargs[1] = destKey;
        for (int i = 0; i < len; ++i) {
            bargs[i + 2] = srcKeys[i];
        }
        this.sendCommand(Protocol.Command.BITOP, bargs);
    }

    public void sentinel(byte[] ... args) {
        this.sendCommand(Protocol.Command.SENTINEL, args);
    }

    public void dump(byte[] key) {
        this.sendCommand(Protocol.Command.DUMP, new byte[][]{key});
    }

    public void restore(byte[] key, int ttl, byte[] serializedValue) {
        this.sendCommand(Protocol.Command.RESTORE, key, Protocol.toByteArray(ttl), serializedValue);
    }

    public void pexpire(byte[] key, int milliseconds) {
        this.sendCommand(Protocol.Command.PEXPIRE, key, Protocol.toByteArray(milliseconds));
    }

    public void pexpireAt(byte[] key, long millisecondsTimestamp) {
        this.sendCommand(Protocol.Command.PEXPIREAT, key, Protocol.toByteArray(millisecondsTimestamp));
    }

    public void pttl(byte[] key) {
        this.sendCommand(Protocol.Command.PTTL, new byte[][]{key});
    }

    public void incrByFloat(byte[] key, double increment) {
        this.sendCommand(Protocol.Command.INCRBYFLOAT, key, Protocol.toByteArray(increment));
    }

    public void psetex(byte[] key, int milliseconds, byte[] value) {
        this.sendCommand(Protocol.Command.PSETEX, key, Protocol.toByteArray(milliseconds), value);
    }

    public void set(byte[] key, byte[] value, byte[] nxxx) {
        this.sendCommand(Protocol.Command.SET, key, value, nxxx);
    }

    public void set(byte[] key, byte[] value, byte[] nxxx, byte[] expx, int time) {
        this.sendCommand(Protocol.Command.SET, key, value, nxxx, expx, Protocol.toByteArray(time));
    }

    public void srandmember(byte[] key, int count) {
        this.sendCommand(Protocol.Command.SRANDMEMBER, key, Protocol.toByteArray(count));
    }

    public void clientKill(byte[] client) {
        this.sendCommand(Protocol.Command.CLIENT, Protocol.Keyword.KILL.raw, client);
    }

    public void clientGetname() {
        this.sendCommand(Protocol.Command.CLIENT, new byte[][]{Protocol.Keyword.GETNAME.raw});
    }

    public void clientList() {
        this.sendCommand(Protocol.Command.CLIENT, new byte[][]{Protocol.Keyword.LIST.raw});
    }

    public void clientSetname(byte[] name) {
        this.sendCommand(Protocol.Command.CLIENT, Protocol.Keyword.SETNAME.raw, name);
    }

    public void time() {
        this.sendCommand(Protocol.Command.TIME);
    }

    public void migrate(byte[] host, int port, byte[] key, int destinationDb, int timeout) {
        this.sendCommand(Protocol.Command.MIGRATE, host, Protocol.toByteArray(port), key, Protocol.toByteArray(destinationDb), Protocol.toByteArray(timeout));
    }

    public void hincrByFloat(byte[] key, byte[] field, double increment) {
        this.sendCommand(Protocol.Command.HINCRBYFLOAT, key, field, Protocol.toByteArray(increment));
    }

    @Deprecated
    public void scan(int cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(Protocol.toByteArray(cursor));
        args.addAll(params.getParams());
        this.sendCommand(Protocol.Command.SCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    @Deprecated
    public void hscan(byte[] key, int cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.add(Protocol.toByteArray(cursor));
        args.addAll(params.getParams());
        this.sendCommand(Protocol.Command.HSCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    @Deprecated
    public void sscan(byte[] key, int cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.add(Protocol.toByteArray(cursor));
        args.addAll(params.getParams());
        this.sendCommand(Protocol.Command.SSCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    @Deprecated
    public void zscan(byte[] key, int cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.add(Protocol.toByteArray(cursor));
        args.addAll(params.getParams());
        this.sendCommand(Protocol.Command.ZSCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void scan(byte[] cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(cursor);
        args.addAll(params.getParams());
        this.sendCommand(Protocol.Command.SCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void hscan(byte[] key, byte[] cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.add(cursor);
        args.addAll(params.getParams());
        this.sendCommand(Protocol.Command.HSCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void sscan(byte[] key, byte[] cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.add(cursor);
        args.addAll(params.getParams());
        this.sendCommand(Protocol.Command.SSCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void zscan(byte[] key, byte[] cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.add(cursor);
        args.addAll(params.getParams());
        this.sendCommand(Protocol.Command.ZSCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void waitReplicas(int replicas, long timeout) {
        this.sendCommand(Protocol.Command.WAIT, Protocol.toByteArray(replicas), Protocol.toByteArray(timeout));
    }

    public void cluster(byte[] ... args) {
        this.sendCommand(Protocol.Command.CLUSTER, args);
    }

    public void asking() {
        this.sendCommand(Protocol.Command.ASKING);
    }

    public static enum LIST_POSITION {
        BEFORE,
        AFTER;

        public final byte[] raw = SafeEncoder.encode(this.name());
    }
}

