/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.cache;

import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.cache.CacheProvider;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.cache.cacheProvider")
@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
@Install(value=false, precedence=0, classDependencies={"net.sf.ehcache.Cache"})
@AutoCreate
public class EhCacheProvider
extends CacheProvider<CacheManager> {
    private CacheManager cacheManager;
    private static final LogProvider log = Logging.getLogProvider(EhCacheProvider.class);

    @Override
    public CacheManager getDelegate() {
        return this.cacheManager;
    }

    @Override
    public void put(String region, String key, Object object) {
        Cache cache = this.getCacheRegion(region);
        Element element = new Element((Object)key, object);
        cache.put(element);
    }

    @Override
    public void clear() {
        String[] strings;
        for (String cacheName : strings = this.cacheManager.getCacheNames()) {
            Cache cache = this.getCacheRegion(cacheName);
            cache.removeAll();
        }
    }

    @Override
    public Object get(String region, String key) {
        Cache cache = this.getCacheRegion(region);
        Element element = cache.get((Serializable)((Object)key));
        if (element != null) {
            return element.getObjectValue();
        }
        return null;
    }

    private Cache getCacheRegion(String regionName) {
        Cache result;
        if (regionName == null) {
            regionName = this.getDefaultRegion();
        }
        if ((result = this.cacheManager.getCache(regionName)) == null) {
            log.warn("Could not find configuration for region [" + regionName + "]; using defaults.");
            this.cacheManager.addCache(regionName);
            result = this.cacheManager.getCache(regionName);
            log.debug("EHCache region created: " + regionName);
        }
        return result;
    }

    @Override
    public void remove(String region, String key) {
        Cache cache = this.getCacheRegion(region);
        cache.remove((Serializable)((Object)key));
    }

    @Create
    public void create() {
        log.debug("Starting EhCacheProvider cache");
        try {
            this.cacheManager = this.getConfiguration() != null ? new CacheManager(this.getConfigurationAsStream()) : new CacheManager();
        }
        catch (CacheException e) {
            throw new IllegalStateException("Error starting EHCache Cache", e);
        }
    }

    @Destroy
    public void destroy() {
        log.debug("Stopping EhCacheProvider cache");
        try {
            this.cacheManager.shutdown();
            this.cacheManager = null;
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Error stopping EHCache Cache", e);
        }
    }
}

