/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.international.StatusMessage;
import org.jboss.seam.international.StatusMessages;
import org.jboss.seam.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.CONVERSATION)
@Name(value="org.jboss.seam.international.statusMessages")
@Install(precedence=0, classDependencies={"javax.faces.context.FacesContext"})
@BypassInterceptors
public class FacesMessages
extends StatusMessages {
    private static final String NX_TRANSIENT_MESSAGES = "org.seam.transient.messages.nx";

    public void beforeRenderResponse() {
        for (StatusMessage statusMessage : this.getMessages()) {
            FacesContext.getCurrentInstance().addMessage(null, FacesMessages.toFacesMessage(statusMessage));
        }
        for (Map.Entry entry : this.getKeyedMessages().entrySet()) {
            for (StatusMessage statusMessage : (List)entry.getValue()) {
                String clientId = this.getClientId((String)entry.getKey());
                FacesContext.getCurrentInstance().addMessage(clientId, FacesMessages.toFacesMessage(statusMessage));
            }
        }
        for (StatusMessage statusMessage : FacesMessages.getTransientMessages()) {
            if (statusMessage != null) {
                FacesContext.getCurrentInstance().addMessage(null, FacesMessages.toFacesMessage(statusMessage));
                continue;
            }
            System.out.println("NULL MSG !!!!");
        }
        this.clear();
    }

    public static void addTransientMessage(StatusMessage statusMessage) {
        if (Contexts.isSessionContextActive()) {
            ArrayList<StatusMessage> msgs = (ArrayList<StatusMessage>)Contexts.getSessionContext().get(NX_TRANSIENT_MESSAGES);
            if (msgs == null) {
                msgs = new ArrayList<StatusMessage>();
                Contexts.getSessionContext().set(NX_TRANSIENT_MESSAGES, msgs);
            }
            msgs.add(statusMessage);
        }
    }

    public static List<StatusMessage> getTransientMessages() {
        ArrayList<StatusMessage> msgs = null;
        if (Contexts.isSessionContextActive()) {
            msgs = (List)Contexts.getSessionContext().get(NX_TRANSIENT_MESSAGES);
            Contexts.getSessionContext().remove(NX_TRANSIENT_MESSAGES);
        }
        if (msgs == null) {
            msgs = new ArrayList<StatusMessage>();
        } else {
            for (StatusMessage msg : msgs) {
                msg.interpolate(null);
            }
        }
        return msgs;
    }

    public static void afterPhase() {
        FacesMessages.runTasks();
    }

    private static FacesMessage toFacesMessage(StatusMessage statusMessage) {
        if (!Strings.isEmpty(statusMessage.getSummary())) {
            return new FacesMessage(FacesMessages.toSeverity(statusMessage.getSeverity()), statusMessage.getSummary(), statusMessage.getDetail());
        }
        return null;
    }

    private static FacesMessage.Severity toSeverity(StatusMessage.Severity severity) {
        switch (severity) {
            case ERROR: {
                return FacesMessage.SEVERITY_ERROR;
            }
            case FATAL: {
                return FacesMessage.SEVERITY_FATAL;
            }
            case INFO: {
                return FacesMessage.SEVERITY_INFO;
            }
            case WARN: {
                return FacesMessage.SEVERITY_WARN;
            }
        }
        return null;
    }

    private static StatusMessage.Severity toSeverity(FacesMessage.Severity severity) {
        if (FacesMessage.SEVERITY_ERROR.equals(severity)) {
            return StatusMessage.Severity.ERROR;
        }
        if (FacesMessage.SEVERITY_FATAL.equals(severity)) {
            return StatusMessage.Severity.FATAL;
        }
        if (FacesMessage.SEVERITY_INFO.equals(severity)) {
            return StatusMessage.Severity.INFO;
        }
        if (FacesMessage.SEVERITY_WARN.equals(severity)) {
            return StatusMessage.Severity.WARN;
        }
        return null;
    }

    private String getClientId(String id) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return FacesMessages.getClientId((UIComponent)facesContext.getViewRoot(), id, facesContext);
    }

    private static String getClientId(UIComponent component, String id, FacesContext facesContext) {
        String componentId = component.getId();
        if (componentId != null && componentId.equals(id)) {
            return component.getClientId(facesContext);
        }
        Iterator iter = component.getFacetsAndChildren();
        while (iter.hasNext()) {
            UIComponent child = (UIComponent)iter.next();
            String clientId = FacesMessages.getClientId(child, id, facesContext);
            if (clientId == null) continue;
            return clientId;
        }
        return null;
    }

    public List<StatusMessage> getLocalMessages() {
        return this.getMessages();
    }

    public List<FacesMessage> getCurrentMessages() {
        ArrayList<FacesMessage> result = new ArrayList<FacesMessage>();
        Iterator iter = FacesContext.getCurrentInstance().getMessages();
        while (iter.hasNext()) {
            result.add((FacesMessage)iter.next());
        }
        return result;
    }

    public List<FacesMessage> getCurrentGlobalMessages() {
        ArrayList<FacesMessage> result = new ArrayList<FacesMessage>();
        Iterator iter = FacesContext.getCurrentInstance().getMessages(null);
        while (iter.hasNext()) {
            result.add((FacesMessage)iter.next());
        }
        return result;
    }

    public List<FacesMessage> getCurrentMessagesForControl(String id) {
        String clientId = this.getClientId(id);
        ArrayList<FacesMessage> result = new ArrayList<FacesMessage>();
        Iterator iter = FacesContext.getCurrentInstance().getMessages(clientId);
        while (iter.hasNext()) {
            result.add((FacesMessage)iter.next());
        }
        return result;
    }

    public static FacesMessage createFacesMessage(FacesMessage.Severity severity, String messageTemplate, Object ... params) {
        return FacesMessages.createFacesMessage(severity, null, messageTemplate, params);
    }

    public static FacesMessage createFacesMessage(FacesMessage.Severity severity, String key, String defaultMessageTemplate, Object ... params) {
        StatusMessage message = new StatusMessage(FacesMessages.toSeverity(severity), key, null, defaultMessageTemplate, null);
        message.interpolate(params);
        return FacesMessages.toFacesMessage(message);
    }

    @Deprecated
    public void add(FacesMessage facesMessage) {
        if (facesMessage != null) {
            this.add(FacesMessages.toSeverity(facesMessage.getSeverity()), null, null, facesMessage.getSummary(), facesMessage.getDetail(), new Object[0]);
        }
    }

    @Deprecated
    public void add(FacesMessage.Severity severity, String messageTemplate, Object ... params) {
        this.add(FacesMessages.toSeverity(severity), messageTemplate, params);
    }

    @Deprecated
    public void addToControl(String id, FacesMessage.Severity severity, String messageTemplate, Object ... params) {
        this.addToControl(id, FacesMessages.toSeverity(severity), messageTemplate, params);
    }

    @Deprecated
    public void addFromResourceBundle(FacesMessage.Severity severity, String key, Object ... params) {
        this.addFromResourceBundle(FacesMessages.toSeverity(severity), key, params);
    }

    @Deprecated
    public void addFromResourceBundleOrDefault(FacesMessage.Severity severity, String key, String defaultMessageTemplate, Object ... params) {
        this.addFromResourceBundleOrDefault(FacesMessages.toSeverity(severity), key, defaultMessageTemplate, params);
    }

    @Deprecated
    public void addToControlFromResourceBundle(String id, FacesMessage.Severity severity, String key, Object ... params) {
        this.addToControlFromResourceBundle(id, FacesMessages.toSeverity(severity), key, params);
    }

    @Deprecated
    public void addToControlFromResourceBundleOrDefault(String id, FacesMessage.Severity severity, String key, String defaultMessageTemplate, Object ... params) {
        this.addToControlFromResourceBundleOrDefault(id, FacesMessages.toSeverity(severity), key, defaultMessageTemplate, params);
    }

    public static FacesMessages instance() {
        if (!Contexts.isConversationContextActive()) {
            throw new IllegalStateException("No active conversation context");
        }
        return (FacesMessages)Component.getInstance("org.jboss.seam.international.statusMessages", ScopeType.CONVERSATION);
    }
}

