/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.restlet.data.MediaType;
import org.restlet.resource.StreamRepresentation;
import org.restlet.util.ByteUtils;

public class InputRepresentation
extends StreamRepresentation {
    private InputStream inputStream;

    public InputRepresentation(InputStream inputStream, MediaType mediaType) {
        this(inputStream, mediaType, -1L);
    }

    public InputRepresentation(InputStream inputStream, MediaType mediaType, long expectedSize) {
        super(mediaType);
        this.setSize(expectedSize);
        this.inputStream = inputStream;
        this.setAvailable(inputStream != null);
        this.setTransient(true);
    }

    public synchronized InputStream getStream() throws IOException {
        InputStream result = this.inputStream;
        this.inputStream = null;
        this.setAvailable(false);
        return result;
    }

    public String getText() throws IOException {
        return ByteUtils.toString(this.getStream(), this.getCharacterSet());
    }

    public void write(OutputStream outputStream) throws IOException {
        ByteUtils.write(this.getStream(), outputStream);
    }
}

