/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.binding.alias;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.binding.alias.AliasVariableMapper;

public class AliasValueExpression
extends ValueExpression {
    private static final Log log = LogFactory.getLog(AliasValueExpression.class);
    private static final long serialVersionUID = 1L;
    protected final String id;
    protected final String var;

    public AliasValueExpression(String id, String var) {
        this.id = id;
        this.var = var;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AliasValueExpression)) {
            return false;
        }
        AliasValueExpression other = (AliasValueExpression)((Object)obj);
        return this.id.equals(other.id) && this.var.equals(other.var);
    }

    public int hashCode() {
        return this.id.hashCode() + this.var.hashCode();
    }

    public String getExpressionString() {
        return null;
    }

    public boolean isLiteralText() {
        return false;
    }

    public Class<?> getExpectedType() {
        return Object.class;
    }

    public Class<?> getType(ELContext context) {
        ValueExpression ve = this.resolveExpression(context);
        if (ve != null) {
            return ve.getType(context);
        }
        return Object.class;
    }

    public Object getValue(ELContext context) {
        ValueExpression ve = this.resolveExpression(context);
        Object res = null;
        if (ve != null) {
            res = ve.getValue(context);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Resolved expression var='%s' for mapper with id '%s': %s", this.var, this.id, res));
        }
        return res;
    }

    public boolean isReadOnly(ELContext context) {
        ValueExpression ve = this.resolveExpression(context);
        if (ve != null) {
            return ve.isReadOnly(context);
        }
        return true;
    }

    public void setValue(ELContext context, Object value) {
        ValueExpression ve = this.resolveExpression(context);
        if (ve != null) {
            ve.setValue(context, value);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Resolved expression var='%s' for mapper with id '%s' and set value: %s", this.var, this.id, value));
        }
    }

    protected ValueExpression resolveExpression(ELContext context) {
        FacesContext facesContext = (FacesContext)context.getContext(FacesContext.class);
        AliasVariableMapper vm = AliasVariableMapper.getVariableMapper(facesContext, this.id);
        if (vm == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("No alias variable mapper with id '%s' found in request for var '%s'", this.id, this.var));
            }
            return null;
        }
        ValueExpression ve = vm.resolveVariable(this.var);
        if (ve == null) {
            log.error((Object)String.format("Variable for var '%s' not found in alias variable mapper with id '%s'", this.var, this.id));
            return null;
        }
        return ve;
    }
}

