/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.binding.alias;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.binding.alias.AliasValueExpression;
import org.nuxeo.ecm.platform.ui.web.binding.alias.AliasVariableMapperWrapper;

public class AliasVariableMapper
extends VariableMapper {
    private static final Log log = LogFactory.getLog(AliasVariableMapper.class);
    public static final String REQUEST_MARKER = AliasVariableMapper.class.getName() + "_MARKER";
    protected String id;
    protected Map<String, ValueExpression> vars;
    protected List<String> blockedPatterns;

    public AliasVariableMapper() {
    }

    public AliasVariableMapper(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ValueExpression resolveVariable(String variable) {
        ValueExpression ve = null;
        if (this.vars != null) {
            ve = this.vars.get(variable);
        }
        return ve;
    }

    public ValueExpression setVariable(String variable, ValueExpression expression) {
        if (this.vars == null) {
            this.vars = new LinkedHashMap<String, ValueExpression>();
        }
        return this.vars.put(variable, expression);
    }

    public boolean hasVariables(String variable) {
        return this.vars != null && this.vars.containsKey(variable);
    }

    public VariableMapper getVariableMapperForBuild(VariableMapper orig) {
        AliasVariableMapperWrapper vm = new AliasVariableMapperWrapper(orig, this.getBlockedPatterns());
        Map<String, ValueExpression> vars = this.getVariables();
        if (vars != null) {
            String id = this.getId();
            for (Map.Entry<String, ValueExpression> var : vars.entrySet()) {
                vm.setVariable(var.getKey(), new AliasValueExpression(id, var.getKey()));
            }
        }
        return vm;
    }

    public Map<String, ValueExpression> getVariables() {
        return this.vars;
    }

    public List<String> getBlockedPatterns() {
        return this.blockedPatterns;
    }

    public void setBlockedPatterns(List<String> blockedPatterns) {
        this.blockedPatterns = blockedPatterns;
    }

    public static AliasVariableMapper getVariableMapper(FacesContext facesContext, String id) {
        ExternalContext ec = facesContext.getExternalContext();
        Map mappers = (Map)ec.getRequestMap().get(REQUEST_MARKER);
        if (mappers == null) {
            return null;
        }
        return (AliasVariableMapper)((Object)mappers.get(id));
    }

    public static void exposeAliasesToRequest(FacesContext facesContext, AliasVariableMapper vm) {
        ExternalContext ec;
        HashMap<String, AliasVariableMapper> mappers;
        if (vm == null) {
            return;
        }
        String id = vm.getId();
        if (id == null && log.isDebugEnabled()) {
            log.debug((Object)"Encountered alias variable mapper with null id");
        }
        if ((mappers = (HashMap<String, AliasVariableMapper>)(ec = facesContext.getExternalContext()).getRequestMap().get(REQUEST_MARKER)) == null) {
            mappers = new HashMap<String, AliasVariableMapper>();
        }
        if (mappers.containsKey(id) && log.isTraceEnabled()) {
            log.trace((Object)String.format("Overriding alias variable mapper with id '%s'", id));
        }
        mappers.put(id, vm);
        ec.getRequestMap().put(REQUEST_MARKER, mappers);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Expose alias variable mapper with id '%s' to request: %s", id, vm.getVariables()));
        }
    }

    public static void removeAliasesExposedToRequest(FacesContext facesContext, String id) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Remove alias variable mapper with id '%s' from request", id));
        }
        if (id == null) {
            return;
        }
        ExternalContext ec = facesContext.getExternalContext();
        Map mappers = (Map)ec.getRequestMap().get(REQUEST_MARKER);
        if (mappers != null) {
            mappers.remove(id);
        }
    }
}

