/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component;

import java.util.List;
import javax.el.ValueExpression;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.RendererUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.platform.ui.web.component.ResettableComponent;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;

@Name(value="jsfResetActions")
@Scope(value=ScopeType.EVENT)
public class JSFResetActionsBean {
    private static final Log log = LogFactory.getLog(JSFResetActionsBean.class);
    protected String baseComponentId;

    public String getBaseComponentId() {
        return this.baseComponentId;
    }

    public void setBaseComponentId(String baseComponentId) {
        this.baseComponentId = baseComponentId;
    }

    public void resetComponentsFor(ActionEvent event) {
        UIComponent component = event.getComponent();
        if (component == null) {
            return;
        }
        String baseCompId = this.getBaseComponentId();
        if (baseCompId != null) {
            FacesContext ctx = FacesContext.getCurrentInstance();
            UIComponent target = RendererUtils.getInstance().findComponentFor(component, baseCompId);
            if (target != null) {
                baseCompId = AjaxRendererUtils.getAbsoluteId((UIComponent)target);
            }
            UIComponent anchor = ctx.getViewRoot().findComponent(baseCompId);
            this.resetComponentResursive(anchor);
        } else {
            log.error((Object)"No base component id given => cannot reset components state.");
        }
    }

    public void resetComponents(ActionEvent event) {
        UIComponent component = event.getComponent();
        if (component == null) {
            return;
        }
        UIComponent anchor = ComponentUtils.getBase(component);
        this.resetComponentResursive(anchor);
    }

    public void resetComponent(UIComponent component) {
        this.resetComponent(component, false);
    }

    public void resetComponentResursive(UIComponent parent) {
        this.resetComponent(parent, true);
    }

    protected void resetComponent(UIComponent comp, boolean recursive) {
        List children;
        if (comp == null) {
            return;
        }
        if (comp instanceof ResettableComponent) {
            ((ResettableComponent)comp).resetCachedModel();
        } else {
            ValueExpression ve;
            if (comp instanceof EditableValueHolder) {
                ((EditableValueHolder)comp).setSubmittedValue(null);
            }
            if (comp instanceof ValueHolder && (ve = comp.getValueExpression("value")) != null) {
                ValueHolder vo = (ValueHolder)comp;
                vo.setValue(null);
                if (comp instanceof EditableValueHolder) {
                    ((EditableValueHolder)comp).setLocalValueSet(false);
                }
            }
        }
        if (recursive && (children = comp.getChildren()) != null && !children.isEmpty()) {
            for (UIComponent child : children) {
                this.resetComponent(child, recursive);
            }
        }
    }
}

