/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.document;

import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.renderkit.html_basic.OutputLinkRenderer;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.logging.Level;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.nuxeo.ecm.platform.ui.web.component.document.RestDocumentLink;
import org.nuxeo.ecm.platform.ui.web.rest.RestHelper;
import org.nuxeo.ecm.platform.ui.web.tag.fn.Functions;

public class RestDocumentLinkRenderer
extends OutputLinkRenderer {
    protected static final String[] PASSTHROUGHATTRIBUTES = new String[]{"accesskey", "charset", "coords", "dir", "hreflang", "lang", "onblur", "onclick", "ondblclick", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "rel", "rev", "shape", "style", "tabindex", "title", "type"};

    protected HtmlBasicRenderer.Param[] getParamList(UIComponent command) {
        return new HtmlBasicRenderer.Param[0];
    }

    protected void renderAsActive(FacesContext context, UIComponent component) throws IOException {
        String hrefVal = this.getCurrentValue(context, component);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Value to be rendered " + hrefVal);
        }
        if (!component.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("End encoding component " + component.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        writer.startElement("a", component);
        String writtenId = this.writeIdAttributeIfNecessary(context, writer, component);
        if (null != writtenId) {
            writer.writeAttribute("name", (Object)writtenId, "name");
        }
        if (null == hrefVal || 0 == hrefVal.length()) {
            hrefVal = "";
        }
        HtmlBasicRenderer.Param[] paramList = this.getParamList(component);
        StringBuffer sb = new StringBuffer();
        sb.append(hrefVal);
        boolean paramWritten = false;
        int len = paramList.length;
        for (int i = 0; i < len; ++i) {
            String pn = paramList[i].name;
            if (pn == null || pn.length() == 0) continue;
            String pv = paramList[i].value;
            sb.append(paramWritten ? (char)'&' : '?');
            sb.append(URLEncoder.encode(pn, "UTF-8"));
            sb.append('=');
            if (pv != null && pv.length() != 0) {
                sb.append(URLEncoder.encode(pv, "UTF-8"));
            }
            paramWritten = true;
        }
        String urlNewConversation = context.getExternalContext().encodeResourceURL(sb.toString());
        String urlCurrentConversation = RestHelper.addCurrentConversationParameters(urlNewConversation);
        writer.writeURIAttribute("href", (Object)urlNewConversation, "href");
        Boolean isNewConversation = ((RestDocumentLink)component).getNewConversation();
        if (!Boolean.TRUE.equals(isNewConversation)) {
            String onclickJS = "if(!(event.ctrlKey||event.metaKey||event.button==1)){this.href='" + Functions.javaScriptEscape(urlCurrentConversation) + "'}";
            writer.writeAttribute("onclick", (Object)onclickJS, "onclick");
        }
        RenderKitUtils.renderPassThruAttributes((ResponseWriter)writer, (UIComponent)component, (String[])PASSTHROUGHATTRIBUTES);
        RenderKitUtils.renderXHTMLStyleBooleanAttributes((ResponseWriter)writer, (UIComponent)component);
        String target = (String)component.getAttributes().get("target");
        if (target != null && target.trim().length() != 0) {
            writer.writeAttribute("target", (Object)target, "target");
        }
        this.writeCommonLinkAttributes(writer, component);
        writer.flush();
    }
}

