/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api;

import java.util.HashMap;
import java.util.Map;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.InitialContextAccessor;

public class DataSourceHelper {
    private static final Log log = LogFactory.getLog(DataSourceHelper.class);
    public static final String PREFIX_PROPERTY = "org.nuxeo.runtime.datasource.prefix";
    public static final String DEFAULT_PREFIX = "java:comp/env/jdbc";
    protected static String prefix;

    private DataSourceHelper() {
    }

    public static void autodetectPrefix() {
        String name;
        Context ctx = InitialContextAccessor.getInitialContext();
        String string = name = ctx == null ? null : ctx.getClass().getName();
        prefix = "org.jnp.interfaces.NamingContext".equals(name) ? "java:" : ("org.mortbay.naming.local.localContextRoot".equals(name) ? "jdbc" : DEFAULT_PREFIX);
        log.info((Object)("Using JDBC JNDI prefix: " + prefix));
    }

    public static String getDataSourceJNDIPrefix() {
        if (prefix == null) {
            if (Framework.isInitialized()) {
                String configuredPrefix = Framework.getProperty(PREFIX_PROPERTY);
                if (configuredPrefix != null) {
                    prefix = configuredPrefix;
                } else {
                    DataSourceHelper.autodetectPrefix();
                }
            } else {
                prefix = DEFAULT_PREFIX;
            }
        }
        return prefix;
    }

    public static String getDataSourceJNDIName(String partialName) {
        String targetPrefix = DataSourceHelper.getDataSourceJNDIPrefix();
        int idx = partialName.lastIndexOf("/");
        if (idx > 0) {
            partialName = partialName.substring(idx + 1);
        }
        return targetPrefix + "/" + partialName;
    }

    public static DataSource getDataSource(String partialName) throws NamingException {
        return DataSourceHelper.getDataSource(partialName, DataSource.class);
    }

    public static XADataSource getXADataSource(String partialName) throws NamingException {
        return DataSourceHelper.getDataSource(partialName, XADataSource.class);
    }

    public static <T> T getDataSource(String partialName, Class<T> clazz) throws NamingException {
        InitialContext context = new InitialContext();
        String jndiName = DataSourceHelper.getDataSourceJNDIName(partialName);
        Object resolved = context.lookup(jndiName);
        if (resolved instanceof Reference) {
            try {
                resolved = NamingManager.getObjectInstance(resolved, new CompositeName(jndiName), context, null);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot get access to " + jndiName, e);
            }
        }
        return clazz.cast(resolved);
    }

    public static Map<String, DataSource> getDatasources() throws NamingException {
        String prefix = DataSourceHelper.getDataSourceJNDIPrefix();
        InitialContext naming = new InitialContext();
        Context jdbc = (Context)naming.lookup(prefix);
        NamingEnumeration<NameClassPair> namesPair = jdbc.list("");
        HashMap<String, DataSource> datasourcesByName = new HashMap<String, DataSource>();
        while (namesPair.hasMoreElements()) {
            Object ds;
            NameClassPair pair = (NameClassPair)namesPair.nextElement();
            String name = pair.getName();
            if (pair.isRelative()) {
                name = prefix + "/" + name;
            }
            if (!((ds = naming.lookup(name)) instanceof DataSource)) continue;
            datasourcesByName.put(name, (DataSource)ds);
        }
        return datasourcesByName;
    }
}

