/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api.login;

import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.commons.logging.LogFactory;

public class LoginConfiguration
extends Configuration {
    public static final LoginConfiguration INSTANCE = new LoginConfiguration();
    protected final AtomicInteger counter = new AtomicInteger(0);
    protected final InheritableThreadLocal<Provider> holder = new InheritableThreadLocal<Provider>(){

        @Override
        protected Provider initialValue() {
            return LoginConfiguration.this.context.provider;
        }
    };
    protected InstallContext context;

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        AppConfigurationEntry[] appConfigurationEntry = ((Provider)this.holder.get()).getAppConfigurationEntry(name);
        if (appConfigurationEntry == null && this.context.parent != null) {
            appConfigurationEntry = this.context.parent.getAppConfigurationEntry(name);
        }
        return appConfigurationEntry;
    }

    @Override
    public void refresh() {
        this.context.parent.refresh();
    }

    public void install(Provider provider) {
        this.holder.set(provider);
        int count = this.counter.incrementAndGet();
        if (count == 1) {
            this.context = new InstallContext(provider);
            Configuration.setConfiguration(this);
            LogFactory.getLog(LoginConfiguration.class).trace((Object)"installed login configuration", this.context.stacktrace);
        }
    }

    public void uninstall() {
        this.holder.remove();
        int count = this.counter.decrementAndGet();
        if (count == 0) {
            LogFactory.getLog(LoginConfiguration.class).trace((Object)("uninstalled login configuration " + this.context.thread), this.context.stacktrace);
            Configuration.setConfiguration(this.context.parent);
            this.context = null;
        }
    }

    public void cleanupThisThread() {
        this.holder.remove();
    }

    protected class InstallContext {
        protected final Configuration parent = Configuration.getConfiguration();
        protected final Provider provider;
        protected final Thread thread = Thread.currentThread();
        protected final Throwable stacktrace = new Throwable();

        protected InstallContext(Provider provider) {
            this.provider = provider;
        }

        public String toString() {
            return "Login Installation Context [parent=" + this.parent + ", thread=" + this.thread + "]";
        }
    }

    public static interface Provider {
        public AppConfigurationEntry[] getAppConfigurationEntry(String var1);
    }
}

