/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.seam.messages;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Locale;
import org.jboss.seam.core.SeamResourceBundle;
import org.jboss.seam.international.Messages;
import org.nuxeo.ecm.webapp.seam.messages.HotReloadResourceBundleControl;

@Scope(value=ScopeType.STATELESS)
@BypassInterceptors
@Name(value="org.jboss.seam.international.messagesFactory")
@Install(precedence=20, debug=false)
public class HotReloadMessages
extends Messages {
    protected Map createMap() {
        return new AbstractMap<String, String>(){
            private ResourceBundle seamResourceBundle = this.getSeamResourceBundle();

            protected ResourceBundle getSeamResourceBundle() {
                HotReloadResourceBundleControl control = HotReloadResourceBundleControl.instance();
                return ResourceBundle.getBundle(SeamResourceBundle.class.getName(), Locale.instance(), Thread.currentThread().getContextClassLoader(), control);
            }

            @Override
            public String get(Object key) {
                if (key instanceof String) {
                    String resourceKey = (String)key;
                    String resource = null;
                    ResourceBundle bundle = this.seamResourceBundle;
                    if (bundle != null) {
                        try {
                            resource = bundle.getString(resourceKey);
                        }
                        catch (MissingResourceException mre) {
                            // empty catch block
                        }
                    }
                    return resource == null ? resourceKey : resource;
                }
                return null;
            }

            @Override
            public Set<Map.Entry<String, String>> entrySet() {
                ResourceBundle bundle = this.seamResourceBundle;
                Enumeration<String> keys = bundle.getKeys();
                HashMap<String, String> map = new HashMap<String, String>();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    map.put(key, this.get(key));
                }
                return Collections.unmodifiableSet(map.entrySet());
            }

            @Override
            public boolean containsKey(Object key) {
                return this.get(key) != null;
            }

            @Override
            public Set<String> keySet() {
                ResourceBundle bundle = this.seamResourceBundle;
                Enumeration<String> keys = bundle.getKeys();
                return new HashSet<String>(Collections.list(keys));
            }

            @Override
            public int size() {
                return this.keySet().size();
            }
        };
    }
}

