/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.search;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;

@Name(value="documentSearchActions")
@Scope(value=ScopeType.CONVERSATION)
public class DocumentSearchActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String simpleSearchKeywords = "";
    protected String nxqlQuery = "";
    protected List<String> selectedLayoutColumns;
    protected List<SortInfo> searchSortInfos;

    public String getSimpleSearchKeywords() {
        return this.simpleSearchKeywords;
    }

    public void setSimpleSearchKeywords(String simpleSearchKeywords) {
        this.simpleSearchKeywords = simpleSearchKeywords;
    }

    public void validateSimpleSearchKeywords(FacesContext context, UIComponent component, Object value) {
        String[] keywords;
        if (!(value instanceof String) || StringUtils.isEmpty((String)((String)value).trim())) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"feedback.search.noKeywords"), null);
            context.addMessage(null, message);
            throw new ValidatorException(message);
        }
        for (String keyword : keywords = ((String)value).trim().split(" ")) {
            if (!keyword.startsWith("*")) continue;
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"feedback.search.star"), null);
            context.addMessage(null, message);
            throw new ValidatorException(message);
        }
    }

    public String getNxqlQuery() {
        return this.nxqlQuery;
    }

    public void setNxqlQuery(String nxqlQuery) {
        this.nxqlQuery = nxqlQuery;
    }

    public List<String> getSelectedLayoutColumns() {
        return this.selectedLayoutColumns;
    }

    public void setSelectedLayoutColumns(List<String> selectedLayoutColumns) {
        this.selectedLayoutColumns = selectedLayoutColumns;
    }

    public void resetSelectedLayoutColumns() {
        this.setSelectedLayoutColumns(null);
    }

    public List<SortInfo> getSearchSortInfos() {
        return this.searchSortInfos;
    }

    public void setSearchSortInfos(List<SortInfo> searchSortInfos) {
        this.searchSortInfos = searchSortInfos;
    }

    public SortInfo getNewSortInfo() {
        return new SortInfo("", true);
    }

    public Map<String, Serializable> getNewSortInfoMap() {
        SortInfo sortInfo = this.getNewSortInfo();
        return SortInfo.asMap((SortInfo)sortInfo);
    }

    @BypassInterceptors
    public void resetSearches() {
        this.simpleSearchKeywords = "";
        this.nxqlQuery = "";
    }

    @Observer(value={"flush"}, create=false)
    @BypassInterceptors
    public void onHotReloadFlush() {
        this.selectedLayoutColumns = null;
        this.searchSortInfos = null;
    }
}

