/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.jmx;

import org.javasimon.Callback;
import org.javasimon.Manager;
import org.javasimon.Simon;
import org.javasimon.SimonState;
import org.javasimon.Stopwatch;
import org.javasimon.StopwatchSample;
import org.javasimon.jdbc.logging.LoggingCallback;
import org.javasimon.jmx.JdbcMXBean;
import org.javasimon.jmx.JdbcObjectInfo;
import org.javasimon.utils.SimonUtils;

public class JdbcMXBeanImpl
implements JdbcMXBean {
    private Manager manager;
    private String prefix;

    public JdbcMXBeanImpl(Manager manager) {
        this.manager = manager;
        this.prefix = "org.javasimon.jdbc";
    }

    public JdbcMXBeanImpl(Manager manager, String prefix) {
        this.manager = manager;
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String value) {
        this.prefix = value;
    }

    public void enableMonitoring() {
        Simon s = this.manager.getSimon(this.prefix);
        if (s != null) {
            s.setState(SimonState.ENABLED, true);
        }
    }

    public void disableMonitoring() {
        Simon s = this.manager.getSimon(this.prefix);
        if (s != null) {
            s.setState(SimonState.DISABLED, true);
        }
    }

    public boolean isMonitoringEnabled() {
        return this.manager.getSimon(this.prefix) != null && this.manager.getSimon(this.prefix).isEnabled();
    }

    @Deprecated
    public void logToFile(String filename, String format) {
        this.stopLogging();
        LoggingCallback jlc = new LoggingCallback();
        jlc.setPrefix(this.prefix);
        jlc.setLogFilename(filename);
        jlc.setLogFormat(format);
        this.manager.callback().addCallback((Callback)jlc);
    }

    @Deprecated
    public void logToLogger(String logger, String format) {
        this.stopLogging();
        LoggingCallback jlc = new LoggingCallback();
        jlc.setPrefix(this.prefix);
        jlc.setLoggerName(logger);
        jlc.setLogFormat(format);
        this.manager.callback().addCallback((Callback)jlc);
    }

    @Deprecated
    public void logToConsole(String format) {
        this.stopLogging();
        LoggingCallback jlc = new LoggingCallback();
        jlc.setPrefix(this.prefix);
        jlc.setLogToConsole();
        jlc.setLogFormat(format);
        this.manager.callback().addCallback((Callback)jlc);
    }

    @Deprecated
    public void stopLogging() {
        for (Callback c : this.manager.callback().callbacks()) {
            if (!(c instanceof LoggingCallback) || !((LoggingCallback)c).getPrefix().equalsIgnoreCase(this.prefix)) continue;
            this.manager.callback().removeCallback(c);
        }
    }

    public JdbcObjectInfo connectionsStat() {
        Stopwatch s = this.manager.getStopwatch(this.prefix + ".conn");
        if (s != null) {
            return new JdbcObjectInfo(s.getActive(), s.getMaxActive(), s.getMaxActiveTimestamp(), s.getCounter(), s.getCounter() - s.getActive(), s.getMin(), s.getMax(), s.getTotal());
        }
        return null;
    }

    public JdbcObjectInfo statementsStat() {
        Stopwatch s = this.manager.getStopwatch(this.prefix + ".stmt");
        if (s != null) {
            return new JdbcObjectInfo(s.getActive(), s.getMaxActive(), s.getMaxActiveTimestamp(), s.getCounter(), s.getCounter() - s.getActive(), s.getMin(), s.getMax(), s.getTotal());
        }
        return null;
    }

    public JdbcObjectInfo resultsetsStat() {
        return null;
    }

    public String[] getSqlCommands() {
        Simon s = this.manager.getSimon(this.prefix + ".sql");
        if (s != null) {
            String[] names = new String[s.getChildren().size()];
            int i = 0;
            for (Simon sn : s.getChildren()) {
                names[i++] = SimonUtils.localName((String)sn.getName());
            }
            return names;
        }
        return new String[0];
    }

    public org.javasimon.jmx.StopwatchSample getSqlCommandStat(String cmdId) {
        if (this.manager.getSimon(this.prefix + ".sql." + cmdId) != null) {
            return new org.javasimon.jmx.StopwatchSample((StopwatchSample)this.manager.getStopwatch(this.prefix + ".sql." + cmdId).sample());
        }
        return null;
    }

    public String[] getSqls(String cmdId) {
        Simon s = this.manager.getSimon(this.prefix + ".sql." + cmdId);
        if (s != null) {
            String[] names = new String[s.getChildren().size()];
            int i = 0;
            for (Simon sn : s.getChildren()) {
                names[i++] = SimonUtils.localName((String)sn.getName());
            }
            return names;
        }
        return new String[0];
    }

    public org.javasimon.jmx.StopwatchSample getSqlStat(String sqlId) {
        if (this.manager != null) {
            for (String s : this.manager.simonNames()) {
                if (!SimonUtils.localName((String)s).equals(sqlId)) continue;
                return new org.javasimon.jmx.StopwatchSample((StopwatchSample)this.manager.getStopwatch(s).sample());
            }
        }
        return null;
    }
}

