/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.jmx;

import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.javasimon.CallbackSkeleton;
import org.javasimon.Counter;
import org.javasimon.Simon;
import org.javasimon.Stopwatch;
import org.javasimon.jmx.AbstractSimonMXBeanImpl;
import org.javasimon.jmx.CounterMXBeanImpl;
import org.javasimon.jmx.StopwatchMXBeanImpl;

public class JmxRegisterCallback
extends CallbackSkeleton {
    private MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
    private Set<String> registeredNames = new HashSet<String>();

    public void simonCreated(Simon simon) {
        if (simon.getName() == null) {
            return;
        }
        this.register(simon);
    }

    public void simonDestroyed(Simon simon) {
        String name = this.constructObjectName(simon);
        try {
            ObjectName objectName = new ObjectName(name);
            this.mBeanServer.unregisterMBean(objectName);
            this.registeredNames.remove(name);
            this.message("Unregistered Simon with the name: " + objectName);
        }
        catch (JMException e) {
            this.warning("JMX unregistration failed for: " + name, e);
        }
    }

    public void clear() {
        Iterator<String> namesIter = this.registeredNames.iterator();
        while (namesIter.hasNext()) {
            String name = namesIter.next();
            try {
                ObjectName objectName = new ObjectName(name);
                this.mBeanServer.unregisterMBean(objectName);
                namesIter.remove();
                this.message("Unregistered Simon with the name: " + objectName);
            }
            catch (JMException e) {
                this.warning("JMX unregistration failed for: " + name, e);
            }
        }
    }

    protected final void register(Simon simon) {
        AbstractSimonMXBeanImpl simonMxBean;
        if (simon instanceof Counter) {
            simonMxBean = new CounterMXBeanImpl((Counter)simon);
        } else if (simon instanceof Stopwatch) {
            simonMxBean = new StopwatchMXBeanImpl((Stopwatch)simon);
        } else {
            this.warning("Unknown type of Simon! " + simon, null);
            return;
        }
        String name = this.constructObjectName(simon);
        try {
            ObjectName objectName = new ObjectName(name);
            if (this.mBeanServer.isRegistered(objectName)) {
                this.mBeanServer.unregisterMBean(objectName);
            } else {
                this.registeredNames.add(name);
            }
            this.mBeanServer.registerMBean(simonMxBean, objectName);
            this.message("Simon registered under the name: " + objectName);
        }
        catch (JMException e) {
            this.warning("JMX registration failed for: " + name, e);
            this.registeredNames.remove(name);
        }
    }

    protected String constructObjectName(Simon simon) {
        return simon.getName() + ":type=" + this.simonType(simon);
    }

    protected String simonType(Simon simon) {
        String type = "Unknown";
        if (simon instanceof Counter) {
            type = "Counter";
        } else if (simon instanceof Stopwatch) {
            type = "Stopwatch";
        }
        return type;
    }
}

