/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.lifecycle.event;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class BulkLifeCycleChangeListener
implements PostCommitEventListener {
    private static final Log log = LogFactory.getLog(BulkLifeCycleChangeListener.class);

    public void handleEvent(EventBundle events) throws ClientException {
        if (!(events.containsEventName("lifecycle_transition_event") || events.containsEventName("documentUndeleted") || events.containsEventName("documentCreatedByCopy"))) {
            return;
        }
        for (Event event : events) {
            String name = event.getName();
            if (!"lifecycle_transition_event".equals(name) && !"documentUndeleted".equals(name) && !"documentCreatedByCopy".equals(name)) continue;
            this.processTransition(event);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processTransition(Event event) {
        String targetState;
        String transition;
        log.debug((Object)"Processing lifecycle change in async listener");
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        if (!doc.isFolder() && !"documentCreatedByCopy".equals(event.getName())) {
            return;
        }
        CoreSession session = docCtx.getCoreSession();
        if (session == null) {
            log.error((Object)"Can not process lifeCycle change since session is null");
            return;
        }
        if ("documentCreatedByCopy".equals(event.getName())) {
            if (!Boolean.TRUE.equals(event.getContext().getProperties().get("resetLifeCycle"))) {
                return;
            }
            try {
                DocumentModelListImpl docs = new DocumentModelListImpl();
                docs.add((Object)doc);
                if (!session.exists(doc.getRef())) return;
                this.reinitDocumentsLifeCyle(session, (DocumentModelList)docs);
                session.save();
                return;
            }
            catch (ClientException e) {
                log.error((Object)"Unable to get children", (Throwable)e);
                return;
            }
        }
        if ("lifecycle_transition_event".equals(event.getName())) {
            transition = (String)((Object)docCtx.getProperty("transition"));
            if (this.isNonRecursiveTransition(transition, doc.getType())) {
                return;
            }
            if ("undelete".equals(transition)) {
                return;
            }
            targetState = (String)((Object)docCtx.getProperty("to"));
        } else {
            transition = "undelete";
            targetState = "";
        }
        try {
            DocumentModelList docs = session.getChildren(doc.getRef());
            this.changeDocumentsState(session, docs, transition, targetState);
            session.save();
            return;
        }
        catch (ClientException e) {
            log.error((Object)"Unable to get children", (Throwable)e);
            return;
        }
    }

    protected void reinitDocumentsLifeCyle(CoreSession documentManager, DocumentModelList docs) throws ClientException {
        for (DocumentModel docMod : docs) {
            documentManager.reinitLifeCycleState(docMod.getRef());
            if (!docMod.isFolder()) continue;
            DocumentModelList children = documentManager.query(String.format("SELECT * FROM Document WHERE ecm:currentLifeCycleState != 'deleted' AND ecm:parentId = '%s'", docMod.getRef()));
            this.reinitDocumentsLifeCyle(documentManager, children);
        }
    }

    protected boolean isNonRecursiveTransition(String transition, String type) {
        List<String> nonRecursiveTransitions = NXCore.getLifeCycleService().getNonRecursiveTransitionForDocType(type);
        return nonRecursiveTransitions.contains(transition);
    }

    protected void changeDocumentsState(CoreSession documentManager, DocumentModelList docModelList, String transition, String targetState) throws ClientException {
        for (DocumentModel docMod : docModelList) {
            boolean removed = false;
            if (docMod.getCurrentLifeCycleState() == null) {
                if ("deleted".equals(targetState)) {
                    log.debug((Object)"Doc has no lifecycle, deleting ...");
                    documentManager.removeDocument(docMod.getRef());
                    removed = true;
                }
            } else if (docMod.getAllowedStateTransitions().contains(transition) && !docMod.isProxy()) {
                docMod.followTransition(transition);
            } else if (targetState.equals(docMod.getCurrentLifeCycleState())) {
                log.debug((Object)("Document" + docMod.getRef() + " is already in the target LifeCycle state"));
            } else if ("deleted".equals(targetState)) {
                log.debug((Object)("Impossible to change state of " + docMod.getRef() + " :removing"));
                documentManager.removeDocument(docMod.getRef());
                removed = true;
            } else {
                log.debug((Object)("Document" + docMod.getRef() + " has no transition to the target LifeCycle state"));
            }
            if (!docMod.isFolder() || removed) continue;
            this.changeDocumentsState(documentManager, documentManager.getChildren(docMod.getRef()), transition, targetState);
        }
    }
}

