/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.management;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.api.Framework;

@XObject(value="locator")
public class ServerLocatorDescriptor {
    private static final Log log = LogFactory.getLog(ServerLocatorDescriptor.class);
    @XNode(value="@default")
    protected boolean isDefault = true;
    protected boolean isExisting = true;
    protected int rmiPort = 1099;
    @XNode(value="@domain")
    protected String domainName;
    @XNode(value="@remote")
    protected boolean remote = true;

    public ServerLocatorDescriptor() {
        this.domainName = "";
    }

    public ServerLocatorDescriptor(String domainName, boolean isDefaultServer) {
        this.domainName = domainName;
        this.isDefault = isDefaultServer;
    }

    @XNode(value="@exist")
    public void setExisting(String value) {
        String expandedValue = Framework.expandVars((String)value);
        if (expandedValue.startsWith("$")) {
            log.warn((Object)("Cannot expand " + value + " for existing server"));
            return;
        }
        this.isExisting = Boolean.parseBoolean(expandedValue);
    }

    @XNode(value="@rmiPort")
    public void setRmiPort(String value) {
        String expandedValue = Framework.expandVars((String)value);
        if (expandedValue.startsWith("$")) {
            log.warn((Object)("Cannot expand " + value + " for server locator"));
            return;
        }
        this.rmiPort = Integer.parseInt(expandedValue);
    }
}

