/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.management.metrics;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.javasimon.CallbackSkeleton;
import org.javasimon.Counter;
import org.javasimon.Sample;
import org.javasimon.Split;
import org.nuxeo.runtime.management.metrics.MetricSerializer;

public class MetricSerializingCallback
extends CallbackSkeleton {
    protected static final Log log = LogFactory.getLog(MetricSerializingCallback.class);
    protected final MetricSerializer serializer;

    public MetricSerializingCallback(MetricSerializer serializer) {
        this.serializer = serializer;
    }

    public void stopwatchStop(Split split) {
        this.toStream(split.getStopwatch().sample());
    }

    public void counterSet(Counter counter, long val) {
        this.toStream(counter.sample());
    }

    protected void toStream(Sample sample) {
        try {
            this.serializer.toStream(sample);
        }
        catch (IOException e) {
            log.info((Object)("not streamed " + sample), (Throwable)e);
        }
    }
}

