/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss;

public class WSSConfig {
    protected static WSSConfig instance;
    public static final String DEFAULT_TS_SERVER_VERSION = "12.0.0.6219";
    protected String TSServerVersion = "12.0.0.6219";
    public static final String DEFAULT_WSS_SERVER_VERSION = "12.0.0.6421";
    protected String WSSServerVersion = "12.0.0.6421";
    public static final String DEFAULT_FP_SERVER_VERSION = "12.0.0.000";
    protected String FPServerVersion = "12.0.0.000";
    protected String wssBackendFactoryClassName = "org.nuxeo.wss.spi.dummy.DummyBackendFactory";
    protected String contextPath = "";
    protected boolean hostFPExtensionAtRoot = true;
    public static final String DEFAULT_ENCODING = "org.nuxeo.wss.handler.windows.encoding";

    public static synchronized WSSConfig instance() {
        if (instance == null) {
            instance = new WSSConfig();
        }
        return instance;
    }

    public String getWSSServerVersion() {
        return this.WSSServerVersion;
    }

    public String getWSSServerVersionMajor() {
        return this.WSSServerVersion.split("\\.")[0];
    }

    public String getWSSServerVersionMinor() {
        return this.WSSServerVersion.split("\\.")[1];
    }

    public String getWSSServerVersionPhase() {
        return this.WSSServerVersion.split("\\.")[2];
    }

    public String getWSSServerVersionBuild() {
        return this.WSSServerVersion.split("\\.")[3];
    }

    public String getTSServerVersion() {
        return this.TSServerVersion;
    }

    public String getTSServerVersionMajor() {
        return this.TSServerVersion.split("\\.")[0];
    }

    public String getTSServerVersionMinor() {
        return this.TSServerVersion.split("\\.")[1];
    }

    public String getTSServerVersionPhase() {
        return this.TSServerVersion.split("\\.")[2];
    }

    public String getTSServerVersionBuild() {
        return this.TSServerVersion.split("\\.")[3];
    }

    public void setWSSServerVersion(String serverVersion) {
        this.WSSServerVersion = serverVersion;
    }

    public String getFPServerVersion() {
        return this.FPServerVersion;
    }

    public String getTZOffset() {
        return "+0200";
    }

    public String getLang() {
        return "1033";
    }

    public String getWssBackendFactoryClassName() {
        return this.wssBackendFactoryClassName;
    }

    public void setWssBackendFactoryClassName(String wssBackendFactoryClassName) {
        this.wssBackendFactoryClassName = wssBackendFactoryClassName;
    }

    public String getResourcesUrlPattern() {
        return "/resources/";
    }

    public String getResourcesBasePath() {
        return "webresources/";
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String path) {
        this.contextPath = path;
        if (!this.contextPath.endsWith("/")) {
            this.contextPath = this.contextPath + "/";
        }
        if (this.contextPath.startsWith("/")) {
            this.contextPath = this.contextPath.substring(1);
        }
    }

    public String getWSSUrlPrefix() {
        return "_vti_bin";
    }

    public boolean isHostFPExtensionAtRoot() {
        return this.hostFPExtensionAtRoot;
    }

    public void setHostFPExtensionAtRoot(boolean hostFPExtensionAtRoot) {
        this.hostFPExtensionAtRoot = hostFPExtensionAtRoot;
    }
}

