/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core.worker;

import java.lang.reflect.Constructor;
import java.util.List;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.query.nxql.NXQLQueryBuilder;
import org.nuxeo.runtime.api.Framework;

public abstract class RemovedAbstractWork
extends AbstractWork {
    private static final long serialVersionUID = 5240954386944920642L;
    protected long offset = 0L;

    protected abstract String getQuery();

    public RemovedAbstractWork() {
        this(0L);
    }

    protected RemovedAbstractWork(long offset) {
        this.offset = offset;
    }

    public String getId() {
        return this.repositoryName + ":" + this.docId + ":" + this.offset;
    }

    public void work() throws Exception {
        this.setStatus("Updating");
        if (this.docId != null) {
            this.initSession();
            List<DocumentModel> results = this.getNextResults();
            int nbResult = results.size();
            this.setProgress(new Work.Progress(0L, (long)results.size()));
            for (int i = 0; i < nbResult; ++i) {
                this.updateDocument(results.get(i));
                this.setProgress(new Work.Progress(0L, (long)nbResult));
            }
            if ((long)nbResult == 50L) {
                this.setStatus("Rescheduling next work");
                Constructor<?> c = ((Object)((Object)this)).getClass().getDeclaredConstructor(Long.TYPE);
                RemovedAbstractWork nextWork = (RemovedAbstractWork)((Object)c.newInstance(this.offset + 50L));
                nextWork.setDocument(this.repositoryName, this.docId);
                WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
                workManager.schedule((Work)nextWork, WorkManager.Scheduling.IF_NOT_SCHEDULED, true);
                this.setStatus("Rescheduling Done");
            }
        }
        this.setStatus("Updating Done");
    }

    protected abstract void updateDocument(DocumentModel var1) throws ClientException;

    private List<DocumentModel> getNextResults() throws ClientException {
        Object[] parameters = new Object[]{this.docId};
        String query = NXQLQueryBuilder.getQuery((String)this.getQuery(), (Object[])parameters, (boolean)true, (boolean)false, (SortInfo[])new SortInfo[0]);
        DocumentModelList results = this.session.query(query, null, 50L, 0L, 50L);
        return results;
    }
}

