/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webdav.backend;

import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.webdav.backend.Backend;
import org.nuxeo.ecm.webdav.backend.BackendFactory;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.WebContext;

public abstract class AbstractBackendFactory
implements BackendFactory {
    @Override
    public Backend getBackend(String path, HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("null request");
        }
        Backend backend = (Backend)request.getAttribute("org.nuxeo.ecm.webdav.service.backend");
        if (backend == null) {
            WebContext webContext = WebEngine.getActiveContext();
            if (webContext == null) {
                throw new NullPointerException("null WebContext");
            }
            CoreSession session = webContext.getCoreSession();
            if (session == null) {
                throw new NullPointerException("null CoreSession");
            }
            backend = this.createRootBackend(session);
            request.setAttribute("org.nuxeo.ecm.webdav.service.backend", (Object)backend);
        }
        return backend.getBackend(path);
    }

    public abstract Backend createRootBackend(CoreSession var1);
}

