/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.exception;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.automation.ChainException;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class ChainExceptionRegistry
extends ContributionFragmentRegistry<ChainException> {
    protected final Map<String, ChainException> chainExceptions = new HashMap<String, ChainException>();
    protected volatile Map<String, ChainException> lookup;

    public synchronized void addContribution(ChainException chainException, boolean replace) throws OperationException {
        if (!replace && this.chainExceptions.containsKey(chainException.getId())) {
            throw new OperationException("An exception chain is already bound to: " + chainException.getId() + ". Use 'replace=true' to replace an existing exception chain");
        }
        super.addContribution((Object)chainException);
    }

    public boolean isSupportingMerge() {
        return false;
    }

    public String getContributionId(ChainException contrib) {
        return contrib.getId();
    }

    public void contributionUpdated(String id, ChainException contrib, ChainException newOrigContrib) {
        this.chainExceptions.put(id, contrib);
        this.lookup = null;
    }

    public void contributionRemoved(String id, ChainException origContrib) {
        this.chainExceptions.remove(id);
        this.lookup = null;
    }

    public ChainException clone(ChainException orig) {
        throw new UnsupportedOperationException();
    }

    public void merge(ChainException src, ChainException dst) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ChainException> lookup() {
        Map<String, ChainException> _lookup = this.lookup;
        if (_lookup == null) {
            ChainExceptionRegistry chainExceptionRegistry = this;
            synchronized (chainExceptionRegistry) {
                _lookup = this.lookup = new HashMap<String, ChainException>(this.chainExceptions);
            }
        }
        return _lookup;
    }

    public ChainException getChainException(String onChainId) {
        for (ChainException chainException : this.lookup().values()) {
            if (!onChainId.equals(chainException.getOnChainId())) continue;
            return chainException;
        }
        return null;
    }
}

