/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.OutputCollector;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.impl.InvokableMethod;
import org.nuxeo.ecm.automation.core.impl.IterableInputHelper;

public class InvokableIteratorMethod
extends InvokableMethod {
    protected Class<? extends OutputCollector> collector;

    public InvokableIteratorMethod(OperationType op, Method method, OperationMethod anno) {
        super(op, method, anno);
        this.collector = anno.collector();
        if (this.collector == OutputCollector.class) {
            throw new IllegalArgumentException("Not an iterable method");
        }
        if (this.consume == Void.TYPE) {
            throw new IllegalArgumentException("An iterable method must have an argument");
        }
        Type[] ctypes = IterableInputHelper.findCollectorTypes(this.collector);
        if (!((Class)ctypes[0]).isAssignableFrom(this.produce)) {
            throw new IllegalArgumentException("The collector used on " + method + " doesn't match the method return type");
        }
        try {
            this.produce = (Class)ctypes[1];
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid output collector: " + this.collector + ". No getOutput method found.");
        }
    }

    @Override
    public boolean isIterable() {
        return true;
    }

    @Override
    public int inputMatch(Class<?> in) {
        Class<?> iterableIn = IterableInputHelper.getIterableType(in);
        if (iterableIn != null) {
            return super.inputMatch(iterableIn);
        }
        return 0;
    }

    @Override
    protected Object doInvoke(OperationContext ctx, Map<String, Object> args, Object input) throws Exception {
        if (!(input instanceof Iterable)) {
            throw new IllegalStateException("An iterable method was called in a non iterable context");
        }
        OutputCollector list = this.collector.newInstance();
        Iterable iterable = (Iterable)input;
        for (Object in : iterable) {
            ctx.setInput(in);
            list.collect(ctx, super.doInvoke(ctx, args, in));
        }
        return list.getOutput();
    }
}

