/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentRefList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;

@Operation(id="Context.RestoreDocumentsInput", category="Execution Context", label="Restore Documents Input", description="Restore the document list input from a context variable given its name. Return the document list.")
public class RestoreDocumentsInput {
    public static final String ID = "Context.RestoreDocumentsInput";
    @Context
    protected OperationContext ctx;
    @Param(name="name")
    protected String name;

    @OperationMethod
    public DocumentModelList run() throws Exception {
        Object obj = this.ctx.get(this.name);
        if (obj instanceof DocumentModelList) {
            return (DocumentModelList)obj;
        }
        if (obj instanceof DocumentRefList) {
            CoreSession session = this.ctx.getCoreSession();
            DocumentRefList refs = (DocumentRefList)obj;
            DocumentModelListImpl list = new DocumentModelListImpl((int)refs.totalSize());
            for (DocumentRef ref : refs) {
                list.add((Object)session.getDocument(ref));
            }
        }
        throw new OperationException("Illegal state error for restore documents operation. The context stack doesn't contains a documents variable with the name " + this.name);
    }
}

