/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.operations.document.DocumentPermissionHelper;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;

@Operation(id="Document.RemovePermission", category="Document", label="Remove Permission", description="Remove permissions for a given user on the input document(s). Returns the document(s).")
public class RemovePermission {
    public static final String ID = "Document.RemovePermission";
    @Context
    protected CoreSession session;
    @Param(name="user")
    protected String user;
    @Param(name="acl", required=false)
    String aclName = "local";

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws ClientException {
        this.removePermission(doc);
        return this.session.getDocument(doc.getRef());
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentRef docRef) throws ClientException {
        DocumentModel doc = this.session.getDocument(docRef);
        this.removePermission(doc);
        return doc;
    }

    protected void removePermission(DocumentModel doc) throws ClientException {
        Object acp = doc.getACP() != null ? doc.getACP() : new ACPImpl();
        boolean permissionChanged = DocumentPermissionHelper.removePermission(acp, this.aclName, this.user);
        if (permissionChanged) {
            doc.setACP(acp, true);
        }
    }
}

