/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.stack;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;

@Operation(id="Document.Pull", category="Push & Pop", label="Pull Document", description="Restore the first saved input document in the context input stack. This operation must be used only if a PUSH operation was previously made. Return the first <i>pushed</i> document.")
public class PullDocument {
    public static final String ID = "Document.Pull";
    @Context
    protected OperationContext ctx;

    @OperationMethod
    public DocumentModel run() throws Exception {
        Object obj = this.ctx.pull("document");
        if (obj instanceof DocumentModel) {
            return (DocumentModel)obj;
        }
        if (obj instanceof DocumentRef) {
            return this.ctx.getCoreSession().getDocument((DocumentRef)obj);
        }
        throw new OperationException("Illegal state error for pull document operation. The context stack doesn't contains a document on its bottom");
    }
}

