/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.trace;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.trace.Call;
import org.nuxeo.ecm.automation.core.trace.TracePrinter;
import org.nuxeo.ecm.automation.core.trace.TracerFactory;
import org.nuxeo.runtime.api.Framework;

public class Trace {
    protected final Call parent;
    protected final OperationType chain;
    protected final OperationException error;
    protected final Object output;
    protected final List<Call> operations;

    Trace(Call parent, OperationType chain, List<Call> operations) {
        this.parent = parent;
        this.chain = chain != null ? chain : operations.get(0).getType();
        this.operations = new ArrayList<Call>(operations);
        this.output = null;
        this.error = null;
    }

    Trace(Call parent, OperationType chain, List<Call> calls, OperationException error) {
        this.parent = parent;
        this.chain = chain != null ? chain : calls.get(0).getType();
        this.operations = new ArrayList<Call>(calls);
        this.output = null;
        this.error = error;
    }

    Trace(Call parent, OperationType chain, List<Call> calls, Object output) {
        this.parent = parent;
        this.chain = chain != null ? chain : calls.get(0).getType();
        this.operations = new ArrayList<Call>(calls);
        this.output = output;
        this.error = null;
    }

    public Call getParent() {
        return this.parent;
    }

    public OperationType getChain() {
        return this.chain;
    }

    public OperationException getError() {
        return this.error;
    }

    public Object getOutput() {
        return this.output;
    }

    public List<Call> getCalls() {
        return this.operations;
    }

    public String getFormattedText() {
        TracerFactory tracerFactory = (TracerFactory)Framework.getLocalService(TracerFactory.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            if (tracerFactory.getRecordingState()) {
                new TracePrinter(out).print(this);
            } else {
                new TracePrinter(out).litePrint(this);
            }
        }
        catch (IOException e) {
            LogFactory.getLog(Trace.class).error((Object)("Cannot print trace of " + this.chain.getId()), (Throwable)e);
            return this.chain.getId();
        }
        return out.toString();
    }
}

