/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.invite;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.naming.InitialContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.rendering.api.RenderingException;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.user.invite.AlreadyProcessedRegistrationException;
import org.nuxeo.ecm.user.invite.DefaultInvitationUserFactory;
import org.nuxeo.ecm.user.invite.InvitationUserFactory;
import org.nuxeo.ecm.user.invite.RegistrationRules;
import org.nuxeo.ecm.user.invite.RenderingHelper;
import org.nuxeo.ecm.user.invite.UserInvitationService;
import org.nuxeo.ecm.user.invite.UserRegistrationConfiguration;
import org.nuxeo.ecm.user.invite.UserRegistrationException;
import org.nuxeo.ecm.user.invite.UserRegistrationInfo;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class UserInvitationComponent
extends DefaultComponent
implements UserInvitationService {
    protected static Log log = LogFactory.getLog(UserInvitationService.class);
    public static final String NUXEO_URL_KEY = "nuxeo.url";
    protected String repoName = null;
    protected String testRendering = null;
    protected RenderingHelper rh = new RenderingHelper();
    protected Map<String, UserRegistrationConfiguration> configurations = new HashMap<String, UserRegistrationConfiguration>();
    private static final String INVITATION_SUBMITTED_EVENT = "invitationSubmitted";
    private static final String INVITATION_ACCEPTED_EVENT = "invitationAccepted";
    private static final String INVITATION_REJECTED_EVENT = "invitationRejected";
    private static final String INVITATION_VALIDATED_EVENT = "invitationValidated";

    public String getTestedRendering() {
        return this.testRendering;
    }

    protected String getTargetRepositoryName() {
        if (this.repoName == null) {
            try {
                RepositoryManager rm = (RepositoryManager)Framework.getService(RepositoryManager.class);
                this.repoName = rm.getDefaultRepositoryName();
            }
            catch (Exception e) {
                log.error((Object)"Error while getting default repository name", (Throwable)e);
                this.repoName = "default";
            }
        }
        return this.repoName;
    }

    protected boolean userAlreadyExists(UserRegistrationInfo userRegistrationInfo) {
        try {
            DocumentModel user = ((UserManager)Framework.getLocalService(UserManager.class)).getUserModel(userRegistrationInfo.getLogin());
            return user != null;
        }
        catch (ClientException e) {
            log.debug((Object)e, (Throwable)e);
            return false;
        }
    }

    protected String getJavaMailJndiName() {
        return Framework.getProperty((String)"jndi.java.mail", (String)"java:/Mail");
    }

    @Override
    public DocumentModel getUserRegistrationModel(String configurationName) throws ClientException {
        if (StringUtils.isEmpty((String)configurationName)) {
            configurationName = "default_registration";
        }
        UserRegistrationModelCreator creator = new UserRegistrationModelCreator(configurationName);
        creator.runUnrestricted();
        return creator.getUserRegistrationModel();
    }

    @Override
    public DocumentModel getRegistrationRulesDocument(CoreSession session, String configurationName) throws ClientException {
        return this.getOrCreateRootDocument(session, configurationName);
    }

    public DocumentModel getOrCreateRootDocument(CoreSession session, String configurationName) throws ClientException {
        DocumentModel root;
        UserRegistrationConfiguration configuration = this.getConfiguration(configurationName);
        String targetPath = configuration.getContainerParentPath() + configuration.getContainerName();
        PathRef targetRef = new PathRef(targetPath);
        if (!session.exists((DocumentRef)targetRef)) {
            root = session.createDocumentModel(configuration.getContainerDocType());
            root.setPathInfo(configuration.getContainerParentPath(), configuration.getContainerName());
            root.setPropertyValue("dc:title", (Serializable)((Object)configuration.getContainerTitle()));
            root = session.createDocument(root);
        } else {
            root = session.getDocument((DocumentRef)targetRef);
        }
        if (!root.hasFacet("RegistrationConfiguration")) {
            root.addFacet("RegistrationConfiguration");
            root.setPropertyValue("registrationconfiguration:name", (Serializable)((Object)configuration.getName()));
            root = session.saveDocument(root);
        }
        return root;
    }

    protected EventContext sendEvent(CoreSession session, DocumentModel source, String evName) throws UserRegistrationException {
        try {
            EventService evService = (EventService)Framework.getService(EventService.class);
            DocumentEventContext evContext = new DocumentEventContext(session, session.getPrincipal(), source);
            Event event = evContext.newEvent(evName);
            evService.fireEvent(event);
            return evContext;
        }
        catch (UserRegistrationException ue) {
            log.warn((Object)"Error during event processing", (Throwable)((Object)ue));
            throw ue;
        }
        catch (Exception e) {
            log.error((Object)"Error while sending event", (Throwable)e);
            return null;
        }
    }

    protected void sendValidationEmail(Map<String, Serializable> additionnalInfo, DocumentModel registrationDoc) throws ClientException {
        String emailAdress = (String)((Object)registrationDoc.getPropertyValue("userinfo:email"));
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("registrationDoc", registrationDoc);
        input.put("info", (Serializable)((Object)additionnalInfo));
        input.put("userAlreadyExists", this.checkUserFromRegistrationExistence(registrationDoc));
        StringWriter writer = new StringWriter();
        UserRegistrationConfiguration configuration = this.getConfiguration(registrationDoc);
        try {
            this.rh.getRenderingEngine().render(configuration.getValidationEmailTemplate(), input, (Writer)writer);
        }
        catch (Exception e) {
            throw new ClientException("Error during rendering email", (Throwable)e);
        }
        String body = writer.getBuffer().toString();
        String title = configuration.getValidationEmailTitle();
        String copyTo = (String)((Object)registrationDoc.getPropertyValue("registration:copyTo"));
        if (!UserInvitationComponent.isTestModeSet()) {
            try {
                this.generateMail(emailAdress, copyTo, title, body);
            }
            catch (Exception e) {
                throw new ClientException("Error while sending mail : ", (Throwable)e);
            }
        } else {
            this.testRendering = body;
        }
    }

    protected static boolean isTestModeSet() {
        return Framework.isTestModeSet() || !StringUtils.isBlank((String)Framework.getProperty((String)"org.nuxeo.ecm.tester.name"));
    }

    protected boolean checkUserFromRegistrationExistence(DocumentModel registrationDoc) throws ClientException {
        return null != ((UserManager)Framework.getLocalService(UserManager.class)).getPrincipal((String)((Object)registrationDoc.getPropertyValue("userinfo:login")));
    }

    protected void generateMail(String destination, String copy, String title, String content) throws Exception {
        InitialContext ic = new InitialContext();
        Session session = (Session)ic.lookup(this.getJavaMailJndiName());
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(session.getProperty("mail.from")));
        msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)destination, (boolean)false));
        if (!StringUtils.isBlank((String)copy)) {
            msg.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(copy, false));
        }
        msg.setSubject(title, "UTF-8");
        msg.setSentDate(new Date());
        msg.setContent((Object)content, "text/html; charset=utf-8");
        Transport.send((Message)msg);
    }

    @Override
    public String submitRegistrationRequest(DocumentModel userRegistrationModel, Map<String, Serializable> additionnalInfo, UserInvitationService.ValidationMethod validationMethod, boolean autoAccept) throws ClientException {
        return this.submitRegistrationRequest("default_registration", userRegistrationModel, additionnalInfo, validationMethod, autoAccept);
    }

    @Override
    public String submitRegistrationRequest(String configurationName, DocumentModel userRegistrationModel, Map<String, Serializable> additionnalInfo, UserInvitationService.ValidationMethod validationMethod, boolean autoAccept) throws ClientException, UserRegistrationException {
        RegistrationCreator creator = new RegistrationCreator(configurationName, userRegistrationModel, additionnalInfo, validationMethod);
        creator.runUnrestricted();
        String registrationUuid = creator.getRegistrationUuid();
        boolean userAlreadyExists = null != ((UserManager)Framework.getLocalService(UserManager.class)).getPrincipal((String)((Object)userRegistrationModel.getPropertyValue("userinfo:login")));
        RegistrationRules registrationRules = this.getRegistrationRules(configurationName);
        boolean byPassAdminValidation = autoAccept;
        byPassAdminValidation |= userAlreadyExists && registrationRules.allowDirectValidationForExistingUser();
        if (byPassAdminValidation |= registrationRules.allowDirectValidationForExistingUser() && registrationRules.allowDirectValidationForNonExistingUser()) {
            if (!additionnalInfo.containsKey("enterPasswordUrl")) {
                String enterPasswordUrl;
                String baseUrl = Framework.getProperty((String)NUXEO_URL_KEY);
                String string = baseUrl = StringUtils.isBlank((String)baseUrl) ? "/" : baseUrl;
                if (!baseUrl.endsWith("/")) {
                    baseUrl = baseUrl + "/";
                }
                if ((enterPasswordUrl = this.getConfiguration(configurationName).getEnterPasswordUrl()).startsWith("/")) {
                    enterPasswordUrl = enterPasswordUrl.substring(1);
                }
                additionnalInfo.put("enterPasswordUrl", (Serializable)((Object)baseUrl.concat(enterPasswordUrl)));
            }
            this.acceptRegistrationRequest(registrationUuid, additionnalInfo);
        }
        return registrationUuid;
    }

    @Override
    public void acceptRegistrationRequest(String requestId, Map<String, Serializable> additionnalInfo) throws ClientException, UserRegistrationException {
        RegistrationAcceptor acceptor = new RegistrationAcceptor(requestId, additionnalInfo);
        acceptor.runUnrestricted();
    }

    @Override
    public void rejectRegistrationRequest(String requestId, Map<String, Serializable> additionnalInfo) throws ClientException, UserRegistrationException {
        RegistrationRejector rejector = new RegistrationRejector(requestId, additionnalInfo);
        rejector.runUnrestricted();
    }

    @Override
    public Map<String, Serializable> validateRegistration(String requestId, Map<String, Serializable> additionnalInfo) throws ClientException, UserRegistrationException {
        RegistrationValidator validator = new RegistrationValidator(requestId, additionnalInfo);
        validator.runUnrestricted();
        return validator.getRegistrationData();
    }

    @Override
    public Map<String, Serializable> validateRegistrationAndSendEmail(String requestId, Map<String, Serializable> additionnalInfo) throws ClientException, UserRegistrationException {
        Map<String, Serializable> registrationInfo = this.validateRegistration(requestId, additionnalInfo);
        HashMap<String, Serializable> input = new HashMap<String, Serializable>();
        input.putAll(registrationInfo);
        input.put("info", (Serializable)((Object)additionnalInfo));
        StringWriter writer = new StringWriter();
        UserRegistrationConfiguration configuration = this.getConfiguration((DocumentModel)registrationInfo.get("registrationDoc"));
        try {
            this.rh.getRenderingEngine().render(configuration.getSuccessEmailTemplate(), input, (Writer)writer);
        }
        catch (Exception e) {
            throw new ClientException("Error during rendering email", (Throwable)e);
        }
        String emailAdress = ((NuxeoPrincipalImpl)registrationInfo.get("registeredUser")).getEmail();
        String body = writer.getBuffer().toString();
        String title = configuration.getValidationEmailTitle();
        if (!Framework.isTestModeSet()) {
            try {
                this.generateMail(emailAdress, null, title, body);
            }
            catch (Exception e) {
                throw new ClientException("Error while sending mail : ", (Throwable)e);
            }
        } else {
            this.testRendering = body;
        }
        return registrationInfo;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if ("configuration".equals(extensionPoint)) {
            UserRegistrationConfiguration newConfig = (UserRegistrationConfiguration)contribution;
            if (this.configurations.containsKey(newConfig.getName())) {
                if (newConfig.isMerge()) {
                    this.configurations.get(newConfig.getName()).mergeWith(newConfig);
                } else if (newConfig.isRemove()) {
                    this.configurations.remove(newConfig.getName());
                } else {
                    log.warn((Object)("Trying to register an existing userRegistration configuration without removing or merging it, in: " + contributor.getName()));
                }
            } else {
                this.configurations.put(newConfig.getName(), newConfig);
            }
        }
    }

    protected InvitationUserFactory getRegistrationUserFactory(UserRegistrationConfiguration configuration) {
        InvitationUserFactory factory = null;
        Class<? extends InvitationUserFactory> factoryClass = configuration.getRegistrationUserFactory();
        if (factoryClass != null) {
            try {
                factory = factoryClass.newInstance();
            }
            catch (InstantiationException e) {
                log.warn((Object)"Failed to instanciate RegistrationUserFactory", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.warn((Object)"Failed to instanciate RegistrationUserFactory", (Throwable)e);
            }
        }
        if (factory == null) {
            factory = new DefaultInvitationUserFactory();
        }
        return factory;
    }

    @Override
    public NuxeoPrincipal createUser(CoreSession session, DocumentModel registrationDoc) throws ClientException, UserRegistrationException {
        UserRegistrationConfiguration configuration = this.getConfiguration(registrationDoc);
        return this.getRegistrationUserFactory(configuration).doCreateUser(session, registrationDoc);
    }

    @Override
    public UserRegistrationConfiguration getConfiguration() {
        return this.getConfiguration("default_registration");
    }

    @Override
    public UserRegistrationConfiguration getConfiguration(DocumentModel requestDoc) {
        try {
            DocumentModel parent = requestDoc.getCoreSession().getDocument(requestDoc.getParentRef());
            String configurationName = "default_registration";
            if (parent.hasFacet("RegistrationConfiguration")) {
                configurationName = (String)((Object)parent.getPropertyValue("registrationconfiguration:name"));
            }
            if (!this.configurations.containsKey(configurationName)) {
                throw new ClientException("Configuration " + configurationName + " is not registered");
            }
            return this.configurations.get(configurationName);
        }
        catch (ClientException e) {
            log.info((Object)("Unable to get request parent document: " + e.getMessage()));
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public UserRegistrationConfiguration getConfiguration(String name) {
        if (!this.configurations.containsKey(name)) {
            throw new ClientRuntimeException("Trying to get unknown user registration configuration.");
        }
        return this.configurations.get(name);
    }

    @Override
    public RegistrationRules getRegistrationRules(String configurationName) throws ClientException {
        RootDocumentGetter rdg = new RootDocumentGetter(configurationName);
        rdg.runUnrestricted();
        return (RegistrationRules)rdg.getDoc().getAdapter(RegistrationRules.class);
    }

    @Override
    public void reviveRegistrationRequests(CoreSession session, List<DocumentModel> registrationDocs) throws ClientException {
        for (DocumentModel registrationDoc : registrationDocs) {
            this.reviveRegistrationRequest(session, registrationDoc, new HashMap<String, Object>());
        }
    }

    protected void reviveRegistrationRequest(CoreSession session, DocumentModel registrationDoc, Map<String, Object> additionalInfos) throws ClientException {
        StringWriter writer = new StringWriter();
        HashMap<String, Object> input = new HashMap<String, Object>();
        String baseUrl = Framework.getProperty((String)NUXEO_URL_KEY);
        String string = baseUrl = StringUtils.isBlank((String)baseUrl) ? "/" : baseUrl;
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        additionalInfos.put("validationBaseURL", baseUrl + this.getConfiguration(registrationDoc).getValidationRelUrl());
        input.put("info", additionalInfos);
        input.put("userAlreadyExists", this.checkUserFromRegistrationExistence(registrationDoc));
        input.put("registrationDoc", registrationDoc);
        UserRegistrationConfiguration configuration = this.getConfiguration(registrationDoc);
        try {
            this.rh.getRenderingEngine().render(configuration.getReviveEmailTemplate(), input, (Writer)writer);
        }
        catch (RenderingException e) {
            throw new ClientException("Error during templating email : ", (Throwable)e);
        }
        String emailAdress = (String)((Object)registrationDoc.getPropertyValue("userinfo:email"));
        String body = writer.getBuffer().toString();
        String title = configuration.getReviveEmailTitle();
        if (!Framework.isTestModeSet()) {
            try {
                this.generateMail(emailAdress, null, title, body);
            }
            catch (Exception e) {
                throw new ClientException("Error while sending mail : ", (Throwable)e);
            }
        } else {
            this.testRendering = body;
        }
    }

    @Override
    public void deleteRegistrationRequests(CoreSession session, List<DocumentModel> registrationDocs) throws ClientException {
        for (DocumentModel registration : registrationDocs) {
            if (!registration.hasSchema("userinfo")) {
                throw new ClientException("Registration document do not contains needed schema");
            }
            String userName = (String)((Object)registration.getPropertyValue("userinfo:login"));
            session.removeDocument(registration.getRef());
        }
    }

    @Override
    public Set<String> getConfigurationsName() {
        return this.configurations.keySet();
    }

    @Override
    public DocumentModelList getRegistrationsForUser(final String docId, final String username) throws ClientException {
        DocumentModelListImpl registrationDocs = new DocumentModelListImpl();
        new UnrestrictedSessionRunner(this.getTargetRepositoryName(), (DocumentModelList)registrationDocs){
            final /* synthetic */ DocumentModelList val$registrationDocs;
            {
                this.val$registrationDocs = documentModelList;
                super(x0);
            }

            public void run() throws ClientException {
                String query = "SELECT * FROM Document WHERE ecm:currentLifeCycleState != 'validated' AND ecm:mixinType = 'UserRegistration' AND docinfo:documentId = '%s' AND userinfo:login = '%s' AND ecm:isCheckedInVersion = 0";
                query = String.format(query, docId, username);
                this.val$registrationDocs.addAll((Collection)this.session.query(query));
            }
        }.runUnrestricted();
        return registrationDocs;
    }

    @Override
    public void checkRequestId(String requestId) throws ClientException, UserRegistrationException {
        RequestIdValidator runner = new RequestIdValidator(requestId);
        runner.runUnrestricted();
    }

    @Override
    public String getNameEventRegistrationSubmitted() {
        return INVITATION_SUBMITTED_EVENT;
    }

    @Override
    public String getNameEventRegistrationAccepted() {
        return INVITATION_ACCEPTED_EVENT;
    }

    @Override
    public String getNameEventRegistrationRejected() {
        return INVITATION_REJECTED_EVENT;
    }

    @Override
    public String getNameEventRegistrationValidated() {
        return INVITATION_VALIDATED_EVENT;
    }

    protected class RootDocumentGetter
    extends UnrestrictedSessionRunner {
        protected DocumentModel doc;
        protected String configurationName;

        protected RootDocumentGetter(String configurationName) {
            super(UserInvitationComponent.this.getTargetRepositoryName());
            this.configurationName = configurationName;
        }

        public void run() throws ClientException {
            this.doc = UserInvitationComponent.this.getOrCreateRootDocument(this.session, this.configurationName);
            ((DocumentModelImpl)this.doc).detach(true);
        }

        public DocumentModel getDoc() {
            return this.doc;
        }
    }

    protected class RequestIdValidator
    extends UnrestrictedSessionRunner {
        protected String uuid;

        public RequestIdValidator(String uuid) {
            super(UserInvitationComponent.this.getTargetRepositoryName());
            this.uuid = uuid;
        }

        public void run() throws ClientException {
            IdRef idRef = new IdRef(this.uuid);
            if (!this.session.exists((DocumentRef)idRef)) {
                throw new UserRegistrationException("There is no existing registration request with id " + this.uuid);
            }
            DocumentModel registrationDoc = this.session.getDocument((DocumentRef)idRef);
            if (registrationDoc.getCurrentLifeCycleState().equals("validated")) {
                throw new AlreadyProcessedRegistrationException("Registration request has already been processed.");
            }
        }
    }

    protected class RegistrationValidator
    extends UnrestrictedSessionRunner {
        protected String uuid;
        protected Map<String, Serializable> registrationData;
        protected Map<String, Serializable> additionnalInfo;

        public RegistrationValidator(String uuid, Map<String, Serializable> additionnalInfo) {
            super(UserInvitationComponent.this.getTargetRepositoryName());
            this.registrationData = new HashMap<String, Serializable>();
            this.uuid = uuid;
            this.additionnalInfo = additionnalInfo;
        }

        public Map<String, Serializable> getRegistrationData() {
            return this.registrationData;
        }

        public void run() throws ClientException {
            IdRef idRef = new IdRef(this.uuid);
            DocumentModel registrationDoc = this.session.getDocument((DocumentRef)idRef);
            for (String key : this.additionnalInfo.keySet()) {
                try {
                    registrationDoc.setPropertyValue(key, this.additionnalInfo.get(key));
                }
                catch (PropertyException e) {}
            }
            if (registrationDoc.getLifeCyclePolicy().equals("registrationRequest")) {
                if (registrationDoc.getCurrentLifeCycleState().equals("accepted")) {
                    registrationDoc.followTransition("validate");
                } else {
                    if (registrationDoc.getCurrentLifeCycleState().equals("validated")) {
                        throw new AlreadyProcessedRegistrationException("Registration request has already been processed.");
                    }
                    throw new UserRegistrationException("Registration request has not been accepted yet.");
                }
            }
            this.session.saveDocument(registrationDoc);
            this.session.save();
            EventContext evContext = UserInvitationComponent.this.sendEvent(this.session, registrationDoc, UserInvitationComponent.this.getNameEventRegistrationValidated());
            ((DocumentModelImpl)registrationDoc).detach(this.sessionIsAlreadyUnrestricted);
            this.registrationData.put("registrationDoc", (Serializable)registrationDoc);
            this.registrationData.put("registeredUser", evContext.getProperty("registeredUser"));
        }
    }

    protected class RegistrationRejector
    extends UnrestrictedSessionRunner {
        protected String uuid;
        protected Map<String, Serializable> additionnalInfo;

        public RegistrationRejector(String registrationUuid, Map<String, Serializable> additionnalInfo) {
            super(UserInvitationComponent.this.getTargetRepositoryName());
            this.uuid = registrationUuid;
            this.additionnalInfo = additionnalInfo;
        }

        public void run() throws ClientException {
            DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(this.uuid));
            doc.setPropertyValue("registration:accepted", (Serializable)Boolean.valueOf(false));
            if (doc.getAllowedStateTransitions().contains("reject")) {
                doc.followTransition("reject");
            }
            doc = this.session.saveDocument(doc);
            this.session.save();
            UserInvitationComponent.this.sendEvent(this.session, doc, UserInvitationComponent.this.getNameEventRegistrationRejected());
        }
    }

    protected class RegistrationAcceptor
    extends UnrestrictedSessionRunner {
        protected String uuid;
        protected Map<String, Serializable> additionnalInfo;

        public RegistrationAcceptor(String registrationUuid, Map<String, Serializable> additionnalInfo) {
            super(UserInvitationComponent.this.getTargetRepositoryName());
            this.uuid = registrationUuid;
            this.additionnalInfo = additionnalInfo;
        }

        public void run() throws ClientException {
            DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(this.uuid));
            String validationMethod = (String)((Object)doc.getPropertyValue("registration:validationMethod"));
            if (StringUtils.equals((String)UserInvitationService.ValidationMethod.EMAIL.toString(), (String)validationMethod)) {
                UserInvitationComponent.this.sendValidationEmail(this.additionnalInfo, doc);
            }
            doc.setPropertyValue("registration:accepted", (Serializable)Boolean.valueOf(true));
            if (doc.getAllowedStateTransitions().contains("accept")) {
                doc.followTransition("accept");
            }
            doc = this.session.saveDocument(doc);
            this.session.save();
            UserInvitationComponent.this.sendEvent(this.session, doc, UserInvitationComponent.this.getNameEventRegistrationAccepted());
        }
    }

    protected class RegistrationCreator
    extends UnrestrictedSessionRunner {
        protected Map<String, Serializable> additionnalInfo;
        protected String registrationUuid;
        protected UserInvitationService.ValidationMethod validationMethod;
        protected DocumentModel userRegistrationModel;
        protected UserRegistrationConfiguration configuration;

        public String getRegistrationUuid() {
            return this.registrationUuid;
        }

        public RegistrationCreator(String configurationName, DocumentModel userRegistrationModel, Map<String, Serializable> additionnalInfo, UserInvitationService.ValidationMethod validationMethod) {
            super(UserInvitationComponent.this.getTargetRepositoryName());
            this.userRegistrationModel = userRegistrationModel;
            this.additionnalInfo = additionnalInfo;
            this.validationMethod = validationMethod;
            this.configuration = UserInvitationComponent.this.getConfiguration(configurationName);
        }

        public void run() throws ClientException {
            String title = "registration request for " + this.userRegistrationModel.getPropertyValue("userinfo:login") + " (" + this.userRegistrationModel.getPropertyValue("userinfo:email") + " " + this.userRegistrationModel.getPropertyValue("userinfo:company") + ") ";
            String name = IdUtils.generateId((String)(title + "-" + System.currentTimeMillis()));
            String targetPath = UserInvitationComponent.this.getOrCreateRootDocument(this.session, this.configuration.getName()).getPathAsString();
            this.userRegistrationModel.setPathInfo(targetPath, name);
            this.userRegistrationModel.setPropertyValue("dc:title", (Serializable)((Object)title));
            this.userRegistrationModel.setPropertyValue("registration:validationMethod", (Serializable)((Object)this.validationMethod.toString()));
            if (this.additionnalInfo != null && !this.additionnalInfo.isEmpty()) {
                for (String key : this.additionnalInfo.keySet()) {
                    try {
                        this.userRegistrationModel.setPropertyValue(key, this.additionnalInfo.get(key));
                    }
                    catch (PropertyException e) {}
                }
            }
            this.userRegistrationModel = this.session.createDocument(this.userRegistrationModel);
            this.registrationUuid = this.userRegistrationModel.getId();
            UserInvitationComponent.this.sendEvent(this.session, this.userRegistrationModel, UserInvitationComponent.this.getNameEventRegistrationSubmitted());
            this.session.save();
        }
    }

    protected class UserRegistrationModelCreator
    extends UnrestrictedSessionRunner {
        DocumentModel userRegistrationModel;
        protected UserRegistrationConfiguration configuration;

        public UserRegistrationModelCreator(String configurationName) {
            super(UserInvitationComponent.this.getTargetRepositoryName());
            this.configuration = UserInvitationComponent.this.getConfiguration(configurationName);
        }

        public void run() throws ClientException {
            this.userRegistrationModel = this.session.createDocumentModel(this.configuration.getRequestDocType());
        }

        public DocumentModel getUserRegistrationModel() {
            return this.userRegistrationModel;
        }
    }
}

