/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.invite;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.user.invite.RegistrationRules;
import org.nuxeo.ecm.user.invite.UserInvitationService;
import org.nuxeo.ecm.user.invite.UserRegistrationConfiguration;
import org.nuxeo.runtime.api.Framework;

public class UserInvitationListener
implements EventListener {
    protected static Log log = LogFactory.getLog(UserInvitationListener.class);

    public void handleEvent(Event event) throws ClientException {
        try {
            DocumentEventContext docCtx;
            DocumentModel registration;
            UserRegistrationConfiguration config;
            RegistrationRules rules;
            UserInvitationService userRegistrationService = (UserInvitationService)Framework.getService(UserInvitationService.class);
            if (!event.getName().equals(userRegistrationService.getNameEventRegistrationValidated())) {
                return;
            }
            EventContext ctx = event.getContext();
            if (ctx instanceof DocumentEventContext && (rules = userRegistrationService.getRegistrationRules((config = userRegistrationService.getConfiguration(registration = (docCtx = (DocumentEventContext)ctx).getSourceDocument())).getName())).allowUserCreation()) {
                NuxeoPrincipal principal = userRegistrationService.createUser(ctx.getCoreSession(), registration);
                docCtx.setProperty("registeredUser", (Serializable)principal);
            }
        }
        catch (Exception e) {
            event.markRollBack();
            throw new ClientException("Unable to complete registration", (Throwable)e);
        }
    }
}

