/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.conversation;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.conversation.ConversationListener;
import org.apache.myfaces.custom.conversation.ConversationManager;
import org.apache.myfaces.custom.conversation.PersistenceManager;

public class Conversation {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$custom$conversation$Conversation == null ? (class$org$apache$myfaces$custom$conversation$Conversation = Conversation.class$("org.apache.myfaces.custom.conversation.Conversation")) : class$org$apache$myfaces$custom$conversation$Conversation));
    private final String name;
    private final boolean persistence;
    private PersistenceManager persistenceManager;
    private final Map beans = new TreeMap();
    static /* synthetic */ Class class$org$apache$myfaces$custom$conversation$Conversation;

    protected Conversation(String name, boolean persistence) {
        this.name = name;
        this.persistence = persistence;
        if (log.isDebugEnabled()) {
            log.debug((Object)("start conversation:" + name + "(persistence=" + persistence + ")"));
        }
    }

    public void putBean(FacesContext context, String name, Object value) {
        if (name.indexOf(46) > -1) {
            throw new IllegalArgumentException("you cant put a property under conversation control. name: " + name);
        }
        if (this.beans.containsKey(name)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("put bean to conversation:" + name + "(bean=" + name + ")"));
        }
        this.beans.put(name, value);
    }

    public String getName() {
        return this.name;
    }

    public void endConversation(boolean regularEnd) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("end conversation:" + this.name));
        }
        Iterator iterBeans = this.beans.values().iterator();
        while (iterBeans.hasNext()) {
            Object bean = iterBeans.next();
            if (!(bean instanceof ConversationListener)) continue;
            ((ConversationListener)bean).conversationEnded();
        }
        this.beans.clear();
        if (this.isPersistence()) {
            if (regularEnd) {
                this.getPersistenceManager().commit();
            } else {
                this.getPersistenceManager().rollback();
            }
            this.getPersistenceManager().purge();
        }
    }

    public boolean hasBean(String name) {
        return this.beans.containsKey(name);
    }

    public Object getBean(String name) {
        return this.beans.get(name);
    }

    public Object removeBean(String name) {
        return this.beans.remove(name);
    }

    public boolean isPersistence() {
        return this.persistence || this.persistenceManager != null;
    }

    public PersistenceManager getPersistenceManager() {
        if (this.persistenceManager == null) {
            this.persistenceManager = ConversationManager.getInstance().createPersistenceManager();
        }
        return this.persistenceManager;
    }

    public boolean hasBean(Object instance) {
        return this.beans.containsValue(instance);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

