/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.conversation;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.conversation.Conversation;
import org.apache.myfaces.custom.conversation.ConversationBeanElevator;
import org.apache.myfaces.custom.conversation.ConversationContext;
import org.apache.myfaces.custom.conversation.ConversationExternalContext;
import org.apache.myfaces.custom.conversation.ConversationMessager;
import org.apache.myfaces.custom.conversation.ConversationRequestParameterProvider;
import org.apache.myfaces.custom.conversation.ConversationServletFilter;
import org.apache.myfaces.custom.conversation.DefaultConversationBeanElevator;
import org.apache.myfaces.custom.conversation.DefaultConversationMessager;
import org.apache.myfaces.custom.conversation.PersistenceManager;
import org.apache.myfaces.custom.conversation.PersistenceManagerFactory;
import org.apache.myfaces.custom.requestParameterProvider.RequestParameterProviderManager;
import org.apache.myfaces.shared_tomahawk.util.ClassUtils;

public class ConversationManager
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$custom$conversation$ConversationManager == null ? (class$org$apache$myfaces$custom$conversation$ConversationManager = ConversationManager.class$("org.apache.myfaces.custom.conversation.ConversationManager")) : class$org$apache$myfaces$custom$conversation$ConversationManager));
    public static final String CONVERSATION_CONTEXT_PARAM = "conversationContext";
    private static final String INIT_PERSISTENCE_MANAGER_FACOTRY = "org.apache.myfaces.conversation.PERSISTENCE_MANAGER_FACTORY";
    private static final String INIT_MESSAGER = "org.apache.myfaces.conversation.MESSAGER";
    private static final String INIT_BEAN_ELEVATOR = "org.apache.myfaces.conversation.BEAN_ELEVATOR";
    private static final String CONVERSATION_MANAGER_KEY = "org.apache.myfaces.ConversationManager";
    private static final String CONVERSATION_CONTEXT_REQ = "org.apache.myfaces.ConversationManager.conversationContext";
    private static long NEXT_CONVERSATION_CONTEXT = 1L;
    private PersistenceManagerFactory persistenceManagerFactory;
    private ConversationMessager conversationMessager;
    private ConversationBeanElevator conversationBeanElevator;
    private final Map conversationContexts = new HashMap();
    private ContextWiperThread wiperThread = new ContextWiperThread();
    static /* synthetic */ Class class$org$apache$myfaces$custom$conversation$ConversationManager;

    protected ConversationManager() {
        this.wiperThread.start();
    }

    public static ConversationManager getInstance() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null) {
            ConversationManager cm = ConversationServletFilter.getConversationManager();
            if (cm != null) {
                return cm;
            }
            throw new IllegalStateException("no faces context available");
        }
        return ConversationManager.getInstance(context);
    }

    public static ConversationManager getInstance(FacesContext context) {
        ConversationManager conversationManager = (ConversationManager)context.getExternalContext().getSessionMap().get(CONVERSATION_MANAGER_KEY);
        if (conversationManager == null) {
            if (!Boolean.TRUE.equals(context.getExternalContext().getRequestMap().get("org.apache.myfaces.conversation.ConversationServletFilter.CALLED"))) {
                throw new IllegalStateException("ConversationServletFilter not called. Please configure the filter org.apache.myfaces.custom.conversation.ConversationServletFilter in your web.xml to cover your faces requests.");
            }
            conversationManager = ConversationManager.createConversationManager();
            RequestParameterProviderManager.getInstance(context).register(new ConversationRequestParameterProvider());
            context.getExternalContext().getSessionMap().put(CONVERSATION_MANAGER_KEY, conversationManager);
        }
        return conversationManager;
    }

    protected static ConversationManager createConversationManager() {
        ConversationManager conversationManager = new ConversationManager();
        conversationManager.createMessager();
        conversationManager.createBeanElevator();
        return conversationManager;
    }

    public static ConversationManager getInstance(HttpSession session) {
        if (session == null) {
            return null;
        }
        return (ConversationManager)session.getAttribute(CONVERSATION_MANAGER_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long getConversationContextId() {
        Map requestParameterMap;
        Map requestMap;
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            requestMap = context.getExternalContext().getRequestMap();
            requestParameterMap = context.getExternalContext().getRequestParameterMap();
        } else {
            ConversationExternalContext ccontext = ConversationServletFilter.getConversationExternalContext();
            if (ccontext != null) {
                requestMap = ccontext.getRequestMap();
                requestParameterMap = ccontext.getRequestParameterMap();
            } else {
                throw new IllegalStateException("cant find a requestMap or requestParameterMap");
            }
        }
        Long conversationContextId = (Long)requestMap.get(CONVERSATION_CONTEXT_REQ);
        if (conversationContextId == null) {
            if (requestParameterMap.containsKey(CONVERSATION_CONTEXT_PARAM)) {
                String urlConversationContextId = requestParameterMap.get(CONVERSATION_CONTEXT_PARAM).toString();
                conversationContextId = new Long(Long.parseLong(urlConversationContextId, 36));
            } else {
                Class clazz = class$org$apache$myfaces$custom$conversation$ConversationManager == null ? (class$org$apache$myfaces$custom$conversation$ConversationManager = ConversationManager.class$("org.apache.myfaces.custom.conversation.ConversationManager")) : class$org$apache$myfaces$custom$conversation$ConversationManager;
                synchronized (clazz) {
                    conversationContextId = new Long(NEXT_CONVERSATION_CONTEXT);
                    ++NEXT_CONVERSATION_CONTEXT;
                }
            }
            requestMap.put(CONVERSATION_CONTEXT_REQ, conversationContextId);
        }
        return conversationContextId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConversationContext getConversationContext(Long conversationContextId) {
        Map map = this.conversationContexts;
        synchronized (map) {
            return (ConversationContext)this.conversationContexts.get(conversationContextId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConversationContext getOrCreateConversationContext(Long conversationContextId) {
        Map map = this.conversationContexts;
        synchronized (map) {
            ConversationContext conversationContext = (ConversationContext)this.conversationContexts.get(conversationContextId);
            if (conversationContext == null) {
                conversationContext = new ConversationContext(conversationContextId);
                this.conversationContexts.put(conversationContextId, conversationContext);
            }
            return conversationContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyConversationContext(Long conversationContextId) {
        Map map = this.conversationContexts;
        synchronized (map) {
            this.conversationContexts.remove(conversationContextId);
        }
    }

    public void startConversation(String name, boolean persistence) {
        Long conversationContextId = this.getConversationContextId();
        ConversationContext conversationContext = this.getOrCreateConversationContext(conversationContextId);
        conversationContext.startConversation(name, persistence);
    }

    public void endConversation(String name, boolean regularEnd) {
        Long conversationContextId = this.getConversationContextId();
        ConversationContext conversationContext = this.getConversationContext(conversationContextId);
        if (conversationContext != null) {
            conversationContext.endConversation(name, regularEnd);
            if (!conversationContext.hasConversations()) {
                this.destroyConversationContext(conversationContextId);
            }
        }
    }

    public Conversation getConversation(String name) {
        ConversationContext conversationContext = this.getConversationContext();
        if (conversationContext == null) {
            return null;
        }
        return conversationContext.getConversation(name);
    }

    public Conversation findConversation(Object instance) {
        ConversationContext conversationContext = this.getConversationContext();
        if (conversationContext == null) {
            return null;
        }
        return conversationContext.findConversation(instance);
    }

    public boolean hasConversation(String name) {
        ConversationContext conversationContext = this.getConversationContext();
        if (conversationContext == null) {
            return false;
        }
        return conversationContext.hasConversation(name);
    }

    protected ConversationContext getConversationContext() {
        Long conversationContextId = this.getConversationContextId();
        ConversationContext conversationContext = this.getConversationContext(conversationContextId);
        return conversationContext;
    }

    public boolean hasConversationContext() {
        FacesContext context = FacesContext.getCurrentInstance();
        return (context.getExternalContext().getRequestMap().containsKey(CONVERSATION_CONTEXT_REQ) || context.getExternalContext().getRequestParameterMap().containsKey(CONVERSATION_CONTEXT_PARAM)) && this.getConversationContext() != null;
    }

    public PersistenceManager getPersistenceManager() {
        ConversationContext conversationContext = this.getConversationContext();
        if (conversationContext == null) {
            return null;
        }
        return conversationContext.getPersistenceManager();
    }

    protected PersistenceManager createPersistenceManager() {
        return this.getPersistenceManagerFactory().create();
    }

    protected ConversationMessager getMessager() {
        return this.conversationMessager;
    }

    protected void createMessager() {
        String conversationMessagerName = FacesContext.getCurrentInstance().getExternalContext().getInitParameter(INIT_MESSAGER);
        if (conversationMessagerName == null) {
            this.conversationMessager = new DefaultConversationMessager();
        } else {
            try {
                this.conversationMessager = (ConversationMessager)ClassUtils.classForName((String)conversationMessagerName).newInstance();
            }
            catch (InstantiationException e) {
                throw new FacesException("error creating messager: " + conversationMessagerName, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new FacesException("error creating messager: " + conversationMessagerName, (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new FacesException("error creating messager: " + conversationMessagerName, (Throwable)e);
            }
        }
    }

    protected void createBeanElevator() {
        String conversationBeanElevatorName = FacesContext.getCurrentInstance().getExternalContext().getInitParameter(INIT_BEAN_ELEVATOR);
        if (conversationBeanElevatorName == null) {
            this.conversationBeanElevator = new DefaultConversationBeanElevator();
        } else {
            try {
                this.conversationBeanElevator = (DefaultConversationBeanElevator)ClassUtils.classForName((String)conversationBeanElevatorName).newInstance();
            }
            catch (InstantiationException e) {
                throw new FacesException("error creating bean elevator: " + conversationBeanElevatorName, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new FacesException("error creating bean elevator: " + conversationBeanElevatorName, (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new FacesException("error creating bean elevator: " + conversationBeanElevatorName, (Throwable)e);
            }
        }
    }

    protected PersistenceManagerFactory getPersistenceManagerFactory() {
        if (this.persistenceManagerFactory == null) {
            String persistenceManagerFactoryName = (String)ConversationServletFilter.getConversationExternalContext().getInitParameterMap().get(INIT_PERSISTENCE_MANAGER_FACOTRY);
            if (persistenceManagerFactoryName == null) {
                throw new IllegalArgumentException("please configure 'org.apache.myfaces.conversation.PERSISTENCE_MANAGER_FACTORY' in your web.xml");
            }
            try {
                this.persistenceManagerFactory = (PersistenceManagerFactory)ClassUtils.classForName((String)persistenceManagerFactoryName).newInstance();
            }
            catch (InstantiationException e) {
                throw new FacesException("error creating persistenceManagerFactory named: " + persistenceManagerFactoryName, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new FacesException("error creating persistenceManagerFactory named: " + persistenceManagerFactoryName, (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new FacesException("error creating persistenceManagerFactory named: " + persistenceManagerFactoryName, (Throwable)e);
            }
        }
        return this.persistenceManagerFactory;
    }

    protected void attachPersistence() {
        ConversationContext conversationContext = this.getConversationContext();
        if (conversationContext != null) {
            conversationContext.attachPersistence();
        }
    }

    protected void detachPersistence() {
        ConversationContext conversationContext = this.getConversationContext();
        if (conversationContext != null) {
            conversationContext.detachPersistence();
        }
    }

    protected void purgePersistence() {
        ConversationContext conversationContext = this.getConversationContext();
        if (conversationContext != null) {
            conversationContext.purgePersistence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkContextTimeout() {
        Map map = this.conversationContexts;
        synchronized (map) {
            long timeToLive = 1800000L;
            long checkTime = System.currentTimeMillis();
            Iterator iterContexts = this.conversationContexts.values().iterator();
            while (iterContexts.hasNext()) {
                ConversationContext conversationContext = (ConversationContext)iterContexts.next();
                if (conversationContext.getLastAccess() + timeToLive >= checkTime) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("end conversation context due to timeout: " + conversationContext.getId()));
                }
                conversationContext.shutdownContext();
                iterContexts.remove();
            }
        }
    }

    public ConversationBeanElevator getConversationBeanElevator() {
        return this.conversationBeanElevator;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }

    private Object readResolve() throws ObjectStreamException {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ContextWiperThread
    extends Thread {
        private static final long CHECK_TIME = 300000L;

        public ContextWiperThread() {
            this.setDaemon(true);
            this.setName("ConversationManager.ContextWiperThread");
        }

        public void run() {
            while (!this.isInterrupted()) {
                ConversationManager.this.checkContextTimeout();
                try {
                    Thread.sleep(300000L);
                }
                catch (InterruptedException e) {
                    log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }
}

