/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.conversation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;
import org.apache.myfaces.custom.conversation.AbstractConversationActionListener;
import org.apache.myfaces.custom.conversation.AbstractConversationComponent;
import org.apache.myfaces.custom.conversation.ConversationManager;
import org.apache.myfaces.custom.conversation.ConversationUtils;
import org.apache.myfaces.custom.conversation.ConversationVariableResolver;
import org.apache.myfaces.custom.conversation.UIConversation;

public class UIStartConversation
extends AbstractConversationComponent {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.StartConversation";
    private static final String CONVERSATION_SYSTEM_SETUP = "org.apache.myfaces.ConversationSystemSetup";
    private boolean inited;
    private Boolean persistence;

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
        this.setupConversationSystem(context);
        UICommand command = ConversationUtils.findParentCommand((UIComponent)this);
        if (command != null) {
            if (!this.inited) {
                ConversationStartAction actionListener = new ConversationStartAction();
                actionListener.setConversationName(this.getName());
                actionListener.setPersistence(this.toBoolean(this.getPersistence()));
                command.addActionListener((ActionListener)actionListener);
                Iterator iterChildren = this.getChildren().iterator();
                while (iterChildren.hasNext()) {
                    Object child = iterChildren.next();
                    if (!(child instanceof UIConversation)) continue;
                    UIConversation conversation = (UIConversation)((Object)child);
                    actionListener.addBeanToElevate(conversation.getBeanBinding().getExpressionString());
                }
                this.inited = true;
            }
        } else {
            ConversationManager conversationManager = ConversationManager.getInstance();
            conversationManager.startConversation(this.getName(), this.toBoolean(this.getPersistence()));
        }
    }

    protected boolean toBoolean(Boolean bool) {
        if (bool != null) {
            return bool;
        }
        return false;
    }

    protected void setupConversationSystem(FacesContext context) {
        if (Boolean.TRUE.equals(context.getExternalContext().getApplicationMap().get(CONVERSATION_SYSTEM_SETUP))) {
            return;
        }
        VariableResolver originalVR = context.getApplication().getVariableResolver();
        context.getApplication().setVariableResolver((VariableResolver)new ConversationVariableResolver(originalVR));
        context.getExternalContext().getApplicationMap().put(CONVERSATION_SYSTEM_SETUP, Boolean.TRUE);
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] states = (Object[])state;
        super.restoreState(context, states[0]);
        this.inited = (Boolean)states[1];
        this.persistence = (Boolean)states[2];
    }

    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), this.inited ? Boolean.TRUE : Boolean.FALSE, this.persistence};
    }

    public Boolean getPersistence() {
        if (this.persistence != null) {
            return this.persistence;
        }
        ValueBinding vb = this.getValueBinding("persistence");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
    }

    public void setPersistence(Boolean persistence) {
        this.persistence = persistence;
    }

    public static class ConversationStartAction
    extends AbstractConversationActionListener {
        private boolean persistence;
        private List beanToElevate;

        public void doConversationAction(AbstractConversationComponent abstractConversationComponent) {
            ConversationManager conversationManager = ConversationManager.getInstance();
            conversationManager.startConversation(this.getConversationName(), this.isPersistence());
            if (this.beanToElevate != null) {
                FacesContext context = FacesContext.getCurrentInstance();
                Iterator iterBeans = this.beanToElevate.iterator();
                while (iterBeans.hasNext()) {
                    String vb = (String)iterBeans.next();
                    UIConversation.elevateBean(context, this.getConversationName(), context.getApplication().createValueBinding(vb));
                }
            }
        }

        public boolean isPersistence() {
            return this.persistence;
        }

        public void setPersistence(boolean persistence) {
            this.persistence = persistence;
        }

        public void addBeanToElevate(String beanBinding) {
            if (this.beanToElevate == null) {
                this.beanToElevate = new ArrayList();
            }
            this.beanToElevate.add(beanBinding);
        }

        public Object saveState(FacesContext context) {
            return new Object[]{super.saveState(context), this.persistence, this.beanToElevate};
        }

        public void restoreState(FacesContext context, Object state) {
            Object[] states = (Object[])state;
            super.restoreState(context, states[0]);
            this.persistence = (Boolean)states[1];
            this.beanToElevate = (List)states[2];
        }
    }
}

