/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.convertStringUtils;

import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.ValueBinding;
import javax.faces.webapp.ConverterTag;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.myfaces.custom.convertStringUtils.StringUtilsConverter;

public class StringUtilsConverterTag
extends ConverterTag {
    private static final long serialVersionUID = 9006143486961806695L;
    private String format;
    private String maxLength;
    private String trim;
    private String appendEllipsesDuringInput;
    private String appendEllipsesDuringOutput;

    public StringUtilsConverterTag() {
        this.setConverterId(StringUtilsConverter.CONVERTER_ID);
    }

    public void release() {
        this.format = null;
        this.maxLength = null;
        this.trim = null;
        this.appendEllipsesDuringInput = null;
        this.appendEllipsesDuringOutput = null;
    }

    public void setPageContext(PageContext context) {
        super.setPageContext(context);
        this.setConverterId(StringUtilsConverter.CONVERTER_ID);
    }

    protected Converter createConverter() throws JspException {
        StringUtilsConverter converter = (StringUtilsConverter)super.createConverter();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        StringUtilsConverterTag.setConverterFormatValue(facesContext, converter, this.format);
        StringUtilsConverterTag.setConverterMaxLengthValue(facesContext, converter, this.maxLength);
        StringUtilsConverterTag.setConverterTrimValue(facesContext, converter, this.trim);
        StringUtilsConverterTag.setConverterAppendEllipsesDuringInputValue(facesContext, converter, this.appendEllipsesDuringInput);
        StringUtilsConverterTag.setConverterAppendEllipsesDuringOutputValue(facesContext, converter, this.appendEllipsesDuringOutput);
        return converter;
    }

    private static void setConverterFormatValue(FacesContext facesContext, StringUtilsConverter converter, String value) {
        if (null == value) {
            return;
        }
        if (UIComponentTag.isValueReference((String)value)) {
            ValueBinding vb = facesContext.getApplication().createValueBinding(value);
            converter.setFormat((String)vb.getValue(facesContext));
        } else {
            converter.setFormat(value);
        }
    }

    private static void setConverterMaxLengthValue(FacesContext facesContext, StringUtilsConverter converter, String value) {
        if (null == value) {
            return;
        }
        if (UIComponentTag.isValueReference((String)value)) {
            ValueBinding vb = facesContext.getApplication().createValueBinding(value);
            converter.setMaxLength((Integer)vb.getValue(facesContext));
        } else {
            converter.setMaxLength(Integer.valueOf(value));
        }
    }

    private static void setConverterTrimValue(FacesContext facesContext, StringUtilsConverter converter, String value) {
        if (null == value) {
            return;
        }
        if (UIComponentTag.isValueReference((String)value)) {
            ValueBinding vb = facesContext.getApplication().createValueBinding(value);
            converter.setTrim((Boolean)vb.getValue(facesContext));
        } else {
            converter.setTrim(Boolean.valueOf(value));
        }
    }

    private static void setConverterAppendEllipsesDuringInputValue(FacesContext facesContext, StringUtilsConverter converter, String value) {
        if (null == value) {
            return;
        }
        if (UIComponentTag.isValueReference((String)value)) {
            ValueBinding vb = facesContext.getApplication().createValueBinding(value);
            converter.setAppendEllipsesDuringInput((Boolean)vb.getValue(facesContext));
        } else {
            converter.setAppendEllipsesDuringInput(Boolean.valueOf(value));
        }
    }

    private static void setConverterAppendEllipsesDuringOutputValue(FacesContext facesContext, StringUtilsConverter converter, String value) {
        if (null == value) {
            return;
        }
        if (UIComponentTag.isValueReference((String)value)) {
            ValueBinding vb = facesContext.getApplication().createValueBinding(value);
            converter.setAppendEllipsesDuringOutput((Boolean)vb.getValue(facesContext));
        } else {
            converter.setAppendEllipsesDuringOutput(Boolean.valueOf(value));
        }
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(String maxLength) {
        this.maxLength = maxLength;
    }

    public String getTrim() {
        return this.trim;
    }

    public void setTrim(String trim) {
        this.trim = trim;
    }

    public String getAppendEllipsesDuringInput() {
        return this.appendEllipsesDuringInput;
    }

    public void setAppendEllipsesDuringInput(String appendEllipsesDuringInput) {
        this.appendEllipsesDuringInput = appendEllipsesDuringInput;
    }

    public String getAppendEllipsesDuringOutput() {
        return this.appendEllipsesDuringOutput;
    }

    public void setAppendEllipsesDuringOutput(String appendEllipsesDuringOutput) {
        this.appendEllipsesDuringOutput = appendEllipsesDuringOutput;
    }
}

