/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.imageloop;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.custom.dojo.DojoConfig;
import org.apache.myfaces.custom.dojo.DojoUtils;
import org.apache.myfaces.custom.imageloop.GraphicItem;
import org.apache.myfaces.custom.imageloop.HtmlImageLoop;
import org.apache.myfaces.custom.imageloop.ImageLoopItemsIterator;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;

public class HtmlImageLoopRenderer
extends HtmlRenderer {
    private static final Integer DEFAULT_DELAY = new Integer(1000);
    private static final Integer DEFAULT_TRANSITION_TIME = new Integer(1000);
    static /* synthetic */ Class class$org$apache$myfaces$custom$imageloop$HtmlImageLoop;

    private void encodeJavascript(FacesContext context, UIComponent uiComponent) throws IOException {
        String javascriptLocation = (String)uiComponent.getAttributes().get("org.apache.myfaces.JAVASCRIPT_LOCATION");
        DojoUtils.addMainInclude((FacesContext)context, (UIComponent)uiComponent, (String)javascriptLocation, (DojoConfig)new DojoConfig());
        DojoUtils.addRequire((FacesContext)context, (UIComponent)uiComponent, (String)"dojo.event.*");
        DojoUtils.addRequire((FacesContext)context, (UIComponent)uiComponent, (String)"dojo.lfx.*");
        DojoUtils.addRequire((FacesContext)context, (UIComponent)uiComponent, (String)"dojo.html.*");
        AddResource addResource = AddResourceFactory.getInstance((FacesContext)context);
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$imageloop$HtmlImageLoop == null ? (class$org$apache$myfaces$custom$imageloop$HtmlImageLoop = HtmlImageLoopRenderer.class$("org.apache.myfaces.custom.imageloop.HtmlImageLoop")) : class$org$apache$myfaces$custom$imageloop$HtmlImageLoop, "javascript/imageloop.js");
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity((FacesContext)facesContext, (UIComponent)uiComponent, (Class)(class$org$apache$myfaces$custom$imageloop$HtmlImageLoop == null ? (class$org$apache$myfaces$custom$imageloop$HtmlImageLoop = HtmlImageLoopRenderer.class$("org.apache.myfaces.custom.imageloop.HtmlImageLoop")) : class$org$apache$myfaces$custom$imageloop$HtmlImageLoop));
        this.encodeJavascript(facesContext, uiComponent);
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        String clientIdImage1 = clientId + ":IMG1";
        String clientIdImage2 = clientId + ":IMG2";
        HtmlImageLoop imageLoop = (HtmlImageLoop)uiComponent;
        Integer delay = imageLoop.getDelay() != null ? imageLoop.getDelay() : DEFAULT_DELAY;
        Integer minDelay = imageLoop.getMinDelay() != null ? imageLoop.getMinDelay() : DEFAULT_DELAY;
        Integer maxDelay = imageLoop.getMaxDelay() != null ? imageLoop.getMaxDelay() : DEFAULT_DELAY;
        Integer transitionTime = imageLoop.getTransitionTime() != null ? imageLoop.getTransitionTime() : DEFAULT_TRANSITION_TIME;
        Integer width = imageLoop.getWidth();
        Integer height = imageLoop.getHeight();
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("style", (Object)("position:relative;width:" + width + ";" + "height:" + height), null);
        writer.startElement("img", uiComponent);
        writer.writeAttribute("id", (Object)clientIdImage1, null);
        writer.writeAttribute("src", (Object)"", null);
        writer.writeAttribute("style", (Object)"position:absolute;top:0px;left:0px;border-style:none", null);
        writer.endElement("img");
        writer.startElement("img", uiComponent);
        writer.writeAttribute("id", (Object)clientIdImage2, null);
        writer.writeAttribute("src", (Object)"", null);
        writer.writeAttribute("style", (Object)"position:absolute;top:0px;left:0px;border-style:none", null);
        writer.endElement("img");
        writer.startElement("script", uiComponent);
        writer.writeAttribute("language", (Object)"JavaScript", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String jsImageArray = this.getJavascriptImageArray(facesContext, uiComponent);
        writer.writeText((Object)("new ImageLoop('" + clientId + "', " + jsImageArray + ", " + delay + ", " + minDelay + ", " + maxDelay + ", " + transitionTime + ")"), null);
        writer.endElement("script");
        writer.endElement("div");
    }

    private String getJavascriptImageArray(FacesContext facesContext, UIComponent uiComponent) {
        String jsArray = new String();
        ImageLoopItemsIterator itemIter = new ImageLoopItemsIterator(uiComponent);
        while (itemIter.hasNext()) {
            GraphicItem graphicItem = (GraphicItem)itemIter.next();
            String url = graphicItem.getUrl();
            String src = facesContext.getApplication().getViewHandler().getResourceURL(facesContext, url);
            if (jsArray.length() == 0) {
                jsArray = jsArray + "'" + facesContext.getExternalContext().encodeResourceURL(src) + "'";
                continue;
            }
            jsArray = jsArray + ",'" + facesContext.getExternalContext().encodeResourceURL(src) + "'";
        }
        return "[" + jsArray + "]";
    }

    public boolean getRendersChildren() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

