/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.imageloop;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.custom.imageloop.GraphicItem;
import org.apache.myfaces.custom.imageloop.ImageLoopItems;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;

public class ImageLoopItemsIterator
implements Iterator {
    private final Iterator _childs;
    private Iterator _nestedItems;
    private Object _nextItem;
    private ImageLoopItems _currentImageLoopItems;
    private String _collectionLabel;

    public ImageLoopItemsIterator(UIComponent htmlImageLoopItemsParent) {
        this._childs = htmlImageLoopItemsParent.getChildren().iterator();
    }

    public boolean hasNext() {
        if (this._nextItem != null) {
            return true;
        }
        if (this._nestedItems != null) {
            if (this._nestedItems.hasNext()) {
                return true;
            }
            this._nestedItems = null;
        }
        if (this._childs.hasNext()) {
            UIComponent child = (UIComponent)this._childs.next();
            if (child instanceof UIGraphic) {
                UIGraphic uiGraphic = (UIGraphic)child;
                String url = uiGraphic.getUrl();
                this._nextItem = new GraphicItem(url);
                return true;
            }
            if (child instanceof ImageLoopItems) {
                this._currentImageLoopItems = (ImageLoopItems)child;
                Object value = this._currentImageLoopItems.getValue();
                if (value instanceof GraphicItem) {
                    this._nextItem = value;
                    return true;
                }
                if (value instanceof GraphicItem[]) {
                    this._nestedItems = Arrays.asList((GraphicItem[])value).iterator();
                    this._collectionLabel = "Array";
                    return this.hasNext();
                }
                if (value instanceof Collection) {
                    this._nestedItems = ((Collection)value).iterator();
                    this._collectionLabel = "Collection";
                    return this.hasNext();
                }
                ValueBinding binding = this._currentImageLoopItems.getValueBinding("value");
                throw new IllegalArgumentException("Value binding '" + (binding == null ? null : binding.getExpressionString()) + "'of ImageLoopItems with component-path " + RendererUtils.getPathToComponent((UIComponent)child) + " does not reference an Object of type GraphicItem, GraphicItem[] or Collection but of type : " + (value == null ? null : value.getClass().getName()));
            }
        }
        return false;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this._nextItem != null) {
            Object value = this._nextItem;
            this._nextItem = null;
            return value;
        }
        if (this._nestedItems != null) {
            Object item = this._nestedItems.next();
            if (!(item instanceof GraphicItem)) {
                ValueBinding binding = this._currentImageLoopItems.getValueBinding("value");
                throw new IllegalArgumentException(this._collectionLabel + " referenced by ImageLoopItems with binding '" + binding.getExpressionString() + "' and Component-Path : " + RendererUtils.getPathToComponent((UIComponent)this._currentImageLoopItems) + " does not contain objects of type GraphicItem");
            }
            return item;
        }
        throw new NoSuchElementException();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

