/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.security;

import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.PropertyResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.security.SecurityContext;

public class SecurityContextPropertyResolver
extends PropertyResolver {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$custom$security$SecurityContextPropertyResolver == null ? (class$org$apache$myfaces$custom$security$SecurityContextPropertyResolver = SecurityContextPropertyResolver.class$("org.apache.myfaces.custom.security.SecurityContextPropertyResolver")) : class$org$apache$myfaces$custom$security$SecurityContextPropertyResolver));
    private static final String AUTH_TYPE = "authType";
    private static final String USER = "remoteUser";
    private static final String IF_GRANTED = "ifGranted";
    private static final String IF_ALL_GRANTED = "ifAllGranted";
    private static final String IF_ANY_GRANTED = "ifAnyGranted";
    private static final String IF_NOT_GRANTED = "ifNotGranted";
    private PropertyResolver originalResolver;
    static /* synthetic */ Class class$org$apache$myfaces$custom$security$SecurityContextPropertyResolver;
    static /* synthetic */ Class class$org$apache$myfaces$custom$security$SecurityContext;

    public SecurityContextPropertyResolver(PropertyResolver propertyresolver) {
        this.originalResolver = propertyresolver;
    }

    public Object getValue(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof SecurityContext) {
            SecurityContext securityContext = (SecurityContext)base;
            if (property.equals(AUTH_TYPE)) {
                return securityContext.getAuthType();
            }
            if (property.equals(USER)) {
                return securityContext.getRemoteUser();
            }
            if (property.equals(IF_GRANTED)) {
                securityContext.setAuthMode(0);
                return securityContext;
            }
            if (property.equals(IF_ALL_GRANTED)) {
                securityContext.setAuthMode(1);
                return securityContext;
            }
            if (property.equals(IF_ANY_GRANTED)) {
                securityContext.setAuthMode(2);
                return securityContext;
            }
            if (property.equals(IF_NOT_GRANTED)) {
                securityContext.setAuthMode(3);
                return securityContext;
            }
            if (securityContext.inAuthMode()) {
                securityContext.setRoles(this.getRolesFromProperty(property));
                int authMode = securityContext.getAuthMode();
                if (authMode == 0) {
                    return securityContext.ifSingleGranted();
                }
                if (authMode == 1) {
                    return securityContext.ifAllGranted();
                }
                if (authMode == 2) {
                    return securityContext.ifAnyGranted();
                }
                return securityContext.ifNotGranted();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception while retrieving property; base : " + base.getClass().getName() + ", property : " + property));
            }
            throw new PropertyNotFoundException(SecurityContextPropertyResolver.getMessage(base, (String)property));
        }
        return this.originalResolver.getValue(base, property);
    }

    public Class getType(Object base, int index) throws EvaluationException, PropertyNotFoundException {
        return this.originalResolver.getType(base, index);
    }

    public Class getType(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof SecurityContext) {
            return class$org$apache$myfaces$custom$security$SecurityContext == null ? (class$org$apache$myfaces$custom$security$SecurityContext = SecurityContextPropertyResolver.class$("org.apache.myfaces.custom.security.SecurityContext")) : class$org$apache$myfaces$custom$security$SecurityContext;
        }
        return this.originalResolver.getType(base, property);
    }

    public Object getValue(Object base, int index) throws EvaluationException, PropertyNotFoundException {
        return this.originalResolver.getValue(base, index);
    }

    public boolean isReadOnly(Object base, int index) throws EvaluationException, PropertyNotFoundException {
        return this.originalResolver.isReadOnly(base, index);
    }

    public boolean isReadOnly(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof SecurityContext) {
            return true;
        }
        return this.originalResolver.isReadOnly(base, property);
    }

    public void setValue(Object base, int index, Object value) throws EvaluationException, PropertyNotFoundException {
        this.originalResolver.setValue(base, index, value);
    }

    public void setValue(Object base, Object property, Object value) throws EvaluationException, PropertyNotFoundException {
        this.originalResolver.setValue(base, property, value);
    }

    private String[] getRolesFromProperty(Object property) {
        String[] roles = ((String)property).split(",");
        for (int i = 0; i < roles.length; ++i) {
            roles[i] = roles[i].trim();
        }
        return roles;
    }

    private static String getMessage(Object base, String name) {
        return "Bean: " + base.getClass().getName() + ", property: " + name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

