/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.subform;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.custom.subform.SubForm;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.FormInfo;

public class SubFormRenderer
extends HtmlRenderer {
    private static final String SUBMIT_FUNCTION_SUFFIX = "_submit";
    private static final String HIDDEN_PARAM_NAME = "org.apache.myfaces.custom.subform.submittedId";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        super.encodeBegin(context, component);
        ResponseWriter writer = context.getResponseWriter();
        HtmlRendererUtils.writePrettyLineSeparator((FacesContext)context);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        FormInfo parentFormInfo = RendererUtils.findNestingForm((UIComponent)component, (FacesContext)context);
        if (parentFormInfo != null) {
            writer.writeText((Object)this.createPartialSubmitJS(component.getId(), parentFormInfo.getFormName()), null);
        }
        writer.endElement("script");
        HtmlRendererUtils.writePrettyLineSeparator((FacesContext)context);
    }

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        Map paramValuesMap = context.getExternalContext().getRequestParameterMap();
        String reqValue = (String)paramValuesMap.get(HIDDEN_PARAM_NAME);
        if (reqValue != null && component.getId().equals(reqValue)) {
            ((SubForm)component).setSubmitted(true);
        }
    }

    protected String createPartialSubmitJS(String subFormId, String parentFormClientId) {
        StringBuffer script = new StringBuffer();
        script.append("function ");
        script.append(subFormId).append("_submit()");
        script.append(" {\n");
        script.append("var form = document.forms['").append(parentFormClientId).append("'];\n");
        script.append("var el = document.createElement(\"input\");\n");
        script.append("el.type = \"hidden\";\n");
        script.append("el.name = \"org.apache.myfaces.custom.subform.submittedId\";\n");
        script.append("el.value = \"").append(subFormId).append("\";\n");
        script.append("form.appendChild(el);\n");
        script.append("form.submit();\n");
        script.append("}\n");
        return script.toString();
    }
}

