/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.util;

import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlMessages;
import javax.faces.context.FacesContext;

public final class ComponentUtils {
    private ComponentUtils() {
    }

    public static UIComponent findComponentByClientId(FacesContext context, UIComponent root, String clientId) {
        UIComponent component = null;
        for (int i = 0; i < root.getChildCount() && component == null; ++i) {
            UIComponent child = (UIComponent)root.getChildren().get(i);
            component = ComponentUtils.findComponentByClientId(context, child, clientId);
        }
        if (root.getId() != null && component == null && root.getClientId(context).equals(clientId)) {
            component = root;
        }
        return component;
    }

    public static UIComponent findComponentById(FacesContext context, UIComponent root, String id) {
        UIComponent component = null;
        for (int i = 0; i < root.getChildCount() && component == null; ++i) {
            UIComponent child = (UIComponent)root.getChildren().get(i);
            component = ComponentUtils.findComponentById(context, child, id);
        }
        if (root.getId() != null && component == null && root.getId().equals(id)) {
            component = root;
        }
        return component;
    }

    public static UIComponent findFirstMessagesComponent(FacesContext context, UIComponent base) {
        if (base == null) {
            return null;
        }
        if (base instanceof HtmlMessages) {
            return base;
        }
        Iterator iterChildren = base.getFacetsAndChildren();
        while (iterChildren.hasNext()) {
            UIComponent child = (UIComponent)iterChildren.next();
            UIComponent found = ComponentUtils.findFirstMessagesComponent(context, child);
            if (found == null) continue;
            return found;
        }
        return null;
    }
}

