/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.ldap;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.AbstractDirectory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryFieldMapper;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.ldap.ContextProvider;
import org.nuxeo.ecm.directory.ldap.LDAPDirectoryDescriptor;
import org.nuxeo.ecm.directory.ldap.LDAPDirectoryFactory;
import org.nuxeo.ecm.directory.ldap.LDAPDynamicReferenceDescriptor;
import org.nuxeo.ecm.directory.ldap.LDAPReference;
import org.nuxeo.ecm.directory.ldap.LDAPServerDescriptor;
import org.nuxeo.ecm.directory.ldap.LDAPSession;
import org.nuxeo.runtime.api.Framework;

public class LDAPDirectory
extends AbstractDirectory {
    private static final Log log = LogFactory.getLog(LDAPDirectory.class);
    public static final String DN_SPECIAL_ATTRIBUTE_KEY = "dn";
    protected final LDAPDirectoryDescriptor config;
    protected final Properties contextProperties;
    protected final SearchControls searchControls;
    protected final Map<String, Field> schemaFieldMap;
    protected final LDAPDirectoryFactory factory;
    protected final String baseFilter;
    protected ContextProvider testServer;

    public LDAPDirectory(LDAPDirectoryDescriptor config) throws ClientException {
        super(config.name);
        this.config = config;
        this.factory = (LDAPDirectoryFactory)((Object)Framework.getRuntime().getComponent("org.nuxeo.ecm.directory.ldap.LDAPDirectoryFactory"));
        if (config.getIdField() == null || config.getIdField().equals("")) {
            throw new DirectoryException("idField configuration is missing for directory " + config.getName());
        }
        if (config.getSchemaName() == null || config.getSchemaName().equals("")) {
            throw new DirectoryException("schema configuration is missing for directory " + config.getName());
        }
        if (config.getSearchBaseDn() == null || config.getSearchBaseDn().equals("")) {
            throw new DirectoryException("searchBaseDn configuration is missing for directory " + config.getName());
        }
        SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        Schema schema = schemaManager.getSchema(config.getSchemaName());
        if (schema == null) {
            throw new DirectoryException(config.getSchemaName() + " is not a registered schema");
        }
        this.schemaFieldMap = new LinkedHashMap<String, Field>();
        for (Field f : schema.getFields()) {
            this.schemaFieldMap.put(f.getName().getLocalName(), f);
        }
        this.fieldMapper = new DirectoryFieldMapper(config.fieldMapping);
        this.contextProperties = this.computeContextProperties();
        this.baseFilter = config.getAggregatedSearchFilter();
        this.addReferences(config.getInverseReferences());
        this.addReferences(config.getLdapReferences());
        this.searchControls = this.computeSearchControls();
        this.cache.setMaxSize(config.getCacheMaxSize());
        this.cache.setTimeout(config.getCacheTimeout());
        log.debug((Object)String.format("initialized LDAP directory %s with fields [%s] and references [%s]", config.getName(), StringUtils.join((Object[])this.schemaFieldMap.keySet().toArray(), (String)", "), StringUtils.join((Object[])this.references.keySet().toArray(), (String)", ")));
    }

    protected Properties computeContextProperties() throws DirectoryException {
        String bindDn;
        Properties props = new Properties();
        LDAPServerDescriptor serverConfig = this.getServer();
        if (null == serverConfig) {
            throw new DirectoryException("LDAP server configuration not found: " + this.config.getServerName());
        }
        props.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        String ldapUrls = serverConfig.getLdapUrls();
        if (serverConfig.getLdapUrls() == null || this.config.getSchemaName().equals("")) {
            throw new DirectoryException("Server LDAP URL configuration is missing for directory " + this.config.getName());
        }
        props.put("java.naming.provider.url", ldapUrls);
        if (!this.getConfig().followReferrals) {
            props.put("java.naming.referral", "ignore");
        } else {
            props.put("java.naming.referral", "follow");
        }
        if (serverConfig.getConnectionTimeout() > -1) {
            if (!serverConfig.useSsl()) {
                props.put("com.sun.jndi.ldap.connect.timeout", Integer.toString(serverConfig.getConnectionTimeout()));
            } else {
                log.warn((Object)"SSL connections do not operate correctly when used with the connection timeout parameter, disabling timout");
            }
        }
        if ((bindDn = serverConfig.getBindDn()) != null) {
            props.put("java.naming.security.principal", bindDn);
            props.put("java.naming.security.credentials", serverConfig.getBindPassword());
        }
        if (serverConfig.isPoolingEnabled()) {
            props.put("com.sun.jndi.ldap.connect.pool", "true");
            props.put("com.sun.jndi.ldap.connect.pool.protocol", "plain ssl");
            props.put("com.sun.jndi.ldap.connect.pool.authentication", "none simple DIGEST-MD5");
            props.put("com.sun.jndi.ldap.connect.pool.timeout", "1800000");
        }
        if (!serverConfig.isVerifyServerCert() && serverConfig.useSsl) {
            props.put("java.naming.ldap.factory.socket", "org.nuxeo.ecm.directory.ldap.LDAPDirectory$TrustingSSLSocketFactory");
        }
        return props;
    }

    public Properties getContextProperties() {
        return this.contextProperties;
    }

    protected SearchControls computeSearchControls() throws DirectoryException {
        SearchControls scts = new SearchControls();
        scts.setSearchScope(this.config.getSearchScope());
        HashSet<String> attrs = new HashSet<String>();
        for (String fieldName : this.schemaFieldMap.keySet()) {
            if (this.references.containsKey(fieldName)) continue;
            attrs.add(this.fieldMapper.getBackendField(fieldName));
        }
        attrs.add("objectClass");
        for (Reference reference : this.references.values()) {
            if (!(reference instanceof LDAPReference)) continue;
            LDAPReference ldapReference = (LDAPReference)reference;
            attrs.add(ldapReference.getStaticAttributeId(this.fieldMapper));
            attrs.add(ldapReference.getDynamicAttributeId());
            for (LDAPDynamicReferenceDescriptor dynAtt : ldapReference.getDynamicAttributes()) {
                attrs.add(dynAtt.baseDN);
                attrs.add(dynAtt.filter);
            }
        }
        if (this.config.getPasswordField() != null) {
            attrs.remove(this.config.getPasswordField());
        }
        scts.setReturningAttributes(attrs.toArray(new String[attrs.size()]));
        scts.setCountLimit(this.config.getQuerySizeLimit());
        scts.setTimeLimit(this.config.getQueryTimeLimit());
        return scts;
    }

    public SearchControls getSearchControls() {
        return this.getSearchControls(false);
    }

    public SearchControls getSearchControls(boolean fetchAllAttributes) {
        if (fetchAllAttributes) {
            SearchControls scts = new SearchControls();
            scts.setSearchScope(this.config.getSearchScope());
            return scts;
        }
        return this.searchControls;
    }

    protected DirContext createContext() throws DirectoryException {
        try {
            String serverName = this.config.getServerName();
            if (serverName == null || serverName.equals("")) {
                throw new DirectoryException("server configuration is missing for directory " + this.config.getName());
            }
            LDAPServerDescriptor serverConfig = this.getServer();
            if (serverConfig.isDynamicServerList()) {
                String ldapUrls = serverConfig.getLdapUrls();
                this.contextProperties.put("java.naming.provider.url", ldapUrls);
            }
            return new InitialDirContext(this.contextProperties);
        }
        catch (NamingException e) {
            throw new DirectoryException("Cannot connect to LDAP directory '" + this.getName() + "': " + e.getMessage(), (Throwable)e);
        }
    }

    public String getName() {
        return this.config.getName();
    }

    public String getSchema() {
        return this.config.getSchemaName();
    }

    public String getParentDirectory() {
        return null;
    }

    public String getIdField() {
        return this.config.getIdField();
    }

    public String getPasswordField() {
        return this.config.getPasswordField();
    }

    public LDAPServerDescriptor getServer() {
        return this.factory.getServer(this.config.getServerName());
    }

    public Session getSession() throws DirectoryException {
        DirContext context = this.testServer != null ? this.testServer.getContext() : this.createContext();
        LDAPSession session = new LDAPSession(this, context);
        this.addSession((Session)session);
        return session;
    }

    public String getBaseFilter() {
        String idField = this.getIdField();
        DirectoryFieldMapper fieldMapper = this.getFieldMapper();
        String idAttribute = fieldMapper.getBackendField(idField);
        String idFilter = String.format("(%s=*)", idAttribute);
        if (this.baseFilter != null && !"".equals(this.baseFilter)) {
            if (this.baseFilter.startsWith("(")) {
                return String.format("(&%s%s)", this.baseFilter, idFilter);
            }
            return String.format("(&(%s)%s)", this.baseFilter, idFilter);
        }
        return idFilter;
    }

    public LDAPDirectoryDescriptor getConfig() {
        return this.config;
    }

    public Map<String, Field> getSchemaFieldMap() {
        return this.schemaFieldMap;
    }

    public String getPasswordHashAlgorithmField() {
        return this.config.getPasswordHashAlgorithmField();
    }

    public void setTestServer(ContextProvider testServer) {
        this.testServer = testServer;
    }

    public static class TrustingSSLSocketFactory
    extends SSLSocketFactory {
        private SSLSocketFactory factory;

        public TrustingSSLSocketFactory() {
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, new TrustManager[]{new TrustingX509TrustManager()}, new SecureRandom());
                this.factory = sslContext.getSocketFactory();
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new RuntimeException("Unable to initialize the SSL context:  ", nsae);
            }
            catch (KeyManagementException kme) {
                throw new RuntimeException("Unable to register a trust manager:  ", kme);
            }
        }

        public static SocketFactory getDefault() {
            return TrustingSSLSocketFactoryHolder.INSTANCE;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.factory.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.factory.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            return this.factory.createSocket(s, host, port, autoClose);
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return this.factory.createSocket(host, port);
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.factory.createSocket(host, port);
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            return this.factory.createSocket(host, port, localHost, localPort);
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.factory.createSocket(address, port, localAddress, localPort);
        }

        private class TrustingX509TrustManager
        implements X509TrustManager {
            private TrustingX509TrustManager() {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }

        private static class TrustingSSLSocketFactoryHolder {
            public static final TrustingSSLSocketFactory INSTANCE = new TrustingSSLSocketFactory();

            private TrustingSSLSocketFactoryHolder() {
            }
        }
    }
}

