/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.ldap;

import com.sun.jndi.ldap.LdapURL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SchemaViolationException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.AbstractReference;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryEntryNotFoundException;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryFieldMapper;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.ldap.LDAPDirectory;
import org.nuxeo.ecm.directory.ldap.LDAPDirectoryDescriptor;
import org.nuxeo.ecm.directory.ldap.LDAPDirectoryProxy;
import org.nuxeo.ecm.directory.ldap.LDAPDynamicReferenceDescriptor;
import org.nuxeo.ecm.directory.ldap.LDAPFilterMatcher;
import org.nuxeo.ecm.directory.ldap.LDAPSession;
import org.nuxeo.ecm.directory.ldap.filter.FilterExpressionCorrector;

@XObject(value="ldapReference")
public class LDAPReference
extends AbstractReference {
    private static final Log log = LogFactory.getLog(LDAPReference.class);
    @XNodeList(value="dynamicReference", type=LDAPDynamicReferenceDescriptor[].class, componentType=LDAPDynamicReferenceDescriptor.class)
    private LDAPDynamicReferenceDescriptor[] dynamicReferences;
    @XNode(value="@forceDnConsistencyCheck")
    public boolean forceDnConsistencyCheck;
    protected LDAPDirectoryDescriptor targetDirectoryDescriptor;
    @XNode(value="@staticAttributeIdIsDn")
    private boolean staticAttributeIdIsDn = true;
    @XNode(value="@staticAttributeId")
    protected String staticAttributeId;
    @XNode(value="@dynamicAttributeId")
    protected String dynamicAttributeId;
    public static final List<String> EMPTY_STRING_LIST = Collections.emptyList();

    @XNode(value="@field")
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    private LDAPFilterMatcher getFilterMatcher() {
        return new LDAPFilterMatcher();
    }

    public boolean isStatic() throws DirectoryException {
        return this.getStaticAttributeId() != null;
    }

    public String getStaticAttributeId() throws DirectoryException {
        return this.getStaticAttributeId(null);
    }

    public String getStaticAttributeId(DirectoryFieldMapper sourceFM) throws DirectoryException {
        String backendFieldId;
        if (this.staticAttributeId != null) {
            return this.staticAttributeId;
        }
        if (sourceFM == null) {
            sourceFM = ((LDAPDirectory)this.getSourceDirectory()).getFieldMapper();
        }
        if (this.fieldName.equals(backendFieldId = sourceFM.getBackendField(this.fieldName))) {
            return null;
        }
        log.warn((Object)String.format("implicit static attribute definition through fieldMapping is deprecated, please update your setup with <ldapReference field=\"%s\" directory=\"%s\" staticAttributeId=\"%s\">", this.fieldName, this.sourceDirectoryName, backendFieldId));
        return backendFieldId;
    }

    public List<LDAPDynamicReferenceDescriptor> getDynamicAttributes() {
        return Arrays.asList(this.dynamicReferences);
    }

    public String getDynamicAttributeId() {
        return this.dynamicAttributeId;
    }

    public boolean isDynamic() {
        return this.dynamicAttributeId != null;
    }

    @XNode(value="@directory")
    public void setTargetDirectoryName(String targetDirectoryName) {
        this.targetDirectoryName = targetDirectoryName;
    }

    public Directory getSourceDirectory() throws DirectoryException {
        Directory sourceDir = super.getSourceDirectory();
        if (sourceDir instanceof LDAPDirectoryProxy) {
            return ((LDAPDirectoryProxy)sourceDir).getDirectory();
        }
        throw new DirectoryException(this.sourceDirectoryName + " is not a LDAPDirectory and thus cannot be used in a reference for " + this.fieldName);
    }

    public Directory getTargetDirectory() throws DirectoryException {
        Directory targetDir = super.getTargetDirectory();
        if (targetDir instanceof LDAPDirectoryProxy) {
            return ((LDAPDirectoryProxy)targetDir).getDirectory();
        }
        throw new DirectoryException(this.targetDirectoryName + " is not a LDAPDirectory and thus cannot be referenced as target by " + this.fieldName);
    }

    protected LDAPDirectory getTargetLDAPDirectory() throws DirectoryException {
        return (LDAPDirectory)this.getTargetDirectory();
    }

    protected LDAPDirectory getSourceLDAPDirectory() throws DirectoryException {
        return (LDAPDirectory)this.getSourceDirectory();
    }

    protected LDAPDirectoryDescriptor getTargetDirectoryDescriptor() throws DirectoryException {
        if (this.targetDirectoryDescriptor == null) {
            this.targetDirectoryDescriptor = this.getTargetLDAPDirectory().getConfig();
        }
        return this.targetDirectoryDescriptor;
    }

    public void addLinks(String sourceId, List<String> targetIds) throws DirectoryException {
        block18: {
            if (targetIds.isEmpty()) {
                return;
            }
            LDAPDirectory targetDirectory = (LDAPDirectory)this.getTargetDirectory();
            LDAPDirectory sourceDirectory = (LDAPDirectory)this.getSourceDirectory();
            String attributeId = this.getStaticAttributeId();
            if (attributeId == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("trying to edit a non-static reference from %s in directory %s: ignoring", sourceId, sourceDirectory.getName()));
                }
                return;
            }
            LDAPSession targetSession = (LDAPSession)targetDirectory.getSession();
            LDAPSession sourceSession = (LDAPSession)sourceDirectory.getSession();
            try {
                DocumentModel sourceEntry = sourceSession.getEntry(sourceId, false);
                if (sourceEntry == null) {
                    throw new DirectoryException(String.format("could not add links from unexisting %s in directory %s", sourceId, sourceDirectory.getName()));
                }
                if (BaseSession.isReadOnlyEntry((DocumentModel)sourceEntry)) break block18;
                SearchResult ldapEntry = sourceSession.getLdapEntry(sourceId);
                String sourceDn = ldapEntry.getNameInNamespace();
                Attribute storedAttr = ldapEntry.getAttributes().get(attributeId);
                String emptyRefMarker = sourceDirectory.getConfig().getEmptyRefMarker();
                BasicAttribute attrToAdd = new BasicAttribute(attributeId);
                for (String targetId : targetIds) {
                    if (this.staticAttributeIdIsDn) {
                        ldapEntry = targetSession.getLdapEntry(targetId);
                        if (ldapEntry == null) {
                            log.warn((Object)String.format("entry '%s' in directory '%s' not found: could not add link from '%s' in directory '%s' for '%s'", new Object[]{targetId, targetDirectory.getName(), sourceId, sourceDirectory.getName(), this}));
                            continue;
                        }
                        String dn = ldapEntry.getNameInNamespace();
                        if (storedAttr != null && storedAttr.contains(dn)) continue;
                        attrToAdd.add(dn);
                        continue;
                    }
                    if (storedAttr != null && storedAttr.contains(targetId)) continue;
                    attrToAdd.add(targetId);
                }
                if (attrToAdd.size() <= 0) break block18;
                try {
                    BasicAttributes attrsToAdd = new BasicAttributes();
                    attrsToAdd.put(attrToAdd);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("LDAPReference.addLinks(%s, [%s]): LDAP modifyAttributes dn='%s' mod_op='ADD_ATTRIBUTE' attrs='%s' [%s]", new Object[]{sourceId, StringUtils.join(targetIds, (String)", "), sourceDn, attrsToAdd, this}));
                    }
                    sourceSession.dirContext.modifyAttributes(sourceDn, 1, (Attributes)attrsToAdd);
                    if (storedAttr.contains(emptyRefMarker)) {
                        BasicAttributes cleanAttrs = new BasicAttributes(attributeId, emptyRefMarker);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("LDAPReference.addLinks(%s, [%s]): LDAP modifyAttributes dn='%s' mod_op='REMOVE_ATTRIBUTE' attrs='%s' [%s]", new Object[]{sourceId, StringUtils.join(targetIds, (String)", "), sourceDn, cleanAttrs, this}));
                        }
                        sourceSession.dirContext.modifyAttributes(sourceDn, 3, (Attributes)cleanAttrs);
                    }
                }
                catch (SchemaViolationException e) {
                    if (this.isDynamic()) {
                        log.warn((Object)String.format("cannot update dynamic reference in field %s for source %s", this.getFieldName(), sourceId));
                        break block18;
                    }
                    throw new DirectoryException((Throwable)e);
                }
            }
            catch (NamingException e) {
                throw new DirectoryException("addLinks failed: " + e.getMessage(), (Throwable)e);
            }
            finally {
                sourceSession.close();
                targetSession.close();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addLinks(List<String> sourceIds, String targetId) throws DirectoryException {
        String attributeId = this.getStaticAttributeId();
        if (attributeId == null && !sourceIds.isEmpty()) {
            log.warn((Object)"trying to edit a non-static reference: ignoring");
            return;
        }
        LDAPDirectory targetDirectory = (LDAPDirectory)this.getTargetDirectory();
        LDAPSession targetSession = (LDAPSession)targetDirectory.getSession();
        LDAPDirectory sourceDirectory = (LDAPDirectory)this.getSourceDirectory();
        LDAPSession sourceSession = (LDAPSession)sourceDirectory.getSession();
        String emptyRefMarker = sourceDirectory.getConfig().getEmptyRefMarker();
        try {
            if (sourceSession.isReadOnly()) return;
            SearchResult ldapEntry = targetSession.getLdapEntry(targetId);
            if (ldapEntry == null) {
                throw new DirectoryException(String.format("could not add links to unexisting %s in directory %s", targetId, targetDirectory.getName()));
            }
            String targetAttributeValue = this.staticAttributeIdIsDn ? ldapEntry.getNameInNamespace() : targetId;
            for (String sourceId : sourceIds) {
                DocumentModel sourceEntry = sourceSession.getEntry(sourceId, false);
                if (sourceEntry == null) {
                    log.warn((Object)String.format("entry %s in directory %s not found: could not add link to %s in directory %s", sourceId, sourceDirectory.getName(), targetId, targetDirectory.getName()));
                    continue;
                }
                if (BaseSession.isReadOnlyEntry((DocumentModel)sourceEntry)) {
                    log.warn((Object)String.format("entry %s in directory %s is readonly: could not add link to %s in directory %s", sourceId, sourceDirectory.getName(), targetId, targetDirectory.getName()));
                    continue;
                }
                ldapEntry = sourceSession.getLdapEntry(sourceId);
                String sourceDn = ldapEntry.getNameInNamespace();
                Attribute storedAttr = ldapEntry.getAttributes().get(attributeId);
                if (storedAttr.contains(targetAttributeValue)) continue;
                try {
                    BasicAttributes attrs = new BasicAttributes(attributeId, targetAttributeValue);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("LDAPReference.addLinks([%s], %s): LDAP modifyAttributes dn='%s' mod_op='ADD_ATTRIBUTE' attrs='%s' [%s]", new Object[]{StringUtils.join(sourceIds, (String)", "), targetId, sourceDn, attrs, this}));
                    }
                    sourceSession.dirContext.modifyAttributes(sourceDn, 1, (Attributes)attrs);
                    if (!storedAttr.contains(emptyRefMarker)) continue;
                    BasicAttributes cleanAttrs = new BasicAttributes(attributeId, emptyRefMarker);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("LDAPReference.addLinks(%s, %s): LDAP modifyAttributes dn='%s' mod_op='REMOVE_ATTRIBUTE' attrs='%s' [%s]", new Object[]{StringUtils.join(sourceIds, (String)", "), targetId, sourceDn, ((Object)cleanAttrs).toString(), this}));
                    }
                    sourceSession.dirContext.modifyAttributes(sourceDn, 3, (Attributes)cleanAttrs);
                }
                catch (SchemaViolationException e) {
                    if (!this.isDynamic()) throw new DirectoryException((Throwable)e);
                    log.warn((Object)String.format("cannot add dynamic reference in field %s for target %s", this.getFieldName(), targetId));
                    continue;
                    return;
                }
            }
        }
        catch (NamingException e) {
            throw new DirectoryException("addLinks failed: " + e.getMessage(), (Throwable)e);
        }
        finally {
            sourceSession.close();
            targetSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSourceIdsForTarget(String targetId) throws DirectoryException {
        String dynamicAttributeId;
        SearchControls sctls;
        TreeSet<String> sourceIds = new TreeSet<String>();
        SearchResult targetLdapEntry = null;
        String targetDn = null;
        String staticAttributeId = this.getStaticAttributeId();
        if (staticAttributeId != null) {
            LDAPDirectory targetDir = this.getTargetLDAPDirectory();
            LDAPSession targetSession = (LDAPSession)targetDir.getSession();
            if (this.staticAttributeIdIsDn) {
                try {
                    targetLdapEntry = targetSession.getLdapEntry(targetId, true);
                    if (targetLdapEntry == null) {
                        String msg = String.format("Failed to perform inverse lookup on LDAPReference resolving field '%s' of '%s' to entries of '%s' using the static content of attribute '%s': entry '%s' cannot be found in '%s'", this.fieldName, this.sourceDirectory, this.targetDirectoryName, staticAttributeId, targetId, this.targetDirectoryName);
                        throw new DirectoryEntryNotFoundException(msg);
                    }
                    targetDn = LDAPReference.pseudoNormalizeDn(targetLdapEntry.getNameInNamespace());
                }
                catch (NamingException e) {
                    throw new DirectoryException("error fetching " + targetId + " from " + this.targetDirectoryName + ": " + e.getMessage(), (Throwable)e);
                }
                finally {
                    targetSession.close();
                }
            }
            LDAPDirectory sourceDirectory = this.getSourceLDAPDirectory();
            String filterExpr = String.format("(&(%s={0})%s)", staticAttributeId, sourceDirectory.getBaseFilter());
            Object[] filterArgs = new String[]{this.staticAttributeIdIsDn ? targetDn : targetId};
            String searchBaseDn = sourceDirectory.getConfig().getSearchBaseDn();
            LDAPSession sourceSession = (LDAPSession)sourceDirectory.getSession();
            sctls = sourceDirectory.getSearchControls();
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("LDAPReference.getSourceIdsForTarget(%s): LDAP search search base='%s' filter='%s' args='%s' scope='%s' [%s]", new Object[]{targetId, searchBaseDn, filterExpr, StringUtils.join((Object[])filterArgs, (String)", "), sctls.getSearchScope(), this}));
                }
                try (NamingEnumeration<SearchResult> results = sourceSession.dirContext.search(searchBaseDn, filterExpr, filterArgs, sctls);){
                    while (results.hasMore()) {
                        Object value;
                        Attributes attributes = results.next().getAttributes();
                        Attribute attr = attributes.get(sourceSession.idAttribute);
                        if (attr == null || (value = attr.get()) == null) continue;
                        sourceIds.add(value.toString());
                    }
                }
            }
            catch (NamingException e) {
                throw new DirectoryException("error during reference search for " + (String)filterArgs[0], (Throwable)e);
            }
            finally {
                sourceSession.close();
            }
        }
        if ((dynamicAttributeId = this.dynamicAttributeId) != null) {
            LDAPDirectory sourceDirectory = this.getSourceLDAPDirectory();
            LDAPDirectory targetDirectory = this.getTargetLDAPDirectory();
            String searchBaseDn = sourceDirectory.getConfig().getSearchBaseDn();
            LDAPSession sourceSession = (LDAPSession)sourceDirectory.getSession();
            LDAPSession targetSession = (LDAPSession)targetDirectory.getSession();
            try {
                if (targetLdapEntry == null) {
                    targetLdapEntry = targetSession.getLdapEntry(targetId, true);
                }
                if (targetLdapEntry == null) {
                    String msg = String.format("Failed to perform inverse lookup on LDAPReference resolving field '%s' of '%s' to entries of '%s' using the dynamic content of attribute '%s': entry '%s' cannot be found in '%s'", new Object[]{this.fieldName, sourceDirectory, this.targetDirectoryName, dynamicAttributeId, targetId, this.targetDirectoryName});
                    throw new DirectoryException(msg);
                }
                targetDn = LDAPReference.pseudoNormalizeDn(targetLdapEntry.getNameInNamespace());
                Attributes targetAttributes = targetLdapEntry.getAttributes();
                sctls = sourceDirectory.getSearchControls();
                String filterExpr = String.format("%s=*", dynamicAttributeId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("LDAPReference.getSourceIdsForTarget(%s): LDAP search search base='%s' filter='%s' scope='%s' [%s]", new Object[]{targetId, searchBaseDn, filterExpr, sctls.getSearchScope(), this}));
                }
                try (NamingEnumeration<SearchResult> results = sourceSession.dirContext.search(searchBaseDn, filterExpr, sctls);){
                    while (results.hasMore()) {
                        Attributes sourceAttributes = results.next().getAttributes();
                        try (NamingEnumeration<?> ldapUrls = sourceAttributes.get(dynamicAttributeId).getAll();){
                            while (ldapUrls.hasMore()) {
                                int urlDnSize;
                                int targetDnSize;
                                LdapURL ldapUrl = new LdapURL(ldapUrls.next().toString());
                                String candidateDN = LDAPReference.pseudoNormalizeDn(ldapUrl.getDN());
                                if (!targetDn.endsWith(candidateDN) || "onelevel".equals(ldapUrl.getScope()) && (targetDnSize = new LdapName(targetDn).size()) - (urlDnSize = new LdapName(candidateDN).size()) > 1 || !this.getFilterMatcher().match(targetAttributes, ldapUrl.getFilter())) continue;
                                sourceIds.add(sourceAttributes.get(sourceSession.idAttribute).get().toString());
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new DirectoryException("error during reference search for " + targetId, (Throwable)e);
            }
            finally {
                sourceSession.close();
                targetSession.close();
            }
        }
        if (this.dynamicReferences != null && this.dynamicReferences.length > 0) {
            log.error((Object)"This kind of reference is not supported.");
        }
        return new ArrayList<String>(sourceIds);
    }

    public List<String> getTargetIdsForSource(String sourceId) throws DirectoryException {
        Session session = this.getSourceDirectory().getSession();
        String schemaName = this.getSourceDirectory().getSchema();
        try {
            List list = (List)session.getEntry(sourceId).getProperty(schemaName, this.fieldName);
            return list;
        }
        catch (ClientException e) {
            throw new DirectoryException((Throwable)e);
        }
        finally {
            session.close();
        }
    }

    protected static String pseudoNormalizeDn(String dn) throws InvalidNameException {
        LdapName ldapName = new LdapName(dn);
        ArrayList<String> rdns = new ArrayList<String>();
        for (Rdn rdn : ldapName.getRdns()) {
            String value = rdn.getValue().toString().toLowerCase().replaceAll(",", "\\\\,");
            String rdnStr = rdn.getType().toLowerCase() + "=" + value;
            rdns.add(0, rdnStr);
        }
        return StringUtils.join(rdns, (char)',');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLdapTargetIds(Attributes attributes) throws DirectoryException {
        TreeSet<String> targetIds = new TreeSet<String>();
        LDAPDirectory targetDirectory = (LDAPDirectory)this.getTargetDirectory();
        LDAPDirectoryDescriptor targetDirconfig = this.getTargetDirectoryDescriptor();
        LDAPSession targetSession = (LDAPSession)targetDirectory.getSession();
        String emptyRefMarker = targetDirectory.getConfig().getEmptyRefMarker();
        try {
            String baseDn = LDAPReference.pseudoNormalizeDn(targetDirconfig.getSearchBaseDn());
            String staticAttributeId = this.getStaticAttributeId();
            Attribute staticAttribute = null;
            if (staticAttributeId != null) {
                staticAttribute = attributes.get(staticAttributeId);
            }
            if (staticAttribute != null && !this.staticAttributeIdIsDn) {
                try (NamingEnumeration<?> staticContent = staticAttribute.getAll();){
                    while (staticContent.hasMore()) {
                        String value = staticContent.next().toString();
                        if (emptyRefMarker.equals(value)) continue;
                        targetIds.add(value);
                    }
                }
            }
            if (staticAttribute != null && this.staticAttributeIdIsDn) {
                try (NamingEnumeration<?> targetDns = staticAttribute.getAll();){
                    while (targetDns.hasMore()) {
                        String targetDn = targetDns.next().toString();
                        if (!LDAPReference.pseudoNormalizeDn(targetDn).endsWith(baseDn)) {
                            if (!log.isTraceEnabled()) continue;
                            log.trace((Object)String.format("ignoring: dn='%s' (does not match '%s') for '%s'", new Object[]{targetDn, baseDn, this}));
                            continue;
                        }
                        String id = null;
                        if (targetSession.rdnMatchesIdField()) {
                            LdapName name = new LdapName(targetDn);
                            String rdn = name.get(name.size() - 1);
                            int pos = rdn.indexOf("=");
                            id = rdn.substring(pos + 1);
                        } else {
                            id = this.getIdForDn(targetSession, targetDn);
                            if (id == null) {
                                log.warn((Object)String.format("ignoring target '%s' (missing attribute '%s') while resolving reference '%s'", new Object[]{targetDn, targetSession.idAttribute, this}));
                                continue;
                            }
                        }
                        if (this.forceDnConsistencyCheck && !targetSession.hasEntry(id)) {
                            if (!log.isTraceEnabled()) continue;
                            log.trace((Object)String.format("ignoring target '%s' when resolving '%s' (not part of target directory by forced DN consistency check)", new Object[]{targetDn, this}));
                            continue;
                        }
                        if (id == null) continue;
                        targetIds.add(id);
                    }
                }
            }
            String dynamicAttributeId = this.dynamicAttributeId;
            Attribute dynamicAttribute = null;
            if (dynamicAttributeId != null) {
                dynamicAttribute = attributes.get(dynamicAttributeId);
            }
            if (dynamicAttribute != null) {
                try (NamingEnumeration<?> rawldapUrls = dynamicAttribute.getAll();){
                    while (rawldapUrls.hasMore()) {
                        LdapURL ldapUrl = new LdapURL(rawldapUrls.next().toString());
                        String linkDn = LDAPReference.pseudoNormalizeDn(ldapUrl.getDN());
                        String directoryDn = LDAPReference.pseudoNormalizeDn(targetDirconfig.getSearchBaseDn());
                        int scope = 1;
                        String scopePart = ldapUrl.getScope();
                        if (scopePart != null && scopePart.toLowerCase().startsWith("sub")) {
                            scope = 2;
                        }
                        if (!linkDn.endsWith(directoryDn) && !directoryDn.endsWith(linkDn) || directoryDn.endsWith(linkDn) && linkDn.length() < directoryDn.length() && scope == 1) continue;
                        targetIds.addAll(this.getReferencedElements(attributes, directoryDn, linkDn, ldapUrl.getFilter(), scope));
                    }
                }
            }
            if (this.dynamicReferences != null && this.dynamicReferences.length > 0) {
                LDAPDynamicReferenceDescriptor dynAtt = this.dynamicReferences[0];
                Attribute baseDnsAttribute = attributes.get(dynAtt.baseDN);
                Attribute filterAttribute = attributes.get(dynAtt.filter);
                if (baseDnsAttribute != null && filterAttribute != null) {
                    NamingEnumeration<?> baseDns = null;
                    NamingEnumeration<?> filters = null;
                    try {
                        baseDns = baseDnsAttribute.getAll();
                        String linkDnValue = baseDns.next().toString();
                        baseDns.close();
                        linkDnValue = LDAPReference.pseudoNormalizeDn(linkDnValue);
                        filters = filterAttribute.getAll();
                        String filterValue = filters.next().toString();
                        filters.close();
                        int scope = "subtree".equalsIgnoreCase(dynAtt.type) ? 2 : 1;
                        String directoryDn = LDAPReference.pseudoNormalizeDn(targetDirconfig.getSearchBaseDn());
                        if (!(!linkDnValue.endsWith(directoryDn) && !directoryDn.endsWith(linkDnValue) || directoryDn.endsWith(linkDnValue) && linkDnValue.length() < directoryDn.length() && scope == 1)) {
                            filterValue = FilterExpressionCorrector.correctFilter(filterValue, FilterExpressionCorrector.FilterJobs.CORRECT_NOT);
                            targetIds.addAll(this.getReferencedElements(attributes, directoryDn, linkDnValue, filterValue, scope));
                        }
                    }
                    finally {
                        if (baseDns != null) {
                            baseDns.close();
                        }
                        if (filters != null) {
                            filters.close();
                        }
                    }
                }
            }
            ArrayList<String> arrayList = new ArrayList<String>(targetIds);
            return arrayList;
        }
        catch (NamingException e) {
            throw new DirectoryException("error computing LDAP references", (Throwable)e);
        }
        finally {
            targetSession.close();
        }
    }

    protected String getIdForDn(LDAPSession session, String dn) {
        Attributes entry;
        Object[] attributeIdsToCollect = new String[]{session.idAttribute};
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("LDAPReference.getIdForDn(session, %s): LDAP get dn='%s' attribute ids to collect='%s' [%s]", new Object[]{dn, dn, StringUtils.join((Object[])attributeIdsToCollect, (String)", "), this}));
            }
            Name name = new CompositeName().add(dn);
            entry = session.dirContext.getAttributes(name, (String[])attributeIdsToCollect);
        }
        catch (NamingException e) {
            return null;
        }
        Attribute attr = entry.get(session.idAttribute);
        if (attr != null) {
            try {
                return attr.get().toString();
            }
            catch (NamingException e) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getReferencedElements(Attributes attributes, String directoryDn, String linkDn, String filter, int scope) throws DirectoryException, NamingException {
        TreeSet<String> targetIds = new TreeSet<String>();
        LDAPDirectoryDescriptor targetDirconfig = this.getTargetDirectoryDescriptor();
        LDAPDirectory targetDirectory = (LDAPDirectory)this.getTargetDirectory();
        LDAPSession targetSession = (LDAPSession)targetDirectory.getSession();
        String dn = directoryDn.endsWith(linkDn) && directoryDn.length() > linkDn.length() ? directoryDn : linkDn;
        SearchControls scts = new SearchControls();
        scts.setSearchScope(Math.min(scope, targetDirconfig.getSearchScope()));
        scts.setReturningAttributes(new String[]{targetSession.idAttribute});
        String targetFilter = targetDirconfig.getSearchFilter();
        if (filter == null || filter.length() == 0) {
            filter = targetFilter;
        } else if (targetFilter != null && targetFilter.length() > 0) {
            filter = String.format("(&(%s)(%s))", targetFilter, filter);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("LDAPReference.getLdapTargetIds(%s): LDAP search dn='%s'  filter='%s' scope='%s' [%s]", new Object[]{attributes, dn, dn, scts.getSearchScope(), this}));
        }
        Name name = new CompositeName().add(dn);
        try (NamingEnumeration<SearchResult> results = targetSession.dirContext.search(name, filter, scts);){
            while (results.hasMore()) {
                String collectedId;
                Attribute attr = results.next().getAttributes().get(targetSession.idAttribute);
                if (attr == null || (collectedId = attr.get().toString()) == null) continue;
                targetIds.add(collectedId);
            }
        }
        return targetIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLinksForSource(String sourceId) throws DirectoryException {
        block24: {
            LDAPDirectory targetDirectory = (LDAPDirectory)this.getTargetDirectory();
            LDAPDirectory sourceDirectory = (LDAPDirectory)this.getSourceDirectory();
            LDAPSession sourceSession = (LDAPSession)sourceDirectory.getSession();
            LDAPSession targetSession = (LDAPSession)targetDirectory.getSession();
            String attributeId = this.getStaticAttributeId();
            try {
                if (sourceSession.isReadOnly() || attributeId == null) {
                    return;
                }
                SearchResult sourceLdapEntry = sourceSession.getLdapEntry(sourceId);
                if (sourceLdapEntry == null) {
                    throw new DirectoryException(String.format("cannot edit the links hold by missing entry '%s' in directory '%s'", sourceId, sourceDirectory.getName()));
                }
                String sourceDn = LDAPReference.pseudoNormalizeDn(sourceLdapEntry.getNameInNamespace());
                Attribute oldAttr = sourceLdapEntry.getAttributes().get(attributeId);
                if (oldAttr == null) {
                    oldAttr = new BasicAttribute(attributeId);
                }
                BasicAttribute attrToRemove = new BasicAttribute(attributeId);
                String targetBaseDn = LDAPReference.pseudoNormalizeDn(targetDirectory.getConfig().getSearchBaseDn());
                try (NamingEnumeration<?> oldAttrs = oldAttr.getAll();){
                    while (oldAttrs.hasMore()) {
                        String targetKeyAttr = oldAttrs.next().toString();
                        if (this.staticAttributeIdIsDn) {
                            String dn = LDAPReference.pseudoNormalizeDn(targetKeyAttr);
                            if (this.forceDnConsistencyCheck) {
                                String id = this.getIdForDn(targetSession, dn);
                                if (id == null || !targetSession.hasEntry(id)) continue;
                                attrToRemove.add(dn);
                                continue;
                            }
                            if (!dn.endsWith(targetBaseDn)) continue;
                            attrToRemove.add(dn);
                            continue;
                        }
                        attrToRemove.add(targetKeyAttr);
                    }
                }
                try {
                    if (attrToRemove.size() == oldAttr.size()) {
                        String emptyRefMarker = sourceDirectory.getConfig().getEmptyRefMarker();
                        BasicAttributes emptyAttribute = new BasicAttributes(attributeId, emptyRefMarker);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("LDAPReference.removeLinksForSource(%s): LDAP modifyAttributes key='%s'  mod_op='REPLACE_ATTRIBUTE' attrs='%s' [%s]", new Object[]{sourceId, sourceDn, emptyAttribute, this}));
                        }
                        sourceSession.dirContext.modifyAttributes(sourceDn, 2, (Attributes)emptyAttribute);
                    } else if (attrToRemove.size() > 0) {
                        BasicAttributes attrsToRemove = new BasicAttributes();
                        attrsToRemove.put(attrToRemove);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("LDAPReference.removeLinksForSource(%s): LDAP modifyAttributes dn='%s'  mod_op='REMOVE_ATTRIBUTE' attrs='%s' [%s]", new Object[]{sourceId, sourceDn, attrsToRemove, this}));
                        }
                        sourceSession.dirContext.modifyAttributes(sourceDn, 3, (Attributes)attrsToRemove);
                    }
                }
                catch (SchemaViolationException e) {
                    if (this.isDynamic()) {
                        log.warn((Object)String.format("cannot remove dynamic reference in field %s for source %s", this.getFieldName(), sourceId));
                        break block24;
                    }
                    throw new DirectoryException((Throwable)e);
                }
            }
            catch (NamingException e) {
                throw new DirectoryException("removeLinksForSource failed: " + e.getMessage(), (Throwable)e);
            }
            finally {
                sourceSession.close();
                targetSession.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeLinksForTarget(String targetId) throws DirectoryException {
        if (!this.isStatic()) {
            return;
        }
        LDAPDirectory targetDirectory = (LDAPDirectory)this.getTargetDirectory();
        LDAPSession targetSession = (LDAPSession)targetDirectory.getSession();
        LDAPDirectory sourceDirectory = (LDAPDirectory)this.getSourceDirectory();
        LDAPSession sourceSession = (LDAPSession)sourceDirectory.getSession();
        String attributeId = this.getStaticAttributeId();
        try {
            String targetAttributeValue;
            if (sourceSession.isReadOnly()) return;
            if (this.staticAttributeIdIsDn) {
                SearchResult targetLdapEntry = targetSession.getLdapEntry(targetId);
                if (targetLdapEntry == null) {
                    String rdnAttribute = targetDirectory.getConfig().getRdnAttribute();
                    if (!rdnAttribute.equals(targetSession.idAttribute)) {
                        log.warn((Object)String.format("cannot remove links to missing entry %s in directory %s for reference %s", new Object[]{targetId, targetDirectory.getName(), this}));
                        return;
                    }
                    targetAttributeValue = String.format("%s=%s,%s", rdnAttribute, targetId, targetDirectory.getConfig().getSearchBaseDn());
                } else {
                    targetAttributeValue = LDAPReference.pseudoNormalizeDn(targetLdapEntry.getNameInNamespace());
                }
            } else {
                targetAttributeValue = targetId;
            }
            String searchFilter = String.format("(%s=%s)", attributeId, targetAttributeValue);
            String sourceFilter = sourceDirectory.getBaseFilter();
            if (sourceFilter != null && !"".equals(sourceFilter)) {
                searchFilter = String.format("(&(%s)(%s))", searchFilter, sourceFilter);
            }
            SearchControls scts = new SearchControls();
            scts.setSearchScope(sourceDirectory.getConfig().getSearchScope());
            scts.setReturningAttributes(new String[]{attributeId});
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("LDAPReference.removeLinksForTarget(%s): LDAP search baseDn='%s'  filter='%s' scope='%s' [%s]", new Object[]{targetId, sourceSession.searchBaseDn, searchFilter, scts.getSearchScope(), this}));
            }
            NamingEnumeration<SearchResult> results = sourceSession.dirContext.search(sourceSession.searchBaseDn, searchFilter, scts);
            String emptyRefMarker = sourceDirectory.getConfig().getEmptyRefMarker();
            BasicAttributes emptyAttribute = new BasicAttributes(attributeId, emptyRefMarker);
            block11: while (true) {
                while (results.hasMore()) {
                    SearchResult result = results.next();
                    Attributes attrs = result.getAttributes();
                    Attribute attr = attrs.get(attributeId);
                    try {
                        if (attr.size() == 1) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("LDAPReference.removeLinksForTarget(%s): LDAP modifyAttributes key='%s' mod_op='ADD_ATTRIBUTE' attrs='%s' [%s]", new Object[]{targetId, result.getNameInNamespace(), attrs, this}));
                            }
                            sourceSession.dirContext.modifyAttributes(result.getNameInNamespace(), 1, (Attributes)emptyAttribute);
                        }
                        attrs = new BasicAttributes();
                        attr = new BasicAttribute(attributeId);
                        attr.add(targetAttributeValue);
                        attrs.put(attr);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("LDAPReference.removeLinksForTarget(%s): LDAP modifyAttributes key='%s' mod_op='REMOVE_ATTRIBUTE' attrs='%s' [%s]", new Object[]{targetId, result.getNameInNamespace(), attrs, this}));
                        }
                        sourceSession.dirContext.modifyAttributes(result.getNameInNamespace(), 3, attrs);
                        continue block11;
                    }
                    catch (SchemaViolationException e) {
                        if (!this.isDynamic()) throw new DirectoryException((Throwable)e);
                        log.warn((Object)String.format("cannot remove dynamic reference in field %s for target %s", this.getFieldName(), targetId));
                        continue;
                        return;
                    }
                }
            }
            finally {
                results.close();
            }
        }
        catch (NamingException e) {
            throw new DirectoryException("removeLinksForTarget failed: " + e.getMessage(), (Throwable)e);
        }
        finally {
            sourceSession.close();
            targetSession.close();
        }
    }

    public void setSourceIdsForTarget(String targetId, List<String> sourceIds) throws DirectoryException {
        this.removeLinksForTarget(targetId);
        this.addLinks(sourceIds, targetId);
    }

    public void setTargetIdsForSource(String sourceId, List<String> targetIds) throws DirectoryException {
        this.removeLinksForSource(sourceId);
        this.addLinks(sourceId, targetIds);
    }

    public String toString() {
        return String.format("LDAPReference to resolve field='%s' of sourceDirectory='%s' with targetDirectory='%s' and staticAttributeId='%s', dynamicAttributeId='%s'", this.fieldName, this.sourceDirectoryName, this.targetDirectoryName, this.staticAttributeId, this.dynamicAttributeId);
    }

    protected AbstractReference newInstance() {
        return new LDAPReference();
    }

    public LDAPReference clone() {
        LDAPReference clone = (LDAPReference)super.clone();
        clone.forceDnConsistencyCheck = this.forceDnConsistencyCheck;
        clone.staticAttributeIdIsDn = this.staticAttributeIdIsDn;
        clone.staticAttributeId = this.staticAttributeId;
        clone.dynamicAttributeId = this.dynamicAttributeId;
        clone.fieldName = this.fieldName;
        return clone;
    }
}

