/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.AjaxScript;
import org.ajax4jsf.javascript.PrototypeScript;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.renderkit.RendererBase;
import org.ajax4jsf.renderkit.RendererUtils;
import org.ajax4jsf.resource.InternetResource;
import org.richfaces.component.UIComponentControl;
import org.richfaces.component.util.HtmlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentControlRendererBase
extends HeaderResourcesRendererBase {
    private static final String IMMEDIATE = "immediate";
    private static final String ON_AVAILABLE = "onavailable";
    private static final String ON_LOAD = "onload";
    private final InternetResource[] additionalScripts = new InternetResource[]{new PrototypeScript(), new AjaxScript(), this.getResource("/org/richfaces/renderkit/html/scripts/available.js")};

    protected Class<UIComponentControl> getComponentClass() {
        return UIComponentControl.class;
    }

    protected void checkValidity(String clientId, String name, String attachTiming, String forAttr, String operation) {
        if (!(ON_LOAD.equals(attachTiming) || IMMEDIATE.equals(attachTiming) || ON_AVAILABLE.equals(attachTiming))) {
            throw new FacesException("The attachTiming attribute of the controlComponent  (id='" + clientId + "') has an invalid value:'" + attachTiming + "'. It may have only the following values: '" + IMMEDIATE + "', '" + ON_LOAD + "', '" + ON_AVAILABLE + "'");
        }
        if (operation == null || operation.trim().length() == 0) {
            throw new FacesException("The operation attribute of the controlComponent (id='" + clientId + "') must be specified");
        }
    }

    protected String replaceClientIds(FacesContext context, UIComponent component, String selector) {
        return HtmlUtil.expandIdSelector((String)HtmlUtil.idsToIdSelector((String)selector), (UIComponent)component, (FacesContext)context);
    }

    protected void attachEventAccordingToTimingOption(FacesContext context, UIComponent component) throws IOException {
        if (!(component instanceof UIComponentControl)) {
            return;
        }
        UIComponentControl componentControl = (UIComponentControl)component;
        String attachTo = componentControl.getAttachTo();
        String attachTiming = componentControl.getAttachTiming();
        boolean isImmediate = attachTiming.equals(IMMEDIATE);
        boolean isOnLoad = attachTiming.equals(ON_LOAD);
        boolean isOnAvailable = attachTiming.equals(ON_AVAILABLE);
        if (!(isImmediate || isOnLoad || isOnAvailable || attachTo == null || attachTo.length() == 0)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)componentControl);
        writer.startElement("script", (UIComponent)componentControl);
        this.getUtils().writeAttribute(writer, "type", (Object)"text/javascript");
        writer.writeText((Object)"//", null);
        writer.write("<![CDATA[");
        String attachEventBodyStart = "\n{\n    Richfaces.componentControl.attachEvent('";
        StringBuilder attachEventBodyEnd = new StringBuilder();
        attachEventBodyEnd.append("', '");
        attachEventBodyEnd.append(ComponentControlRendererBase.convertToString(variables.getVariable("event")));
        attachEventBodyEnd.append("', '");
        attachEventBodyEnd.append(ComponentControlRendererBase.convertToString(variables.getVariable("forAttr")));
        attachEventBodyEnd.append("', '");
        attachEventBodyEnd.append(ComponentControlRendererBase.convertToString(variables.getVariable("operation")));
        attachEventBodyEnd.append("', function() { return {");
        attachEventBodyEnd.append(ComponentControlRendererBase.convertToString(variables.getVariable("params")));
        attachEventBodyEnd.append("}; }, ");
        attachEventBodyEnd.append(ComponentControlRendererBase.convertToString(componentControl.isDisableDefault()));
        attachEventBodyEnd.append(");\n }");
        String pattern = "\\s*,\\s*";
        String[] result = attachTo.split(pattern);
        for (int i = 0; i < result.length; ++i) {
            if (isOnLoad) {
                writer.write("\n jQuery(document).ready(function()");
            } else if (isOnAvailable) {
                UIComponent target = RendererUtils.getInstance().findComponentFor(context, component, result[i]);
                String clientId = target != null ? target.getClientId(context) : result[i];
                writer.write("\n Richfaces.onAvailable('" + clientId + "', function()");
            } else if (isImmediate) {
                // empty if block
            }
            writer.write(attachEventBodyStart);
            writer.write(this.getUtils().escapeJavaScript((Object)this.replaceClientIds(context, component, result[i])));
            writer.write(attachEventBodyEnd.toString());
            if (!isOnLoad && !isOnAvailable) continue;
            writer.write(");");
        }
        writer.writeText((Object)"//", null);
        writer.write("]]>");
        writer.endElement("script");
    }

    protected InternetResource[] getScripts() {
        return this.additionalScripts;
    }

    private static String convertToString(Object obj) {
        return obj == null ? "" : obj.toString();
    }
}

