/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types;

import org.nuxeo.ecm.core.schema.types.AbstractType;
import org.nuxeo.ecm.core.schema.types.Constraint;
import org.nuxeo.ecm.core.schema.types.SimpleType;
import org.nuxeo.ecm.core.schema.types.TypeException;

public class SimpleTypeImpl
extends AbstractType
implements SimpleType {
    private static final long serialVersionUID = 1L;
    protected Constraint[] constraints;
    private SimpleType primitiveType;

    public SimpleTypeImpl(SimpleType superType, String schema, String name) {
        super(superType, schema, name);
        assert (superType != null);
    }

    protected boolean validateConstraints(Object object) {
        if (this.constraints != null) {
            for (Constraint constraint : this.constraints) {
                if (constraint.validate(object)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean validate(Object object) throws TypeException {
        if (object == null) {
            return true;
        }
        if (this.validateConstraints(object)) {
            return this.getSuperType().validate(object);
        }
        return false;
    }

    public void setConstraints(Constraint[] constraints) {
        this.constraints = constraints;
    }

    public Constraint[] getConstraints() {
        return this.constraints;
    }

    @Override
    public SimpleType getPrimitiveType() {
        if (this.primitiveType == null) {
            this.primitiveType = ((SimpleType)this.getSuperType()).getPrimitiveType();
        }
        return this.primitiveType;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isSimpleType() {
        return true;
    }

    @Override
    public Object decode(String str) {
        return this.getPrimitiveType().decode(str);
    }

    @Override
    public String encode(Object value) {
        return this.getPrimitiveType().encode(value);
    }

    @Override
    public Object convert(Object value) throws TypeException {
        return this.getPrimitiveType().convert(value);
    }

    @Override
    public Object newInstance() {
        return this.getPrimitiveType().newInstance();
    }
}

