/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types.primitives;

import org.nuxeo.ecm.core.schema.types.PrimitiveType;

public final class LongType
extends PrimitiveType {
    private static final long serialVersionUID = 1L;
    public static final String ID = "long";
    public static final LongType INSTANCE = new LongType();

    private LongType() {
        super(ID);
    }

    @Override
    public boolean validate(Object object) {
        return object instanceof Number;
    }

    @Override
    public Object convert(Object value) {
        if (value instanceof Long) {
            return value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        try {
            return Long.valueOf((String)value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public Object decode(String str) {
        if (str == null) {
            return null;
        }
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Override
    public String encode(Object object) {
        if (object instanceof Long) {
            return object.toString();
        }
        if (object instanceof Number) {
            return object.toString();
        }
        return object != null ? (String)object : "";
    }

    protected Object readResolve() {
        return INSTANCE;
    }
}

