/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.ValidationEventHandler;
import org.apache.commons.io.IOUtils;
import yarfraw.core.datamodel.ChannelFeed;
import yarfraw.core.datamodel.FeedFormat;
import yarfraw.core.datamodel.YarfrawException;
import yarfraw.generated.rss20.elements.ObjectFactory;
import yarfraw.generated.rss20.elements.TRss;
import yarfraw.generated.rss20.elements.TRssChannel;
import yarfraw.io.AbstractBaseIO;
import yarfraw.mapping.forward.impl.ToAtom10ChannelImpl;
import yarfraw.mapping.forward.impl.ToRss10ChannelImpl;
import yarfraw.mapping.forward.impl.ToRss20ChannelImpl;
import yarfraw.utils.JAXBUtils;

public class FeedWriter
extends AbstractBaseIO {
    private static final ObjectFactory RSS20_FACTORY = new ObjectFactory();

    public FeedWriter(File file, FeedFormat format) {
        super(file, format);
    }

    public FeedWriter(String pathName, FeedFormat format) {
        super(new File(pathName), format);
    }

    public FeedWriter(URI uri, FeedFormat format) {
        super(new File(uri), format);
    }

    public FeedWriter(File file) {
        super(file);
    }

    public FeedWriter(String pathName) {
        this(new File(pathName));
    }

    public FeedWriter(URI uri) {
        this(new File(uri));
    }

    public void writeChannel(ChannelFeed channel) throws YarfrawException {
        this.writeChannel(channel, null);
    }

    public static void writeChannel(FeedFormat format, ChannelFeed channel, OutputStream outputStream) throws YarfrawException {
        if (format == null || channel == null || outputStream == null) {
            throw new YarfrawException("format, channel, or outputStream is null");
        }
        try {
            Marshaller m = FeedWriter.getMarshaller(format);
            m.marshal(FeedWriter.getJaxbElementFromFormat(format, channel), outputStream);
        }
        catch (JAXBException e) {
            throw new YarfrawException("Unable to write channel", e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeChannel(ChannelFeed channel, ValidationEventHandler validationEventHandler) throws YarfrawException {
        FileOutputStream out = null;
        try {
            Marshaller m = FeedWriter.getMarshaller(this._format);
            if (validationEventHandler != null) {
                m.setEventHandler(validationEventHandler);
            }
            out = new FileOutputStream(this._file);
            m.marshal(FeedWriter.getJaxbElementFromFormat(this._format, channel), (OutputStream)out);
        }
        catch (JAXBException e) {
            try {
                throw new YarfrawException("Unable to write channel", e);
                catch (FileNotFoundException e2) {
                    throw new YarfrawException("Unable to write channel", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    private static Object getJaxbElementFromFormat(FeedFormat format, ChannelFeed channel) throws YarfrawException {
        if (format == FeedFormat.RSS20) {
            TRss rss = RSS20_FACTORY.createTRss();
            rss.setVersion(2.0);
            rss.setChannel((TRssChannel)((JAXBElement)ToRss20ChannelImpl.getInstance().execute(channel)).getValue());
            return RSS20_FACTORY.createRss(rss);
        }
        if (format == FeedFormat.RSS10) {
            return ToRss10ChannelImpl.getInstance().execute(channel);
        }
        if (format == FeedFormat.ATOM10) {
            return ToAtom10ChannelImpl.getInstance().execute(channel);
        }
        if (format == FeedFormat.ATOM03) {
            throw new UnsupportedOperationException("Yarfraw does not support writting to Atom 0.3 format, use Atom 1.0 instead.");
        }
        throw new UnsupportedOperationException("Unknown Feed Format");
    }

    private static Marshaller getMarshaller(FeedFormat format) throws JAXBException {
        JAXBContext context = JAXBUtils.getContext(format);
        Marshaller m = context.createMarshaller();
        m.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)JAXBUtils.getNamespacePrefixMapper(format));
        return m;
    }
}

